/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.enums;

import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.utils.StringUtils;

public enum RangeMappingEnum {
    ONLY(new MultiLangEnumBridge("\u4ec5\u81ea\u5df1", "RangeMappingEnum_0", "epm-eb-common"), "This", 10),
    ALL_EXCLUDE(new MultiLangEnumBridge("\u6240\u6709\u4e0b\u7ea7_\u542b\u81ea\u5df1", "RangeMappingEnum_3", "epm-eb-common"), "Children", 40);

    private MultiLangEnumBridge bridge;
    private String number;
    private int index;

    private RangeMappingEnum(MultiLangEnumBridge bridge, String number, int index) {
        this.bridge = bridge;
        this.number = number;
        this.index = index;
    }

    public String getName() {
        return this.bridge.loadKDString();
    }

    public String getNumber() {
        return this.number;
    }

    public int getIndex() {
        return this.index;
    }

    public String getIndStr() {
        return String.valueOf(this.index);
    }

    public static RangeMappingEnum getRangeByName(String name) {
        for (RangeMappingEnum r : RangeMappingEnum.values()) {
            if (!r.bridge.loadKDString().equals(name)) continue;
            return r;
        }
        return null;
    }

    public static RangeMappingEnum getRangeByVal(String val) {
        if (StringUtils.isEmpty(val)) {
            return null;
        }
        try {
            int _val = Integer.parseInt(val);
            for (RangeMappingEnum r : RangeMappingEnum.values()) {
                if (r.index != _val) continue;
                return r;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

