/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.enums.dimensionEnums;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.utils.CollectionUtils;

public enum MetricDataTypeEnum {
    CURRENCY(new MultiLangEnumBridge("\u8d27\u5e01", "MetricDataTypeEnum_0", "epm-eb-common"), "1", 7),
    NONMONETARY(new MultiLangEnumBridge("\u6570\u503c", "MetricDataTypeEnum_7", "epm-eb-common"), "2", 7),
    TEXT(new MultiLangEnumBridge("\u6587\u672c", "MetricDataTypeEnum_2", "epm-eb-common"), "3", 9),
    DATE(new MultiLangEnumBridge("\u65e5\u671f", "MetricDataTypeEnum_3", "epm-eb-common"), "4", 9),
    RATE(new MultiLangEnumBridge("\u767e\u5206\u6bd4", "MetricDataTypeEnum_4", "epm-eb-common"), "5", 7),
    ENUM(new MultiLangEnumBridge("\u679a\u4e3e", "MetricDataTypeEnum_5", "epm-eb-common"), "6", 9),
    DIFF(new MultiLangEnumBridge("\u540c\u6bd4\u5dee\u989d", "MetricDataTypeEnum_6", "epm-eb-common"), "7", 7);

    private final MultiLangEnumBridge bridge;
    private final String index;
    private final int algoType;
    private static final Set<String> NOT_NUMBER;
    private static final Set<String> IS_STRING;
    private static final Map<String, MetricDataTypeEnum> ENUMMAP;

    private MetricDataTypeEnum(MultiLangEnumBridge bridge, String index, int algoType) {
        this.bridge = bridge;
        this.index = index;
        this.algoType = algoType;
    }

    public static int getAlgoDataType(String index) {
        MetricDataTypeEnum typeEnum = MetricDataTypeEnum.getByIndex(index);
        if (typeEnum != null) {
            return typeEnum.algoType;
        }
        return 7;
    }

    public String getAlias() {
        return this.bridge.loadKDString();
    }

    public String getIndex() {
        return this.index;
    }

    public static boolean isNumber(String dataType) {
        return !NOT_NUMBER.contains(dataType);
    }

    public static boolean isString(String dataType) {
        return IS_STRING.contains(dataType);
    }

    public static boolean isDate(String dataType) {
        return DATE.getIndex().equals(dataType);
    }

    public static MetricDataTypeEnum getByIndex(String index) {
        return ENUMMAP.get(index);
    }

    public static MetricDataTypeEnum getByIndex(int index) {
        return ENUMMAP.get(String.valueOf(index));
    }

    static {
        NOT_NUMBER = CollectionUtils.asSet(TEXT.getIndex(), DATE.getIndex(), ENUM.getIndex());
        IS_STRING = CollectionUtils.asSet(TEXT.getIndex(), ENUM.getIndex());
        ENUMMAP = Maps.newHashMap();
        for (MetricDataTypeEnum _enum : MetricDataTypeEnum.values()) {
            ENUMMAP.put(_enum.getIndex(), _enum);
        }
    }
}

