/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.enums.ruleFunctionEnums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.enums.MultiLangEnumBridge;
import kd.epm.eb.common.enums.ruleFunctionEnums.RuleFunctionTypeEnum;

public enum RuleFunctionEnum {
    Attribute("Attribute", "AB", RuleFunctionTypeEnum.Relation, RuleFunctionEnum.getAttribute(), true),
    Ancestor("Ancestor", "ACT", RuleFunctionTypeEnum.Relation, RuleFunctionEnum.getAncestor(), true),
    GetAttribute("GetAttribute", "GAB", RuleFunctionTypeEnum.Relation, RuleFunctionEnum.getGetAttribute(), true),
    List("List", "List", RuleFunctionTypeEnum.Relation, RuleFunctionEnum.getList(), true),
    Children("Children", "CHD", RuleFunctionTypeEnum.Relation, RuleFunctionEnum.getChildren(), true),
    Relative("Relative", "RE", RuleFunctionTypeEnum.Relation, RuleFunctionEnum.getRelative(), true),
    Sibling("Sibling", "SL", RuleFunctionTypeEnum.Relation, RuleFunctionEnum.getSibling(), true),
    Parent("Parent", "PAR", RuleFunctionTypeEnum.Relation, RuleFunctionEnum.getParent(), true),
    CurrMBR("CurrMBR", "CMBR", RuleFunctionTypeEnum.Relation, RuleFunctionEnum.getCurrMBR(), true),
    Member("Member", "MEM", RuleFunctionTypeEnum.Relation, RuleFunctionEnum.getMember(), true),
    Count("Count", "CT", RuleFunctionTypeEnum.Meth, RuleFunctionEnum.getCount(), false),
    IsAttribute("IsAttribute", "IA", RuleFunctionTypeEnum.Bool, RuleFunctionEnum.getIsAttribute(), false),
    IsChild("IsChild", "IC", RuleFunctionTypeEnum.Bool, RuleFunctionEnum.getIsChild(), false),
    RecognitionP("RecognitionP", "RP", RuleFunctionTypeEnum.Finance, RuleFunctionEnum.getRecognitionP(), true),
    RecognitionPC("RecognitionPC", "RPC", RuleFunctionTypeEnum.Finance, RuleFunctionEnum.getRecognitionPC(), true),
    RecognitionSP("RecognitionSP", "RSP", RuleFunctionTypeEnum.Finance, RuleFunctionEnum.getRecognitionSP(), true),
    Date("Date", "DT", RuleFunctionTypeEnum.DateFun, RuleFunctionEnum.getDate(), true),
    YearValue("YearValue", "YV", RuleFunctionTypeEnum.YearValueFun, RuleFunctionEnum.getYearValue(), true),
    GetNumber("GetNumber", "GNUM", RuleFunctionTypeEnum.String, RuleFunctionEnum.getGetNumber(), true),
    GetName("GetName", "GNAME", RuleFunctionTypeEnum.String, RuleFunctionEnum.getGetName(), true);

    private String name;
    private RuleFunctionTypeEnum functionType;
    private MultiLangEnumBridge explain;
    private String shortName;
    private boolean isCut;
    private boolean enable = true;

    private RuleFunctionEnum(String name, String shortName, RuleFunctionTypeEnum functionType, MultiLangEnumBridge explain, boolean isCut) {
        this.name = name;
        this.functionType = functionType;
        this.explain = explain;
        this.name = name;
        this.shortName = shortName;
        this.isCut = isCut;
    }

    private static MultiLangEnumBridge getAttribute() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u5c5e\u6027\u4e3a\u6307\u5b9a\u5c5e\u6027\u7684\u7ef4\u5ea6\u6210\u5458\u8303\u56f4", "RuleFunctionEnum_13", "epm-eb-common");
    }

    private static MultiLangEnumBridge getGetAttribute() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u6307\u5b9a\u6210\u5458\u6307\u5b9a\u5c5e\u6027\u7684\u5c5e\u6027\u503c", "RuleFunctionEnum_14", "epm-eb-common");
    }

    private static MultiLangEnumBridge getAncestor() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u6307\u5b9a\u7ef4\u6210\u5458\u6307\u5b9a\u5c42\u7ea7\u7684\u6240\u6709\u7956\u5148\u6210\u5458", "RuleFunctionEnum_15", "epm-eb-common");
    }

    private static MultiLangEnumBridge getChildren() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u6307\u5b9a\u7ef4\u6210\u5458\u7684\u6240\u6709\u76f4\u63a5\u4e0b\u7ea7\u6210\u5458", "RuleFunctionEnum_16", "epm-eb-common");
    }

    private static MultiLangEnumBridge getRelative() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u6307\u5b9a\u7ef4\u6210\u5458\u7684\u6240\u6709\u4e0b\u7ea7\u660e\u7ec6\u6210\u5458", "RuleFunctionEnum_8", "epm-eb-common");
    }

    private static MultiLangEnumBridge getSibling() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u6307\u5b9a\u7ef4\u6210\u5458\u7684\u6240\u6709\u5144\u5f1f\u6210\u5458\u4e0d\u542b\u81ea\u5df1", "RuleFunctionEnum_9", "epm-eb-common");
    }

    private static MultiLangEnumBridge getCurrMBR() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u5f53\u524d\u6210\u5458", "RuleFunctionEnum_10", "epm-eb-common");
    }

    private static MultiLangEnumBridge getParent() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u6307\u5b9a\u7ef4\u6210\u5458\u7684\u7236\u9879\u6210\u5458", "RuleFunctionEnum_11", "epm-eb-common");
    }

    private static MultiLangEnumBridge getRecognitionPC() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u5408\u540c\u7b7e\u7ea6\u6536\u6b3e/\u6536\u5165\u5728\u7279\u5b9a\u671f\u95f4\u5185\uff0c\u6bcf\u4e2a\u9884\u7b97\u671f\u95f4\u7684\u786e\u8ba4\u6536\u5165\u503c", "RuleFunctionEnum_0", "epm-eb-common");
    }

    private static MultiLangEnumBridge getRecognitionP() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u5408\u540c\u7b7e\u7ea6\u6536\u6b3e/\u6536\u5165\u5728\u7279\u5b9a\u671f\u95f4\u5185\uff0c\u6bcf\u4e2a\u9884\u7b97\u671f\u95f4\u7684\u786e\u8ba4\u6536\u5165\u503c", "RuleFunctionEnum_0", "epm-eb-common");
    }

    private static MultiLangEnumBridge getRecognitionSP() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u5408\u540c\u7b7e\u7ea6\u6536\u6b3e/\u6536\u5165\u5728\u6307\u5b9a\u9884\u7b97\u671f\u95f4\u7684\u56de\u6b3e\u6570\u3002", "RuleFunctionEnum_1", "epm-eb-common");
    }

    private static MultiLangEnumBridge getIsAttribute() {
        return new MultiLangEnumBridge("\u5224\u65ad\u5f53\u524d\u6210\u5458\u7684\u81ea\u5b9a\u4e49\u5c5e\u6027\u662f\u5426\u4e3a\u5f53\u524d\u6307\u5b9a\u7684\u5c5e\u6027\u503c\uff0c\u7ed3\u679c\u4e3a\u771f\u8fd4\u56deTrue\uff0c\u7ed3\u679c\u4e3a\u5047\u8fd4\u56deFalse\u3002", "RuleFunctionEnum_2", "epm-eb-common");
    }

    private static MultiLangEnumBridge getDate() {
        return new MultiLangEnumBridge("\u63d0\u4f9b\u4e09\u79cd\u7c7b\u578b\u53c2\u6570\uff0c\u5355\u9009\uff0c\u8fd4\u56de\u4e00\u79cd\u9009\u9879\u7684\u6807\u51c6\u65e5\u671f\u683c\u5f0f", "RuleFunctionEnum_12", "epm-eb-common");
    }

    private static MultiLangEnumBridge getIsChild() {
        return new MultiLangEnumBridge("\u68c0\u67e5\u5f53\u524d\u6210\u5458\u662f\u5426\u4e3a\u6307\u5b9a\u6210\u5458\u7684\u5b50\u4ee3\u3002\u5982\u679c\u662f\uff0c\u8fd4\u56deTrue\uff1b\u5982\u679c\u4e0d\u662f\uff0c\u8fd4\u56deFalse\u3002", "RuleFunctionEnum_3", "epm-eb-common");
    }

    private static MultiLangEnumBridge getCount() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u6307\u5b9a\u6210\u5458\u8303\u56f4\u5185\u7684\u6570\u91cf\u3002", "RuleFunctionEnum_4", "epm-eb-common");
    }

    private static MultiLangEnumBridge getList() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u6210\u5458\u96c6\u5408", "RuleFunctionEnum_6", "epm-eb-common");
    }

    private static MultiLangEnumBridge getYearValue() {
        return new MultiLangEnumBridge("\u53f3\u7b49\u5f0f\u6210\u5458\u7684\u5e74\u5ea6\u6839\u636e\u6210\u5458\u5de6\u7b49\u5f0f\u6210\u5458\u5e74\u5ea6\u53d6\u503c", "RuleFunctionEnum_7", "epm-eb-common");
    }

    private static MultiLangEnumBridge getGetNumber() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u6307\u5b9a\u6210\u5458\u7684\u7f16\u7801", "RuleFunctionEnum_17", "epm-eb-common");
    }

    private static MultiLangEnumBridge getGetName() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u6307\u5b9a\u6210\u5458\u7684\u540d\u79f0", "RuleFunctionEnum_18", "epm-eb-common");
    }

    private static MultiLangEnumBridge getMember() {
        return new MultiLangEnumBridge("\u8fd4\u56de\u7f16\u7801\u4e0e\u6307\u5b9a\u5b57\u7b26\u4e32\u4e00\u81f4\u7684\u7ef4\u5ea6\u6210\u5458", "RuleFunctionEnum_19", "epm-eb-common");
    }

    public static RuleFunctionEnum getFunctionEnumByNameNoError(String name) {
        RuleFunctionEnum function = null;
        for (RuleFunctionEnum functionEnum : RuleFunctionEnum.values()) {
            if (!functionEnum.getName().equals(name)) continue;
            function = functionEnum;
            break;
        }
        return function;
    }

    public static RuleFunctionEnum getFunctionEnumByName(String name) {
        RuleFunctionEnum function = null;
        for (RuleFunctionEnum functionEnum : RuleFunctionEnum.values()) {
            if (!functionEnum.getName().equals(name)) continue;
            function = functionEnum;
            break;
        }
        if (function == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u51fd\u6570\u4e0d\u5b58\u5728\u201c%1\u201d\u3002", (String)"RuleFunctionEnum_5", (String)"epm-eb-common", (Object[])new Object[]{name}));
        }
        return function;
    }

    public static List<RuleFunctionEnum> getFunctionsByType(RuleFunctionTypeEnum functionType) {
        ArrayList<RuleFunctionEnum> list = new ArrayList<RuleFunctionEnum>(16);
        if (functionType != null) {
            boolean isAllFunction = RuleFunctionTypeEnum.All == functionType;
            for (RuleFunctionEnum functionEnum : RuleFunctionEnum.values()) {
                if (!isAllFunction && functionEnum.getFunctionType() != functionType || !functionEnum.isEnable()) continue;
                list.add(functionEnum);
            }
        }
        return list;
    }

    public static List<RuleFunctionEnum> getFunctionsByParentFunName(String parentFunName) {
        if (Attribute.getName().equalsIgnoreCase(parentFunName)) {
            return Lists.newArrayList((Object[])new RuleFunctionEnum[]{Attribute, Sibling, Relative, Parent, CurrMBR, Ancestor, Children, Member});
        }
        if (GetAttribute.getName().equalsIgnoreCase(parentFunName)) {
            return Lists.newArrayList((Object[])new RuleFunctionEnum[]{Parent, CurrMBR, Ancestor});
        }
        if (Children.getName().equalsIgnoreCase(parentFunName)) {
            return Lists.newArrayList((Object[])new RuleFunctionEnum[]{Attribute, Sibling, Parent, CurrMBR, Ancestor, Children, Member});
        }
        if (Relative.getName().equalsIgnoreCase(parentFunName)) {
            return Lists.newArrayList((Object[])new RuleFunctionEnum[]{Attribute, Sibling, Parent, CurrMBR, Ancestor, Member});
        }
        if (Sibling.getName().equalsIgnoreCase(parentFunName)) {
            return Lists.newArrayList((Object[])new RuleFunctionEnum[]{Parent, CurrMBR, Ancestor, Member});
        }
        if (Parent.getName().equalsIgnoreCase(parentFunName)) {
            return Lists.newArrayList((Object[])new RuleFunctionEnum[]{Parent, CurrMBR, Ancestor, Member});
        }
        if (Ancestor.getName().equalsIgnoreCase(parentFunName)) {
            return Lists.newArrayList((Object[])new RuleFunctionEnum[]{Parent, CurrMBR, Ancestor, Member});
        }
        if (List.getName().equalsIgnoreCase(parentFunName)) {
            return Lists.newArrayList((Object[])new RuleFunctionEnum[]{Parent, CurrMBR, Ancestor, Member});
        }
        if ("AttributeValFun".equalsIgnoreCase(parentFunName)) {
            return Lists.newArrayList((Object[])new RuleFunctionEnum[]{GetAttribute});
        }
        if (GetNumber.getName().equalsIgnoreCase(parentFunName)) {
            return Lists.newArrayList((Object[])new RuleFunctionEnum[]{Parent, CurrMBR, Ancestor});
        }
        if (GetName.getName().equalsIgnoreCase(parentFunName)) {
            return Lists.newArrayList((Object[])new RuleFunctionEnum[]{Parent, CurrMBR, Ancestor});
        }
        if (Member.getName().equalsIgnoreCase(parentFunName)) {
            return Lists.newArrayList((Object[])new RuleFunctionEnum[]{GetNumber, GetName});
        }
        return null;
    }

    public static boolean childIsSetFun(String funName) {
        return Attribute.getName().equalsIgnoreCase(funName);
    }

    public static boolean childIsMembFun(String funName) {
        return Sibling.getName().equalsIgnoreCase(funName) || Relative.getName().equalsIgnoreCase(funName) || Children.getName().equalsIgnoreCase(funName) || Parent.getName().equalsIgnoreCase(funName) || Ancestor.getName().equalsIgnoreCase(funName) || Member.getName().equalsIgnoreCase(funName);
    }

    public static boolean isCutFunction(String functionName) {
        RuleFunctionEnum functionEnum = RuleFunctionEnum.valueOf(functionName);
        if (functionEnum == null) {
            return false;
        }
        return functionEnum.isCut;
    }

    public String getName() {
        return this.name;
    }

    public String getExplain() {
        return this.explain.loadKDString();
    }

    public RuleFunctionTypeEnum getFunctionType() {
        return this.functionType;
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean isCut() {
        return this.isCut;
    }

    public static boolean isFIFunction(String functionType) {
        return RecognitionP.getName().equals(functionType) || RecognitionPC.getName().equals(functionType) || RecognitionSP.getName().equals(functionType);
    }

    public static boolean isYearValueFunction(String functionType) {
        return YearValue.getName().equals(functionType);
    }

    public static boolean isWithScopeSameViewFunction(String functionType) {
        return Sibling.getName().equals(functionType) || Ancestor.getName().equals(functionType) || Parent.getName().equals(functionType);
    }

    public static boolean isRelationFunction(String functionType) {
        List<RuleFunctionEnum> ruleFunctionEnums = RuleFunctionEnum.getFunctionsByType(RuleFunctionTypeEnum.Relation);
        RuleFunctionEnum ruleFunctionEnum = RuleFunctionEnum.getFunctionEnumByName(functionType);
        return ruleFunctionEnums.contains((Object)ruleFunctionEnum);
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}

