/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.examine.domain.report;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.TriggerEventEnum;
import kd.epm.eb.common.examine.domain.report.ExamineCheckResultForExamine;
import kd.epm.eb.common.examine.domain.report.ExamineReportOtherInfo;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.examine.request.CheckRange;
import kd.epm.eb.common.utils.base.JsonUtils;

public class ExamineCheckReport
implements Serializable {
    private long id;
    private String number;
    private Date date;
    private Long modelId;
    private Long datasetId;
    private Long templateId;
    private Long reportProcessId;
    private Long approveBillId;
    private List<CheckRange> checkRangeList;
    private ExamineCheckResultEnum examineCheckResultEnum;
    private List<ExamineCheckResultForExamine> examineCheckResultForExamineList = Lists.newLinkedList();
    private List<String> examineNumberList = Lists.newLinkedList();
    private TriggerEventEnum targetEvent;
    private ProcessTypeEnum processTypeEnum;
    private Long executorId;
    private Long examineAnnotationId;

    public Long getApproveBillId() {
        return this.approveBillId;
    }

    public void setApproveBillId(Long approveBillId) {
        this.approveBillId = approveBillId;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Long getReportProcessId() {
        return this.reportProcessId;
    }

    public void setReportProcessId(Long reportProcessId) {
        this.reportProcessId = reportProcessId;
    }

    public List<CheckRange> getCheckRangeList() {
        return this.checkRangeList;
    }

    @Deprecated
    public void setCheckRangeList(List<CheckRange> checkRangeList) {
        this.checkRangeList = checkRangeList;
    }

    public ExamineCheckResultEnum getExamineCheckResultEnum() {
        return this.examineCheckResultEnum;
    }

    public void setExamineCheckResultEnum(ExamineCheckResultEnum examineCheckResultEnum) {
        this.examineCheckResultEnum = examineCheckResultEnum;
    }

    public List<ExamineCheckResultForExamine> getExamineCheckResultForExamineList() {
        return this.examineCheckResultForExamineList;
    }

    public void setExamineCheckResultForExamineList(List<ExamineCheckResultForExamine> examineCheckResultForExamineList) {
        this.examineCheckResultForExamineList = examineCheckResultForExamineList;
    }

    public List<String> getExamineNumberList() {
        return this.examineNumberList;
    }

    public void setExamineNumberList(List<String> examineNumberList) {
        this.examineNumberList = examineNumberList;
    }

    public void addExamineCheckResultForExamine(ExamineCheckResultForExamine examineCheckResultForExamine) {
        if (ExamineCheckResultEnum.worse(this.examineCheckResultEnum, examineCheckResultForExamine.getExamineCheckResultEnum())) {
            this.examineCheckResultEnum = examineCheckResultForExamine.getExamineCheckResultEnum();
        }
        this.examineCheckResultForExamineList.add(examineCheckResultForExamine);
        this.examineNumberList.add(examineCheckResultForExamine.getExamineNumber());
    }

    public void setTargetEvent(TriggerEventEnum targetEvent) {
        this.targetEvent = targetEvent;
    }

    public TriggerEventEnum getTargetEvent() {
        return this.targetEvent;
    }

    public ProcessTypeEnum getProcessTypeEnum() {
        return this.processTypeEnum;
    }

    public void setProcessTypeEnum(ProcessTypeEnum processTypeEnum) {
        this.processTypeEnum = processTypeEnum;
    }

    public void setExecutorId(Long executorId) {
        this.executorId = executorId;
    }

    public Long getExecutorId() {
        return this.executorId;
    }

    public Long getExamineAnnotationId() {
        return this.examineAnnotationId;
    }

    public void setExamineAnnotationId(Long examineAnnotationId) {
        this.examineAnnotationId = examineAnnotationId;
    }

    public static ExamineCheckReport of(DynamicObject doj) {
        ExamineCheckReport examineCheckReport = new ExamineCheckReport();
        examineCheckReport.setId(doj.getLong("id"));
        examineCheckReport.setNumber(doj.getString("number"));
        examineCheckReport.setDate(doj.getDate("createdate"));
        examineCheckReport.setModelId(doj.getLong("model.id"));
        examineCheckReport.setDatasetId(doj.getLong("dataset.id"));
        examineCheckReport.setTemplateId(doj.getLong("template.id"));
        examineCheckReport.setReportProcessId(doj.getLong("reportprocess.id"));
        examineCheckReport.setExamineCheckResultEnum(ExamineCheckResultEnum.getEnumByIndex(Integer.parseInt(doj.getString("checkresult"))));
        examineCheckReport.setTargetEvent(TriggerEventEnum.getTriggerEventEnum(doj.getString("executetype")));
        examineCheckReport.setExecutorId(doj.getLong("creater.id"));
        examineCheckReport.setExamineAnnotationId(doj.getLong("examine_annotation.id"));
        ArrayList examineCheckResultForExamineList = Lists.newArrayListWithExpectedSize((int)16);
        examineCheckReport.setExamineCheckResultForExamineList(examineCheckResultForExamineList);
        ArrayList examineNumberList = Lists.newArrayListWithExpectedSize((int)16);
        examineCheckReport.setExamineNumberList(examineNumberList);
        DynamicObjectCollection dojs = doj.getDynamicObjectCollection("checkreportforexamine");
        for (DynamicObject dynamicObject : dojs) {
            ExamineCheckResultForExamine examineCheckResultForExamine = new ExamineCheckResultForExamine();
            examineCheckResultForExamine.setExamineId(dynamicObject.getLong("examine.id"));
            examineCheckResultForExamine.setExamineNumber(dynamicObject.getString("examine.number"));
            examineCheckResultForExamine.setExamineCheckResultEnum(ExamineCheckResultEnum.getEnumByIndex(Integer.parseInt(dynamicObject.getString("checkresutdetail"))));
            ExamineReportOtherInfo examineReportOtherInfo = JsonUtils.readValue(dynamicObject.getString("otherinfo"), new TypeReference<ExamineReportOtherInfo>(){});
            examineCheckResultForExamine.setExamineDto(examineReportOtherInfo.getExamineDto());
            examineCheckResultForExamine.setSameMembers(examineReportOtherInfo.getSameMembers());
            examineCheckResultForExamine.setDiffDimensions(examineReportOtherInfo.getDiffDimensions());
            examineCheckResultForExamine.setMemberKeyUsedDimMap(examineReportOtherInfo.getMemberKeyUsedDimMap());
            examineCheckResultForExamine.setExamineCheckResultItemList(examineReportOtherInfo.getExamineCheckResultItemList());
            examineCheckResultForExamineList.add(examineCheckResultForExamine);
            examineNumberList.add(examineCheckResultForExamine.getExamineNumber());
        }
        return examineCheckReport;
    }
}

