/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.examine.domain.report;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.epm.eb.common.enums.ExamineBehaviorEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.TriggerEventEnum;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReportDetail;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.examine.enums.ExamineInfoTypeEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.base.JsonUtils;

public class ExamineCheckReportV1
implements Serializable {
    private long id;
    private Long examineId;
    private String examineNumber;
    private String examineName;
    private String examineExplain;
    private ExamineBehaviorEnum examineBehaviorEnum;
    private ExamineCheckResultEnum examineCheckResultEnum;
    private String leftValue;
    private String rightValue;
    private String difference;
    private Long entityId;
    private Long periodId;
    private Long dataTypeId;
    private Long versionId;
    private Long accountId;
    private Map<String, String> dimRange;
    private Date examineTime;
    private Long modelId;
    private Long dataSetId;
    private TriggerEventEnum examineExecTypeEnum;
    private Long creatorId;
    private String creatorName;
    private Long reportProcessId;
    private ProcessTypeEnum processTypeEnum;
    private Long templateId;
    private Long annotationId;
    private String annotationRemark;
    private String annotatorName;
    private Long annotatorId;
    private Date annotationTime;
    private String showPanel;
    private List<ExamineCheckReportDetail> examineCheckReportDetailList;

    public String getShowPanel() {
        return this.showPanel;
    }

    public void setShowPanel(String showPanel) {
        this.showPanel = showPanel;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Long getExamineId() {
        return this.examineId;
    }

    public void setExamineId(Long examineId) {
        this.examineId = examineId;
    }

    public String getExamineNumber() {
        return this.examineNumber;
    }

    public void setExamineNumber(String examineNumber) {
        this.examineNumber = examineNumber;
    }

    public String getExamineName() {
        return this.examineName;
    }

    public void setExamineName(String examineName) {
        this.examineName = examineName;
    }

    public String getExamineExplain() {
        return this.examineExplain;
    }

    public void setExamineExplain(String examineExplain) {
        this.examineExplain = examineExplain;
    }

    public ExamineBehaviorEnum getExamineBehaviorEnum() {
        return this.examineBehaviorEnum;
    }

    public void setExamineBehaviorEnum(ExamineBehaviorEnum examineBehaviorEnum) {
        this.examineBehaviorEnum = examineBehaviorEnum;
    }

    public ExamineCheckResultEnum getExamineCheckResultEnum() {
        return this.examineCheckResultEnum;
    }

    public void setExamineCheckResultEnum(ExamineCheckResultEnum examineCheckResultEnum) {
        this.examineCheckResultEnum = examineCheckResultEnum;
    }

    public String getLeftValue() {
        return this.leftValue;
    }

    public void setLeftValue(String leftValue) {
        this.leftValue = leftValue;
    }

    public String getRightValue() {
        return this.rightValue;
    }

    public void setRightValue(String rightValue) {
        this.rightValue = rightValue;
    }

    public String getDifference() {
        return this.difference;
    }

    public void setDifference(String difference) {
        this.difference = difference;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public Long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(Long periodId) {
        this.periodId = periodId;
    }

    public Long getDataTypeId() {
        return this.dataTypeId;
    }

    public void setDataTypeId(Long dataTypeId) {
        this.dataTypeId = dataTypeId;
    }

    public Long getVersionId() {
        return this.versionId;
    }

    public void setVersionId(Long versionId) {
        this.versionId = versionId;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Map<String, String> getDimRange() {
        return this.dimRange;
    }

    public void setDimRange(Map<String, String> dimRange) {
        this.dimRange = dimRange;
    }

    public Date getExamineTime() {
        return this.examineTime;
    }

    public void setExamineTime(Date examineTime) {
        this.examineTime = examineTime;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getDataSetId() {
        return this.dataSetId;
    }

    public void setDataSetId(Long dataSetId) {
        this.dataSetId = dataSetId;
    }

    public TriggerEventEnum getExamineExecTypeEnum() {
        return this.examineExecTypeEnum;
    }

    public void setExamineExecTypeEnum(TriggerEventEnum examineExecTypeEnum) {
        this.examineExecTypeEnum = examineExecTypeEnum;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public Long getReportProcessId() {
        return this.reportProcessId;
    }

    public void setReportProcessId(Long reportProcessId) {
        this.reportProcessId = reportProcessId;
    }

    public ProcessTypeEnum getProcessTypeEnum() {
        return this.processTypeEnum;
    }

    public void setProcessTypeEnum(ProcessTypeEnum processTypeEnum) {
        this.processTypeEnum = processTypeEnum;
    }

    public Long getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Long templateId) {
        this.templateId = templateId;
    }

    public Long getAnnotationId() {
        return this.annotationId;
    }

    public void setAnnotationId(Long annotationId) {
        this.annotationId = annotationId;
    }

    public String getAnnotationRemark() {
        return this.annotationRemark;
    }

    public void setAnnotationRemark(String annotationRemark) {
        this.annotationRemark = annotationRemark;
    }

    public String getAnnotatorName() {
        return this.annotatorName;
    }

    public void setAnnotatorName(String annotatorName) {
        this.annotatorName = annotatorName;
    }

    public Long getAnnotatorId() {
        return this.annotatorId;
    }

    public void setAnnotatorId(Long annotatorId) {
        this.annotatorId = annotatorId;
    }

    public Date getAnnotationTime() {
        return this.annotationTime;
    }

    public void setAnnotationTime(Date annotationTime) {
        this.annotationTime = annotationTime;
    }

    public List<ExamineCheckReportDetail> getExamineCheckReportDetailList() {
        return this.examineCheckReportDetailList;
    }

    public void setExamineCheckReportDetailList(List<ExamineCheckReportDetail> examineCheckReportDetailList) {
        this.examineCheckReportDetailList = examineCheckReportDetailList;
    }

    public static ExamineCheckReportV1 of(DynamicObject doj) {
        ExamineCheckReportV1 examineCheckReport = new ExamineCheckReportV1();
        examineCheckReport.setId(doj.getLong("id"));
        examineCheckReport.setExamineName(doj.getString("examine.name"));
        examineCheckReport.setExamineNumber(doj.getString("examine.number"));
        examineCheckReport.setExamineId(doj.getLong("examine.id"));
        examineCheckReport.setExamineExplain(doj.getString("examine.explain"));
        examineCheckReport.setExamineBehaviorEnum(ExamineBehaviorEnum.getEnumsByValue(doj.getString("examine.checkinfluence")));
        examineCheckReport.setExamineCheckResultEnum(ExamineCheckResultEnum.getEnumByIndex(doj.getInt("status")));
        examineCheckReport.setLeftValue(doj.getString("leftvalue"));
        examineCheckReport.setRightValue(doj.getString("rightvalue"));
        examineCheckReport.setDifference(doj.getString("difference"));
        examineCheckReport.setEntityId(doj.getLong("entity.id"));
        examineCheckReport.setPeriodId(doj.getLong("period.id"));
        examineCheckReport.setDataTypeId(doj.getLong("datatype.id"));
        examineCheckReport.setAccountId(doj.getLong("account.id"));
        examineCheckReport.setVersionId(doj.getLong("version.id"));
        examineCheckReport.setDimRange(JsonUtils.readValue(doj.getString("dimrange"), new TypeReference<Map<String, String>>(){}));
        examineCheckReport.setExamineTime(doj.getDate("examinetime"));
        examineCheckReport.setModelId(doj.getLong("model.id"));
        examineCheckReport.setExamineExecTypeEnum(TriggerEventEnum.getTriggerEventEnum(doj.getString("executetype")));
        examineCheckReport.setCreatorId(doj.getLong("creater.id"));
        examineCheckReport.setCreatorName(doj.getString("creater.name"));
        examineCheckReport.setReportProcessId(doj.getLong("reportprocess.id"));
        examineCheckReport.setProcessTypeEnum(ProcessTypeEnum.getProcessTypeByIndex(doj.getInt("processtype")));
        examineCheckReport.setTemplateId(doj.getLong("template.id"));
        examineCheckReport.setAnnotationId(doj.getLong("annotation.id"));
        examineCheckReport.setAnnotationRemark(doj.getString("annotation.remark"));
        examineCheckReport.setAnnotatorName(doj.getString("annotation.modifier.name"));
        examineCheckReport.setAnnotationTime(doj.getDate("annotation.modifydate"));
        examineCheckReport.setAnnotatorId(doj.getLong("annotation.modifier.id"));
        examineCheckReport.setDataSetId(doj.getLong("dataset.id"));
        examineCheckReport.setShowPanel(doj.getString("showpanel"));
        DynamicObjectCollection treeentryentity = doj.getDynamicObjectCollection("treeentryentity");
        if (treeentryentity != null && !treeentryentity.isEmpty()) {
            List<ExamineCheckReportDetail> collect = treeentryentity.stream().map(x -> {
                ExamineCheckReportDetail examineCheckReportDetail = new ExamineCheckReportDetail();
                examineCheckReportDetail.setId(x.getLong("id"));
                examineCheckReportDetail.setName(x.getString("name"));
                examineCheckReportDetail.setExamineInfoTypeEnum(ExamineInfoTypeEnum.getEnumByIndex(x.getInt("examinetype")));
                examineCheckReportDetail.setValue(x.getString("value"));
                examineCheckReportDetail.setParentId(x.getLong("pid"));
                examineCheckReportDetail.setMemberKey(x.getString("memberkey"));
                if (StringUtils.isNotEmpty(x.getString("dimjson"))) {
                    examineCheckReportDetail.setDimRange(JsonUtils.readValue(x.getString("dimjson"), new TypeReference<Map<String, String>>(){}));
                }
                return examineCheckReportDetail;
            }).collect(Collectors.toList());
            examineCheckReport.setExamineCheckReportDetailList(collect);
        }
        return examineCheckReport;
    }
}

