/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.examine.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.examine.bo.ExamineCheckMemGroup;
import kd.epm.eb.common.examine.bo.ExamineCheckRangeItemPojo;
import kd.epm.eb.common.examine.bo.ExamineCheckRangePojo;
import kd.epm.eb.common.examine.bo.ExamineItem;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReportDetail;
import kd.epm.eb.common.examine.domain.report.ExamineCheckReportV1;
import kd.epm.eb.common.examine.enums.ExamineCheckResultEnum;
import kd.epm.eb.common.utils.base.JsonUtils;

public class ExamineReportUtils {
    public static List<ExamineCheckMemGroup> getNoPassMemberGroupV1(ExamineCheckReportV1 examineCheckReportV1) {
        ExamineCheckResultEnum examineCheckResultEnum = examineCheckReportV1.getExamineCheckResultEnum();
        if (examineCheckResultEnum == ExamineCheckResultEnum.NoExamine || examineCheckResultEnum == ExamineCheckResultEnum.Pass) {
            return Collections.emptyList();
        }
        IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(examineCheckReportV1.getModelId());
        List<Dimension> dimensionList = modelCacheHelper.getDimensionList(examineCheckReportV1.getDataSetId());
        String[] dimNums = (String[])dimensionList.stream().map(BaseCache::getNumber).toArray(String[]::new);
        ArrayList noPassExamineCheckMemGroup = Lists.newArrayListWithExpectedSize((int)16);
        HashSet memberKeys = Sets.newHashSetWithExpectedSize((int)1024);
        StringBuilder sb = new StringBuilder();
        ExamineCheckMemGroup examineCheckMemGroup = new ExamineCheckMemGroup(dimNums, examineCheckReportV1.getExamineNumber());
        noPassExamineCheckMemGroup.add(examineCheckMemGroup);
        for (ExamineCheckReportDetail examineCheckReportDetail : examineCheckReportV1.getExamineCheckReportDetailList()) {
            Map<String, String> dimRange = examineCheckReportDetail.getDimRange();
            if (dimRange == null || dimRange.isEmpty()) continue;
            sb.setLength(0);
            for (Dimension dimension : dimensionList) {
                String memNumber = dimRange.get(dimension.getNumber());
                sb.append(memNumber).append('|');
            }
            sb.setLength(sb.length() - 1);
            memberKeys.add(sb.toString());
        }
        List<String[]> collect = memberKeys.stream().map(memberKey -> memberKey.split("\\|")).collect(Collectors.toList());
        examineCheckMemGroup.setMemberKeys(collect);
        return noPassExamineCheckMemGroup;
    }

    public static boolean checkRelate(Map<String, String> cell, ExamineItem examineItem, Map<String, Set<String>> iterScope) {
        Map<String, String> members = examineItem.getMembers();
        for (Map.Entry<String, String> entry : cell.entrySet()) {
            Set<String> scopeMembers;
            String dimNumber = entry.getKey();
            String cellMemNumber = entry.getValue();
            String itemMemNumber = members.get(dimNumber);
            if (!(itemMemNumber == null ? (scopeMembers = iterScope.get(dimNumber)) != null && !scopeMembers.contains(cellMemNumber) : !cellMemNumber.equals(itemMemNumber))) continue;
            return false;
        }
        return true;
    }

    public static Map<String, String> getDimensionAndMemberNumberMap(String dimRangeString) {
        return JsonUtils.readValue(dimRangeString, new TypeReference<HashMap<String, String>>(){});
    }

    public static String getDimRangeString(Map<String, String> dimensionAndMemberNumberMap, IModelCacheHelper modelCacheHelper) {
        ArrayList<String> memberNameStringList = new ArrayList<String>(dimensionAndMemberNumberMap.size());
        for (Map.Entry<String, String> entry : dimensionAndMemberNumberMap.entrySet()) {
            Member member = modelCacheHelper.getMemberByAnyView(entry.getKey(), entry.getValue());
            if (member == null) continue;
            memberNameStringList.add(member.getName());
        }
        if (memberNameStringList.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"/", memberNameStringList);
    }

    public static ExamineCheckRangePojo getExamineCheckRangePojo(Map<String, String> dimensionAndMemberNumberMap, IModelCacheHelper modelCacheHelper) {
        ExamineCheckRangePojo examineCheckRangePojo = new ExamineCheckRangePojo();
        ArrayList<ExamineCheckRangeItemPojo> examineCheckRangeItemPojoList = new ArrayList<ExamineCheckRangeItemPojo>(dimensionAndMemberNumberMap.size());
        examineCheckRangePojo.setExamineCheckRangeItemPojoList(examineCheckRangeItemPojoList);
        for (Map.Entry<String, String> entry : dimensionAndMemberNumberMap.entrySet()) {
            Dimension dimension;
            Member member = modelCacheHelper.getMemberByAnyView(entry.getKey(), entry.getValue());
            if (member == null || (dimension = member.getDimension()) == null) continue;
            ExamineCheckRangeItemPojo examineCheckRangeItemPojo = new ExamineCheckRangeItemPojo();
            examineCheckRangeItemPojoList.add(examineCheckRangeItemPojo);
            examineCheckRangeItemPojo.setDimensionNameString(dimension.getName());
            examineCheckRangeItemPojo.setMemberNameString(member.getName());
        }
        return examineCheckRangePojo;
    }
}

