/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.execanalyse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.execanalyse.AnalyseColTypeGroup;
import kd.epm.eb.common.execanalyse.AnalysePreColType;
import kd.epm.eb.common.execanalyse.SchemeColSetting;
import kd.epm.eb.common.execanalyse.SplitDimRange;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.convert.Convert;

public class AnalyseQueryParameter {
    private Long modelId;
    private Long bizModelId;
    private Long datasetId;
    private Long schemeId;
    private Map<String, List<String>> queryParam;
    private IModelCacheHelper modelCacheHelper;
    private List<String> rowDimKeys;
    private List<String> rowDimControlKeys;
    private List<String> pageDimKeys;
    private String colDimKey;
    private Map<String, String> colKeys;
    private String nextPageStartRow;
    private String[] nextPageStartRowMembers;
    private Set<String> amountPeriods;
    private Map<String, String> maxMonthMap;
    private final Map<String, String> dimMembers = new HashMap<String, String>(16);
    private AnalyseColTypeGroup analyseColTypeGroup;
    private int maxQueryData = 10000;
    private String[] dimensionList;
    private List<String> controlDimensions;
    private List<String> colKeyList;
    private List<SplitDimRange> splitDimRanges;
    private final List<Map<String, String>> balanceMemberList = new ArrayList<Map<String, String>>(16);
    private int curRangeCount = 0;
    private int curQueryDataCount = -1;
    private boolean showEmpty = false;
    private boolean sign = false;
    private int pageIndex = 1;
    private boolean needSplit = true;
    private List<String> refPeriods;
    private Set<String> referAmountPeriods;
    private Set<AnalysePreColType> refColTypes;
    private boolean checkDimPerm = true;
    private Set<String> hasCheckedPermDims;
    private List<PermDimGroup> permDimGroups;
    private Map<String, List<AnalysePreColType>> notHasPermColTypes;
    private List<SchemeColSetting> colSettings;
    private Map<Long, List<Long>> formulaRelDataMap;
    private Map<String, Integer> metricDisplay = new HashMap<String, Integer>(16);
    private String adjustAuditTrail;
    private String adjpstAuditTrail;
    private final List<Object[]> analyseData = new ArrayList<Object[]>(16);
    private final List<Object[]> tmpData = new ArrayList<Object[]>(16);
    private final Map<String, Set<Long>> dimPermMap = new HashMap<String, Set<Long>>(16);
    private Set<String> exceptAccounts = new HashSet<String>(16);
    private String appId;
    private String formId;

    public AnalyseQueryParameter(Long modelId, Long datasetId, boolean showEmpty) {
        this.modelId = modelId;
        this.datasetId = datasetId;
        this.showEmpty = showEmpty;
    }

    public AnalyseQueryParameter(Long modelId, Long datasetId, Set<String> amountPeriods, Map<String, String> maxMonthMap, List<String> rowDimKeys, int pageIndex, boolean showEmpty) {
        this(modelId, datasetId, showEmpty);
        this.amountPeriods = amountPeriods;
        this.maxMonthMap = maxMonthMap;
        this.pageIndex = pageIndex;
        this.rowDimKeys = rowDimKeys;
    }

    public AnalyseQueryParameter(Map<String, Object> mapValues) {
        this.modelId = ConvertUtils.toLong(mapValues.get("modelId"));
        this.datasetId = ConvertUtils.toLong(mapValues.get("datasetId"));
        this.schemeId = ConvertUtils.toLong(mapValues.get("schemeId"));
        this.needSplit = Convert.toBool(mapValues.get("needSplit"), true);
        this.amountPeriods = (Set)SerializationUtils.fromJsonString((String)mapValues.get("amountPeriods").toString(), HashSet.class);
        this.maxMonthMap = (Map)SerializationUtils.fromJsonString((String)mapValues.get("maxMonthMap").toString(), HashMap.class);
        this.queryParam = (Map)SerializationUtils.fromJsonString((String)mapValues.get("queryParam").toString(), HashMap.class);
        this.colKeys = (Map)SerializationUtils.fromJsonString((String)mapValues.get("colKeys").toString(), HashMap.class);
        this.colKeyList = (List)SerializationUtils.fromJsonString((String)mapValues.get("colKeyList").toString(), ArrayList.class);
        this.analyseColTypeGroup = (AnalyseColTypeGroup)SerializationUtils.fromJsonString((String)mapValues.get("analyseColTypeGroup").toString(), AnalyseColTypeGroup.class);
        this.colSettings = (List)SerializationUtils.deSerializeFromBase64((String)mapValues.get("colSettings").toString());
        this.appId = (String)mapValues.get("appId");
        this.formId = (String)mapValues.get("formId");
    }

    public Map<String, Object> toMapValues() {
        HashMap<String, Object> mapValues = new HashMap<String, Object>(16);
        mapValues.put("modelId", this.modelId.toString());
        mapValues.put("datasetId", this.datasetId.toString());
        mapValues.put("amountPeriods", SerializationUtils.toJsonString(this.amountPeriods));
        mapValues.put("maxMonthMap", SerializationUtils.toJsonString(this.maxMonthMap));
        mapValues.put("queryParam", SerializationUtils.toJsonString(this.queryParam));
        mapValues.put("schemeId", this.schemeId.toString());
        mapValues.put("colKeys", SerializationUtils.toJsonString(this.colKeys));
        mapValues.put("colKeyList", SerializationUtils.toJsonString(this.colKeyList));
        mapValues.put("needSplit", String.valueOf(this.needSplit));
        mapValues.put("analyseColTypeGroup", SerializationUtils.toJsonString((Object)this.analyseColTypeGroup));
        mapValues.put("colSettings", SerializationUtils.serializeToBase64(this.colSettings));
        mapValues.put("appId", this.appId);
        mapValues.put("formId", this.formId);
        return mapValues;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getBizModelId() {
        return this.bizModelId;
    }

    public void setBizModelId(Long bizModelId) {
        this.bizModelId = bizModelId;
    }

    public Long getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public Map<String, List<String>> getQueryParam() {
        return this.queryParam;
    }

    public void setQueryParam(Map<String, List<String>> queryParam) {
        this.queryParam = queryParam;
    }

    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate(this.getModelId());
        }
        return this.modelCacheHelper;
    }

    public void setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
    }

    public List<String> getRowDimKeys() {
        return this.rowDimKeys;
    }

    public void setRowDimKeys(List<String> rowDimKeys) {
        this.rowDimKeys = rowDimKeys;
    }

    public List<String> getRowDimControlKeys() {
        return this.rowDimControlKeys;
    }

    public void setRowDimControlKeys(List<String> rowDimControlKeys) {
        this.rowDimControlKeys = rowDimControlKeys;
    }

    public List<String> getPageDimKeys() {
        return this.pageDimKeys;
    }

    public void setPageDimKeys(List<String> pageDimKeys) {
        this.pageDimKeys = pageDimKeys;
    }

    public String getColDimKey() {
        return this.colDimKey;
    }

    public void setColDimKey(String colDimKey) {
        this.colDimKey = colDimKey;
    }

    public Map<String, String> getColKeys() {
        return this.colKeys;
    }

    public void setColKeys(Map<String, String> colKeys) {
        this.colKeys = colKeys;
    }

    public String getNextPageStartRow() {
        return this.nextPageStartRow;
    }

    public void setNextPageStartRow(String nextPageStartRow) {
        this.nextPageStartRow = nextPageStartRow;
    }

    public Set<String> getAmountPeriods() {
        return this.amountPeriods;
    }

    public void setAmountPeriods(Set<String> amountPeriods) {
        this.amountPeriods = amountPeriods;
    }

    public Map<String, String> getMaxMonthMap() {
        return this.maxMonthMap;
    }

    public void setMaxMonthMap(Map<String, String> maxMonthMap) {
        this.maxMonthMap = maxMonthMap;
    }

    public int getMaxQueryData() {
        return this.maxQueryData;
    }

    public void setMaxQueryData(int maxQueryData) {
        this.maxQueryData = maxQueryData;
    }

    public Map<String, String> getDimMembers() {
        return this.dimMembers;
    }

    public AnalyseColTypeGroup getAnalyseColTypeGroup() {
        return this.analyseColTypeGroup;
    }

    public void setAnalyseColTypeGroup(AnalyseColTypeGroup analyseColTypeGroup) {
        this.analyseColTypeGroup = analyseColTypeGroup;
    }

    public String[] getDimensionList() {
        if (this.dimensionList == null) {
            this.dimensionList = this.modelCacheHelper.getDimensionNums(this.datasetId);
        }
        return this.dimensionList;
    }

    public void setDimensionList(String[] dimensionList) {
        this.dimensionList = dimensionList;
    }

    public List<String> getControlDimensions() {
        return this.controlDimensions;
    }

    public void setControlDimensions(List<String> controlDimensions) {
        this.controlDimensions = controlDimensions;
    }

    public List<String> getColKeyList() {
        return this.colKeyList;
    }

    public void setColKeyList(List<String> colKeyList) {
        this.colKeyList = colKeyList;
    }

    public List<SplitDimRange> getSplitDimRanges() {
        return this.splitDimRanges;
    }

    public void setSplitDimRanges(List<SplitDimRange> splitDimRanges) {
        this.splitDimRanges = splitDimRanges;
    }

    public int getCurRangeCount() {
        return this.curRangeCount;
    }

    public void setCurRangeCount(int curRangeCount) {
        this.curRangeCount = curRangeCount;
    }

    public void increaseRangeCount() {
        ++this.curRangeCount;
    }

    public int getCurQueryDataCount() {
        return this.curQueryDataCount;
    }

    public void setCurQueryDataCount(int curQueryDataCount) {
        this.curQueryDataCount = curQueryDataCount;
    }

    public List<Map<String, String>> getBalanceMemberList() {
        return this.balanceMemberList;
    }

    public void addBalanceMember(Map<String, String> balanceMember) {
        this.balanceMemberList.add(balanceMember);
    }

    public boolean isShowEmpty() {
        return this.showEmpty;
    }

    public boolean isSign() {
        return this.sign;
    }

    public void setSign(boolean sign) {
        this.sign = sign;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public boolean isNeedSplit() {
        return this.needSplit;
    }

    public void setNeedSplit(boolean needSplit) {
        this.needSplit = needSplit;
    }

    public String[] getNextPageStartRowMembers() {
        if (this.nextPageStartRowMembers == null && this.nextPageStartRow != null) {
            this.nextPageStartRowMembers = this.nextPageStartRow.split("!");
        }
        return this.nextPageStartRowMembers;
    }

    public List<String> getRefPeriods() {
        return this.refPeriods;
    }

    public void setRefPeriods(List<String> refPeriods) {
        this.refPeriods = refPeriods;
    }

    public Set<AnalysePreColType> getRefColTypes() {
        return this.refColTypes;
    }

    public void addRefColTypes(AnalysePreColType refColType) {
        if (this.refColTypes == null) {
            this.refColTypes = new HashSet<AnalysePreColType>(16);
        }
        this.refColTypes.add(refColType);
    }

    public Set<String> getReferAmountPeriods() {
        return this.referAmountPeriods;
    }

    public void addReferAmountPeriods(String referAmountPeriod) {
        if (this.referAmountPeriods == null) {
            this.referAmountPeriods = new HashSet<String>(16);
        }
        this.referAmountPeriods.add(referAmountPeriod);
    }

    public boolean isCheckDimPerm() {
        return this.checkDimPerm;
    }

    public void setCheckDimPerm(boolean checkDimPerm) {
        this.checkDimPerm = checkDimPerm;
    }

    public Set<String> getHasCheckedPermDims() {
        return this.hasCheckedPermDims;
    }

    public void setHasCheckedPermDims(Set<String> hasCheckedPermDims) {
        this.hasCheckedPermDims = hasCheckedPermDims;
    }

    public List<PermDimGroup> getPermDimGroups() {
        return this.permDimGroups;
    }

    public void setPermDimGroups(List<PermDimGroup> permDimGroups) {
        this.permDimGroups = permDimGroups;
    }

    public Map<String, List<AnalysePreColType>> getNotHasPermColTypes() {
        return this.notHasPermColTypes;
    }

    public void addNotHasPermColType(String colMember, AnalysePreColType notHasPermColType) {
        if (this.notHasPermColTypes == null) {
            this.notHasPermColTypes = new HashMap<String, List<AnalysePreColType>>(16);
        }
        List analysePreColTypes = this.notHasPermColTypes.computeIfAbsent(colMember, k -> new ArrayList(16));
        analysePreColTypes.add(notHasPermColType);
    }

    public List<SchemeColSetting> getColSettings() {
        return this.colSettings;
    }

    public void setColSettings(List<SchemeColSetting> colSettings) {
        this.colSettings = colSettings;
    }

    public Map<Long, List<Long>> getFormulaRelDataMap() {
        return this.formulaRelDataMap;
    }

    public void setFormulaRelDataMap(Map<Long, List<Long>> formulaRelDataMap) {
        this.formulaRelDataMap = formulaRelDataMap;
    }

    public Map<String, Integer> getMetricDisplay() {
        return this.metricDisplay;
    }

    public void setMetricDisplay(Map<String, Integer> metricDisplay) {
        this.metricDisplay = metricDisplay;
    }

    public String getAdjustAuditTrail() {
        return this.adjustAuditTrail;
    }

    public void setAdjustAuditTrail(String adjustAuditTrail) {
        this.adjustAuditTrail = adjustAuditTrail;
    }

    public String getAdjpstAuditTrail() {
        return this.adjpstAuditTrail;
    }

    public void setAdjpstAuditTrail(String adjpstAuditTrail) {
        this.adjpstAuditTrail = adjpstAuditTrail;
    }

    public List<Object[]> getAnalyseData() {
        return this.analyseData;
    }

    public List<Object[]> getTmpData() {
        return this.tmpData;
    }

    public Map<String, Set<Long>> getDimPermMap() {
        return this.dimPermMap;
    }

    public void addDimPerms(String dimKey, Set<Long> hasPermMembers) {
        this.dimPermMap.put(dimKey, hasPermMembers);
    }

    public Set<String> getExceptAccounts() {
        return this.exceptAccounts;
    }

    public void setExceptAccounts(Set<String> exceptAccounts) {
        this.exceptAccounts = exceptAccounts;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }
}

