/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.formula;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.eb.common.formula.AddingExpression;
import kd.epm.eb.common.formula.DivExpression;
import kd.epm.eb.common.formula.Expression;
import kd.epm.eb.common.formula.Iexpression;
import kd.epm.eb.common.formula.MultExpresstion;
import kd.epm.eb.common.formula.NumberExpression;
import kd.epm.eb.common.formula.SubExpresstion;
import kd.epm.eb.common.formula.VariateExpression;
import kd.epm.eb.common.utils.StringUtils;

public class ExpressionParseHelper {
    public static Iexpression parse(String exprStr) throws Exception {
        return ExpressionParseHelper.parse(exprStr, null);
    }

    public static Iexpression parse(String exprStr, Map<String, String> refFormula) throws Exception {
        Stack<Character> operators = new Stack<Character>();
        operators.push(Character.valueOf('#'));
        Stack<Object> operand = new Stack<Object>();
        ExpressionParseHelper.toNBL(exprStr, refFormula, operators, operand);
        Iexpression expression = ExpressionParseHelper.toExpression(operand);
        return expression;
    }

    private static Iexpression toExpression(Stack<Object> operand) {
        if (operand.isEmpty()) {
            return null;
        }
        Object item = operand.pop();
        if (item instanceof Character) {
            Iexpression rightExpr = ExpressionParseHelper.toExpression(operand);
            Iexpression leftExpr = ExpressionParseHelper.toExpression(operand);
            Expression iexpression = item.equals(Character.valueOf('+')) ? new AddingExpression(leftExpr, rightExpr) : (item.equals(Character.valueOf('-')) ? new SubExpresstion(leftExpr, rightExpr) : (item.equals(Character.valueOf('*')) ? new MultExpresstion(leftExpr, rightExpr) : new DivExpression(leftExpr, rightExpr)));
            return iexpression;
        }
        return (Iexpression)item;
    }

    public static List<String> toNBL(String exprStr, Map<String, String> refFormula, Stack<Character> operators, Stack<Object> operand) throws Exception {
        ArrayList<String> formulaItems = new ArrayList<String>();
        if (refFormula == null) {
            refFormula = new HashMap<String, String>(1);
        }
        char[] chars = exprStr.toCharArray();
        StringBuffer sb = new StringBuffer();
        Serializable lastItem = null;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '(') {
                if (lastItem instanceof Iexpression) {
                    throw new Exception(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\u3002", (String)"ExpressionParseHelper_1", (String)"epm-eb-common", (Object[])new Object[0]));
                }
                ExpressionParseHelper.addItem(operators, operand, Character.valueOf(c));
                lastItem = Character.valueOf(c);
                continue;
            }
            if (ExpressionParseHelper.is4Opera(c)) {
                if (lastItem == null || !(lastItem instanceof Iexpression) && !((Object)lastItem).equals(Character.valueOf(')'))) {
                    throw new Exception(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\u3002", (String)"ExpressionParseHelper_1", (String)"epm-eb-common", (Object[])new Object[0]));
                }
                ExpressionParseHelper.addItem(operators, operand, Character.valueOf(c));
                lastItem = Character.valueOf(c);
                continue;
            }
            if (c == ')') {
                if (lastItem != null && !(lastItem instanceof Iexpression) && ((Object)lastItem).equals(Character.valueOf(')'))) {
                    throw new Exception(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\u3002", (String)"ExpressionParseHelper_1", (String)"epm-eb-common", (Object[])new Object[0]));
                }
                ExpressionParseHelper.addItem(operators, operand, Character.valueOf(c));
                lastItem = Character.valueOf(c);
                continue;
            }
            if (ExpressionParseHelper.isNumber(i, chars)) {
                if (lastItem instanceof Iexpression) {
                    throw new Exception(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\u3002", (String)"ExpressionParseHelper_1", (String)"epm-eb-common", (Object[])new Object[0]));
                }
                i = ExpressionParseHelper.selectNumber(sb, i, chars);
                NumberExpression numberExpression = new NumberExpression(new BigDecimal(sb.toString()));
                operand.add(numberExpression);
                lastItem = numberExpression;
                continue;
            }
            if (ExpressionParseHelper.isVar(i, chars)) {
                i = ExpressionParseHelper.selectVar(sb, i, chars);
                if (lastItem instanceof Iexpression) {
                    throw new Exception(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\u3002", (String)"ExpressionParseHelper_1", (String)"epm-eb-common", (Object[])new Object[0]));
                }
                String varKey = sb.toString();
                String refFormulaStr = refFormula.get(varKey);
                if (StringUtils.isEmpty(refFormulaStr)) {
                    formulaItems.add(sb.toString());
                    VariateExpression variateExpression = new VariateExpression(sb.toString());
                    operand.add(variateExpression);
                    lastItem = variateExpression;
                    continue;
                }
                chars = ExpressionParseHelper.toNewFormulaChars(refFormulaStr, chars, i);
                i = -1;
                continue;
            }
            throw new Exception(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\u3002", (String)"ExpressionParseHelper_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        if (lastItem instanceof Character && ExpressionParseHelper.is4Opera(((Character)lastItem).charValue())) {
            throw new Exception(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\u3002", (String)"ExpressionParseHelper_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        while (operators.size() > 1) {
            char op = operators.pop().charValue();
            if (!ExpressionParseHelper.is4Opera(op)) {
                throw new Exception(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\u3002", (String)"ExpressionParseHelper_1", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            operand.push(Character.valueOf(op));
        }
        return formulaItems;
    }

    private static char[] toNewFormulaChars(String refFormulaStr, char[] oldFormulaChars, int currentIndex) {
        int index;
        char[] newChars = new char[refFormulaStr.length() + oldFormulaChars.length - currentIndex - 1];
        for (index = 0; index < refFormulaStr.length(); ++index) {
            newChars[index] = refFormulaStr.charAt(index);
        }
        ++currentIndex;
        for (index = refFormulaStr.length(); index < newChars.length && currentIndex < oldFormulaChars.length; ++index, ++currentIndex) {
            newChars[index] = oldFormulaChars[currentIndex];
        }
        return newChars;
    }

    private static void addItem(Stack<Character> operators, Stack<Object> operand, Character item) throws Exception {
        if (item.charValue() == '(') {
            operators.push(item);
        } else if (item.charValue() == ')') {
            boolean find = false;
            while (true) {
                Character op;
                if (ExpressionParseHelper.isEnd((op = operators.pop()).charValue())) {
                    operators.push(op);
                    break;
                }
                if (op.charValue() == '(') {
                    find = true;
                    break;
                }
                operand.push(op);
            }
            if (!find) {
                throw new Exception(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\u3002", (String)"ExpressionParseHelper_1", (String)"epm-eb-common", (Object[])new Object[0]));
            }
        } else {
            while (true) {
                Character op;
                if (ExpressionParseHelper.isEnd((op = operators.pop()).charValue()) || !ExpressionParseHelper.comparePriority(op, item)) {
                    operators.push(op);
                    operators.push(item);
                    break;
                }
                operand.push(op);
            }
        }
    }

    private static boolean isEnd(char c) {
        return c == '#';
    }

    private static boolean comparePriority(Character c1, Character c2) {
        boolean result = false;
        if ((c1.charValue() == '*' || c1.charValue() == '/') && ExpressionParseHelper.is4Opera(c2.charValue())) {
            result = true;
        }
        return result;
    }

    private static boolean is4Opera(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/';
    }

    private static boolean isNumber(int index, char[] chars) {
        return chars[index] == '0' && index + 1 < chars.length && chars[index + 1] == '.' || chars[index] > '0' && chars[index] < ':';
    }

    private static int selectNumber(StringBuffer sb, int index, char[] chars) throws Exception {
        sb.setLength(0);
        while (index < chars.length && (chars[index] >= '0' && chars[index] < ':' || chars[index] == '.')) {
            sb.append(chars[index]);
            ++index;
        }
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '.') {
            throw new Exception(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\u3002", (String)"ExpressionParseHelper_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        return --index;
    }

    private static boolean isVar(int index, char[] chars) {
        return chars[index] == '[' && index + 1 < chars.length && chars[index + 1] == '\"';
    }

    private static int selectVar(StringBuffer sb, int index, char[] chars) throws Exception {
        sb.setLength(0);
        boolean matchEnd = false;
        for (int i = index + 2; i < chars.length; ++i) {
            if (chars[i] == '\"' && i + 1 < chars.length && chars[i + 1] == ']') {
                matchEnd = true;
                index = i + 1;
                break;
            }
            sb.append(chars[i]);
        }
        if (!matchEnd) {
            throw new Exception(ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\u3002", (String)"ExpressionParseHelper_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        return index;
    }
}

