/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.formula;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.formula.Expression;
import kd.epm.eb.common.formula.ExpressionContext;
import kd.epm.eb.common.formula.ExpressionContextNoPage;
import kd.epm.eb.common.formula.GlDataExpContext;
import kd.epm.eb.common.formula.MapExpressionContext;
import kd.epm.eb.common.formula.SheetExpressionContext;
import kd.epm.eb.common.utils.ConvertUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;

public class VariateExpression
extends Expression {
    private String indexName;

    public VariateExpression(String indexName) {
        super(null, null, "self");
        this.indexName = indexName;
    }

    @Override
    protected BigDecimal getResult() {
        BigDecimal result = null;
        ExpressionContext context = this.getContext();
        Object val = null;
        if (context instanceof ExpressionContextNoPage) {
            ExpressionContextNoPage contextNoPage = (ExpressionContextNoPage)context;
            Object[] rowData = contextNoPage.getRowData();
            Map<String, Integer> columnIndex = contextNoPage.getColumnIndex();
            if (columnIndex.containsKey(this.indexName)) {
                int index = columnIndex.get(this.indexName);
                val = rowData[index];
            }
        } else if (context instanceof SheetExpressionContext) {
            XSSFCell cell;
            SheetExpressionContext sheetExpressionContext = (SheetExpressionContext)context;
            XSSFRow row = sheetExpressionContext.getRow();
            Map<String, Integer> measureIndex = sheetExpressionContext.getMeasureIndex();
            Integer index = measureIndex.get("f" + this.indexName);
            if (index != null && (cell = row.getCell(index.intValue())) != null) {
                String cellValue = cell.getStringCellValue();
                val = ConvertUtils.toDecimal(cellValue);
            }
        } else if (context instanceof MapExpressionContext) {
            MapExpressionContext mapExpressionContext = (MapExpressionContext)context;
            Map<String, Object> rowDataValueMap = mapExpressionContext.getRowDataValueMap();
            val = rowDataValueMap.get(this.indexName);
        } else if (context instanceof GlDataExpContext) {
            val = this.execGlData((GlDataExpContext)context);
        } else {
            IDataModel dataModel = context.getDataModel();
            int index = context.getCurrentRowIndex();
            val = dataModel.getValue(this.indexName, index);
        }
        if (val == null) {
            result = BigDecimal.ZERO;
        } else {
            result = ConvertUtils.toDecimal(val);
            if (result == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5217\u503c\u975e\u6570\u503c\u7c7b\u578b", (String)"VariateExpression_1", (String)"epm-eb-common", (Object[])new Object[0]));
            }
            result = result.setScale(10, RoundingMode.HALF_UP);
        }
        if (context.getCurrencyColumnKeys() != null && context.getCurrencyColumnKeys().contains(this.indexName)) {
            result = result.multiply(context.getUnitData());
        }
        return result;
    }

    private Object execGlData(GlDataExpContext context) {
        Object result = null;
        if ("att".equals(this.indexName)) {
            Object account = context.getRowData().get("account");
            Integer accountType = context.getCurrentAccountInfo().get(account);
            if (accountType != null) {
                result = accountType;
            }
        } else {
            result = context.getRowData().get(this.indexName);
        }
        return result;
    }

    @Override
    public String toString() {
        return this.indexName;
    }

    public String getIndexName() {
        return this.indexName;
    }
}

