/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.gridfilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.filter.CompareTypeDto;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterResult;
import kd.bos.entity.flex.FlexBDValueCondition;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.FilterGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.BillFieldTypeEmum;
import kd.epm.eb.common.utils.control.ConditionUtils;

public interface CommonFilter {
    public static final Log logger = LogFactory.getLog(CommonFilter.class);
    public static final List<String> comparator = Arrays.asList("-1", "-2", "-3", "-4", "-5", "-6", "106", "109", "112", "113");

    default public List<Map<String, Object>> getFilterFields(MainEntityType entityType) {
        ArrayList<FilterField> filterFields = new ArrayList<FilterField>();
        Set<String> registField = this.getRegistField(entityType.getName());
        Map allEntities = entityType.getAllEntities();
        for (Map.Entry entry : allEntities.entrySet()) {
            Map fields = ((EntityType)entry.getValue()).getFields();
            for (Map.Entry next : fields.entrySet()) {
                IDataEntityProperty fieldProp = (IDataEntityProperty)next.getValue();
                if (this.isAliaEmpty(fieldProp).booleanValue()) continue;
                String longNuber = fieldProp.getName();
                if (!StringUtils.isEmpty((CharSequence)fieldProp.getParent().getName()) && !entityType.getName().equals(fieldProp.getParent().getName())) {
                    longNuber = fieldProp.getParent() instanceof SubEntryType && fieldProp.getParent().getParent() != null && StringUtils.isNotEmpty((CharSequence)fieldProp.getParent().getParent().getName()) ? fieldProp.getParent().getParent().getName() + "." + fieldProp.getParent().getName() + "." + longNuber : fieldProp.getParent().getName() + "." + longNuber;
                }
                if (!registField.contains(longNuber)) continue;
                filterFields.addAll(this.createFilterFields(entityType, fieldProp));
            }
        }
        for (String field : registField) {
            String realKey;
            DynamicProperty dataEntityProperty = null;
            if (field == null || !field.startsWith("model.") || (realKey = field.replaceFirst("model.", "")) == null) continue;
            String[] keys = realKey.split("\\.");
            if (keys.length == 1) {
                dataEntityProperty = entityType.getProperty(keys[0]);
            } else if (keys.length == 2) {
                if (entityType.getAllEntities().containsKey(keys[0])) {
                    if (entityType.getAllEntities().get(keys[0]) != null && !((EntityType)entityType.getAllEntities().get(keys[0])).getFields().isEmpty()) {
                        Map fields = ((EntityType)entityType.getAllEntities().get(keys[0])).getFields();
                        dataEntityProperty = (IDataEntityProperty)fields.get(keys[1]);
                    }
                } else if (entityType.getProperty(keys[0]) != null) {
                    dataEntityProperty = entityType.getProperty(keys[0]);
                }
            } else if (keys.length == 3 && entityType.getAllEntities().containsKey(keys[0])) {
                dataEntityProperty = ((EntityType)entityType.getAllEntities().get(keys[0])).getProperty(keys[1]);
            }
            List<FilterField> allFields = this.createFilterFields(entityType, (IDataEntityProperty)dataEntityProperty);
            for (FilterField ff : allFields) {
                if (!filterFields.stream().noneMatch(k -> k.getFullFieldName() != null && k.getFullFieldName().equals(ff.getFullFieldName()))) continue;
                filterFields.add(ff);
            }
        }
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>(filterFields.size());
        for (FilterField filterField : filterFields) {
            Map filterColumn = filterField.createFilterColumn();
            filterColumn.put("fieldName", filterField.getFullFieldName());
            try {
                ArrayList arrayList2 = (ArrayList)filterColumn.get("compareTypes");
                arrayList2.removeIf(k -> comparator.contains(((CompareTypeDto)k).getId()));
                List compareTypeList = filterField.getCompareTypes().stream().filter(k -> ((List)filterColumn.get("compareTypes")).stream().anyMatch(l -> l.getId().equals(k.getId()))).collect(Collectors.toList());
                filterColumn.put("compareTypeList", compareTypeList);
            }
            catch (Exception e) {
                logger.error("getCompareType error,%s", (Object)e.getMessage());
            }
            arrayList.add(filterColumn);
        }
        return arrayList;
    }

    default public List<FilterField> createFilterFields(MainEntityType entityType, IDataEntityProperty fieldProp) {
        ArrayList<FilterField> list = new ArrayList<FilterField>();
        if (fieldProp instanceof IFieldHandle) {
            IFieldHandle iFieldHandle = (IFieldHandle)fieldProp;
            list.addAll(iFieldHandle.createFilterFields(entityType));
            if ("org".equals(iFieldHandle.getFilterControlType())) {
                for (FilterField filterField : list) {
                    filterField.getCompareTypes().removeIf(k -> Arrays.asList("106", "109", "112", "113").contains(k.getId()));
                }
            }
        }
        return list;
    }

    default public FlexBDValueCondition filterConditionValue(FilterGrid filterGrid, String entityNumber) {
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition filterCondition = filterGridState.getFilterCondition();
        if (filterCondition.getFilterRow().size() > 10) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6700\u591a\u53ea\u80fd\u8bbe\u7f6e10\u4e2a\u63a7\u5236\u6761\u4ef6\u3002", (String)"SuitCondPlugin_2", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        }
        FilterBuilder filterBuilder = ConditionUtils.get().getFilterBuilder(entityNumber, filterCondition);
        FilterResult filterResult = filterBuilder.getFilterObject().getFilterResult();
        String filter = filterResult.getFilterGroup()[0];
        FlexBDValueCondition flexPropertyCon = new FlexBDValueCondition();
        flexPropertyCon.setDescription(new LocaleString(filter));
        flexPropertyCon.setFilterCondition(filterCondition);
        flexPropertyCon.setExpression("");
        return flexPropertyCon;
    }

    default public Boolean isAliaEmpty(IDataEntityProperty fieldProp) {
        MulBasedataProp mulBasedataProp;
        EntryProp entryProp;
        String alias;
        if (fieldProp instanceof EntryProp ? StringUtils.isBlank((CharSequence)(alias = (entryProp = (EntryProp)fieldProp).getDynamicCollectionItemPropertyType().getAlias())) : (fieldProp instanceof MulBasedataProp ? StringUtils.isBlank((CharSequence)(alias = (mulBasedataProp = (MulBasedataProp)fieldProp).getDynamicCollectionItemPropertyType().getAlias())) : StringUtils.isBlank((CharSequence)(alias = fieldProp.getAlias())))) {
            return true;
        }
        return false;
    }

    default public Set<String> getRegistField(String entityNumber) {
        String selectFields = "name,id,number";
        QFilter qcf = new QFilter("type", "=", (Object)BillFieldTypeEmum.REGSITFIELD.getNumber()).and("fieldtable", "=", (Object)entityNumber);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"eb_bgcontrolbizreg", (String)selectFields, (QFilter[])new QFilter[]{qcf});
        Set<String> colSets = query.stream().map(k -> {
            if (k.getString("number").startsWith("model.")) {
                String[] splits = k.getString("number").split("\\.");
                if (splits.length > 2) {
                    ArrayList<String> list = new ArrayList<String>(16);
                    for (int i = 0; i < splits.length; ++i) {
                        if (i == 0 || i == splits.length - 1) continue;
                        list.add(splits[i]);
                    }
                    return String.join((CharSequence)".", list);
                }
                return k.getString("number").replaceFirst("model.", "");
            }
            return k.getString("number");
        }).collect(Collectors.toSet());
        Set regs = query.stream().filter(k -> k.getString("number") != null && k.getString("number").startsWith("model.")).map(k -> k.getString("number")).collect(Collectors.toSet());
        if (!regs.isEmpty()) {
            colSets.addAll(regs);
        }
        return colSets;
    }
}

