/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.lazytree.DimensionMember;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.common.ebcommon.common.Tuple;
import kd.epm.eb.common.lazytree.DimensionMember.MemberTreeNode;
import kd.epm.eb.common.lazytree.ILazyTreeHandler;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.LazyTreeUtils;

public class DimensionMemberTreeHandle
implements ILazyTreeHandler {
    private String treeKey;

    public DimensionMemberTreeHandle() {
        this("treeentryentity");
    }

    public DimensionMemberTreeHandle(String treeKey) {
        this.treeKey = treeKey;
    }

    @Override
    public String getEntryKey() {
        return this.treeKey;
    }

    @Override
    public void doFillEntryRow(DynamicObject row, ITreeNode tree) {
        MemberTreeNode treeNode = (MemberTreeNode)tree;
        row.set("id", (Object)treeNode.getId());
        row.set(4, (Object)treeNode.getNumber());
        row.set(5, (Object)treeNode.getName());
        Map<String, Tuple<String, String, String>> propParams = treeNode.getPropParams();
        if (!propParams.isEmpty()) {
            Tuple<String, String, String> tuple = propParams.get(treeNode.getId().toString());
            if (tuple != null && tuple.p1 != null) {
                row.set(6, tuple.p1);
            }
            if (tuple != null && tuple.p2 != null) {
                row.set(7, tuple.p2);
            }
            if (tuple != null && tuple.p3 != null) {
                row.set(8, tuple.p3);
            }
        }
    }

    @Override
    public boolean match(ITreeNode treeNode, String text) {
        MemberTreeNode memtreeNode = (MemberTreeNode)treeNode;
        return memtreeNode.getNumber().contains(text) || memtreeNode.getName().contains(text);
    }

    @Override
    public List<ITreeNode> findNodeCascadeSuper(Long currNodeId, ITreeNode rootNode) {
        ITreeNode currNode = LazyTreeUtils.getChildNodeByNodeId(currNodeId, rootNode);
        ArrayList<ITreeNode> treeNodes = new ArrayList<ITreeNode>(16);
        for (MemberTreeNode entityTree = (MemberTreeNode)currNode; entityTree != null; entityTree = entityTree.getParent()) {
            treeNodes.add(entityTree);
        }
        Collections.reverse(treeNodes);
        return treeNodes;
    }
}

