/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.lazytree;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.Matchable;

public interface ILazyTreeHandler
extends Matchable {
    public String getEntryKey();

    default public boolean isRootVisable() {
        return true;
    }

    default public boolean needCacheRowIndex() {
        return false;
    }

    default public boolean cacheRootAfterInit() {
        return true;
    }

    default public void fillEntryRow(int index, DynamicObject row, ITreeNode tree) {
        this.doFillEntryRow(row, tree);
        this.afterFillEntryRow(index, row, tree);
        tree.setRowIndex(index);
    }

    public void doFillEntryRow(DynamicObject var1, ITreeNode var2);

    default public void afterFillEntryRow(int index, DynamicObject row, ITreeNode tree) {
        row.set("pid", (Object)tree.getParentId());
        boolean leaf = tree.isLeaf();
        row.set("isGroupNode", (Object)(!leaf ? 1 : 0));
    }

    default public boolean collapseAll() {
        return false;
    }

    @Override
    public boolean match(ITreeNode var1, String var2);

    public List<ITreeNode> findNodeCascadeSuper(Long var1, ITreeNode var2);

    default public String getSearchCacheKey() {
        return "searchInfo";
    }
}

