/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.lazytree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.orm.query.QFilter;
import kd.epm.eb.common.lazytree.ILazyTreeHandler;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.LazyTreeUtils;
import kd.epm.eb.common.lazytree.SearchInfo;
import kd.epm.eb.common.lazytree.datalock.DataLockUtils;
import kd.epm.eb.common.lazytree.datalock.EntityTree;

public class LazyTreeContainer {
    private IDataModel dataModel;
    private IFormView view;
    private ILazyTreeHandler handler;
    private ITreeNode rootNode;

    public LazyTreeContainer(IDataModel dataModel, IFormView view, ILazyTreeHandler handler, ITreeNode rootNode) {
        this.dataModel = dataModel;
        this.view = view;
        this.handler = handler;
        this.rootNode = rootNode;
    }

    public void initTree() {
        List children;
        this.dataModel.deleteEntryData(this.handler.getEntryKey());
        if (this.rootNode == null) {
            return;
        }
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.view.getControl(this.handler.getEntryKey());
        List<Object> expandIds = (ArrayList)entryGrid.getExpandNodes();
        int focusRowIndex = this.view.getModel().getEntryCurrentRowIndex(this.handler.getEntryKey());
        if (expandIds == null) {
            expandIds = new ArrayList();
        } else if (this.rootNode.getId() != null) {
            expandIds = expandIds.stream().filter(x -> x != null && !x.equals(String.valueOf(this.rootNode.getId()))).collect(Collectors.toList());
        }
        boolean rootVisable = this.handler.isRootVisable();
        ArrayList<ITreeNode> needInsertNode = new ArrayList<ITreeNode>(16);
        if (rootVisable) {
            needInsertNode.add(this.rootNode);
        }
        if ((children = this.rootNode.getChildren()) != null) {
            needInsertNode.addAll(children);
        }
        this.insertRow(0, entryGrid, needInsertNode, true);
        this.view.updateView(this.handler.getEntryKey());
        if (this.handler.cacheRootAfterInit()) {
            this.view.getPageCache().put("cacheRoot", SerializationUtils.serializeToBase64((Object)this.rootNode));
        }
        ArrayList<Integer> rowIndexs = new ArrayList<Integer>();
        DynamicObjectCollection objs = null;
        for (int i = 0; i < expandIds.size(); ++i) {
            int row = -1;
            if (objs == null) {
                objs = this.view.getModel().getEntryEntity(this.handler.getEntryKey());
            }
            for (int j = 0; j < objs.size(); ++j) {
                if (!expandIds.contains(((DynamicObject)objs.get(j)).getString("id"))) continue;
                row = j;
                if (rowIndexs.contains(row)) {
                    row = -1;
                    continue;
                }
                rowIndexs.add(row);
                break;
            }
            if (row < 0) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("rowkey", row);
            map.put("id", ((DynamicObject)objs.get(row)).get("id"));
            entryGrid.loadChildrenData(map);
            objs = null;
        }
        if (!rowIndexs.isEmpty()) {
            if (this.view.getEntityId().equals("eb_datavalidationlist") || this.view.getEntityId().equals("eb_datavalidationlist_nbg")) {
                entryGrid.setCollapse(true);
                entryGrid.selectRows(focusRowIndex);
            } else {
                entryGrid.expandOne(rowIndexs.stream().mapToInt(Integer::intValue).toArray());
                entryGrid.selectRows(focusRowIndex);
            }
        } else if (children != null) {
            entryGrid.setCollapse(true);
            entryGrid.expandOne(0);
            entryGrid.selectRows(0);
        }
    }

    public void clearTree() {
        this.dataModel.deleteEntryData(this.handler.getEntryKey());
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
        String entryKey = ((TreeEntryGrid)treeNodeEvent.getSource()).getEntryKey();
        int rowIndex = treeNodeEvent.getRowKey();
        DynamicObject row = this.dataModel.getEntryRowEntity(entryKey, rowIndex);
        long nodeId = row.getLong("id");
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.view.getControl(this.handler.getEntryKey());
        ITreeNode currentNode = LazyTreeUtils.getChildNodeByNodeId(nodeId, this.rootNode);
        ArrayList<ITreeNode> needInsertNode = new ArrayList<ITreeNode>(16);
        if (!currentNode.isLeaf()) {
            needInsertNode.addAll(currentNode.getChildren());
        }
        if (!needInsertNode.isEmpty()) {
            this.insertRow(rowIndex, entryGrid, needInsertNode, false);
        }
        this.view.updateView(this.handler.getEntryKey(), rowIndex);
        entryGrid.selectRows(rowIndex, false);
    }

    public void queryPageTreeNodeChildren(ITreeNode parentNode, int rowIndex, Map<String, Set<String>> dataLockData, String modelId, QFilter qFilter, Boolean isSearch) {
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.view.getControl(this.handler.getEntryKey());
        ArrayList<ITreeNode> needInsertNode = new ArrayList<ITreeNode>(16);
        if (!parentNode.isLeaf()) {
            int off = parentNode.getChildren().size() / 1000;
            DataLockUtils.buildPageTree((EntityTree)parentNode, Long.parseLong(modelId), dataLockData, qFilter, off, isSearch);
            needInsertNode.addAll(parentNode.getChildren().stream().skip(off * 1000).collect(Collectors.toList()));
        }
        if (!needInsertNode.isEmpty()) {
            int count = this.dataModel.getEntryRowCount("entryentity");
            if (rowIndex >= count) {
                this.insertRow(rowIndex, entryGrid, needInsertNode, true);
            } else {
                this.insertRow(rowIndex, entryGrid, needInsertNode, false);
            }
        }
        this.view.updateView(this.handler.getEntryKey(), rowIndex);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        if (searchText == null || searchText.trim().equals("")) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u8981\u641c\u7d22\u7684\u5185\u5bb9\u3002", (String)"EbDataPermPlugin_26", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> matchedNodes = LazyTreeUtils.searchMember(this.rootNode, searchText, this.handler);
        if (matchedNodes.isEmpty()) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e", (String)"EbDataPermPlugin_28", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        Long matchNodeId = matchedNodes.get(0);
        this.focusMatchNode(matchNodeId);
        SearchInfo searchInfo = new SearchInfo(0, matchedNodes);
        this.view.getPageCache().put(this.handler.getSearchCacheKey(), SerializationUtils.serializeToBase64((Object)searchInfo));
    }

    private void focusMatchNode(Long matchNodeId) {
        List<ITreeNode> superNodes = this.handler.findNodeCascadeSuper(matchNodeId, this.rootNode);
        if (superNodes == null || superNodes.size() <= 0) {
            return;
        }
        DynamicObjectCollection allRows = this.dataModel.getEntryEntity(this.handler.getEntryKey());
        int[] matchIndexs = new int[superNodes.size()];
        int index = 0;
        int beginIndex = 0;
        ITreeNode node = superNodes.get(index);
        for (int i = 0; i < allRows.size(); ++i) {
            DynamicObject doj = (DynamicObject)allRows.get(i);
            if (node.getId().longValue() != doj.getLong("id")) continue;
            matchIndexs[index] = i;
            beginIndex = i;
            if (++index < superNodes.size()) {
                node = superNodes.get(index);
                continue;
            }
            node = null;
            break;
        }
        TreeEntryGrid entryGrid = (TreeEntryGrid)this.view.getControl(this.handler.getEntryKey());
        if (node != null && index > 0) {
            ArrayList<ITreeNode> needInsertNode = new ArrayList<ITreeNode>(16);
            this.getNeedInsertNode(superNodes, matchIndexs, index - 1, needInsertNode, beginIndex);
            if (!needInsertNode.isEmpty()) {
                this.insertRow(matchIndexs[index - 1], entryGrid, needInsertNode, false);
            }
            this.view.updateView(this.handler.getEntryKey());
        }
        entryGrid.selectRows(matchIndexs[matchIndexs.length - 1]);
        int[] copys = Arrays.copyOf(matchIndexs, matchIndexs.length - 1);
        entryGrid.expandOne(copys);
    }

    public void searchBefore() {
        this.searchSkip(-1);
    }

    public void searchNext() {
        this.searchSkip(1);
    }

    private void searchSkip(int skipStep) {
        String matchInfoStr = this.view.getPageCache().get(this.handler.getSearchCacheKey());
        if (matchInfoStr == null) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u641c\u7d22\u5185\u5bb9", (String)"EbDataPermPlugin_14", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        SearchInfo searchInfo = (SearchInfo)SerializationUtils.deSerializeFromBase64((String)matchInfoStr);
        int matchIndex = searchInfo.getCurrentMatchIndex() + skipStep;
        List<Long> matchNodes = searchInfo.getMatchNodes();
        if (matchIndex < 0) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u884c\u5185\u5bb9\u3002", (String)"EbDataPermPlugin_16", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else if (matchIndex >= matchNodes.size()) {
            this.view.showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u884c\u5185\u5bb9\u3002", (String)"EbDataPermPlugin_17", (String)"epm-eb-formplugin", (Object[])new Object[0]));
        } else {
            this.focusMatchNode(matchNodes.get(matchIndex));
            searchInfo.setCurrentMatchIndex(matchIndex);
            this.view.getPageCache().put(this.handler.getSearchCacheKey(), SerializationUtils.serializeToBase64((Object)searchInfo));
        }
    }

    private void insertRow(int rowIndex, TreeEntryGrid entryGrid, List<ITreeNode> needInsertNode, boolean isCreate) {
        if (needInsertNode.isEmpty()) {
            return;
        }
        this.dataModel.beginInit();
        int[] indexs = this.handler.needCacheRowIndex() ? this.dataModel.batchCreateNewEntryRow(this.handler.getEntryKey(), needInsertNode.size()) : (isCreate ? this.dataModel.batchCreateNewEntryRow(this.handler.getEntryKey(), needInsertNode.size()) : this.dataModel.batchInsertEntryRow(this.handler.getEntryKey(), rowIndex, needInsertNode.size()));
        this.dataModel.endInit();
        for (int i = 0; i < indexs.length; ++i) {
            DynamicObject row = this.dataModel.getEntryRowEntity(this.handler.getEntryKey(), indexs[i]);
            this.handler.fillEntryRow(indexs[i], row, needInsertNode.get(i));
        }
        entryGrid.collapse(indexs);
    }

    private void getNeedInsertNode(List<ITreeNode> superNodes, int[] matchIndexs, int index, List<ITreeNode> needInsertNode, int beginIndex) {
        ITreeNode currNode = superNodes.get(index++);
        ITreeNode nextNode = index < superNodes.size() ? superNodes.get(index) : null;
        List children = currNode.getChildren();
        if (currNode.isLeaf()) {
            return;
        }
        for (ITreeNode treeNode : children) {
            needInsertNode.add(treeNode);
            if (!treeNode.equals(nextNode)) continue;
            matchIndexs[index] = beginIndex + needInsertNode.size();
            if (index >= superNodes.size() - 1) continue;
            this.getNeedInsertNode(superNodes, matchIndexs, index, needInsertNode, beginIndex);
        }
    }
}

