/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.lazytree.bgmdDatalock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockPeriodTreeNode;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockUtils;
import kd.epm.eb.common.lazytree.ILazyTreeHandler;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.LazyTreeUtils;
import kd.epm.eb.common.lazytree.bgmdDatalock.BgmdEntityTree;

public class BgmdDataLockLazyTreeHandler
implements ILazyTreeHandler {
    @Override
    public String getEntryKey() {
        return "entryentity";
    }

    @Override
    public void doFillEntryRow(DynamicObject row, ITreeNode tree) {
        BgmdEntityTree entityTree = (BgmdEntityTree)tree;
        row.set("id", (Object)entityTree.getId());
        row.set("name", (Object)entityTree.getName());
        row.set("number", (Object)entityTree.getNumber());
        int periodInteger = entityTree.getPeriodIntegerCascadeSuper();
        this.doFillEntityPeriodRow(row, periodInteger);
    }

    public void doFillEntityPeriodRow(DynamicObject row, int periodInteger) {
        List<BgmdDataLockPeriodTreeNode> periodNumberList = BgmdDataLockUtils.getPeriodNumberList();
        for (BgmdDataLockPeriodTreeNode bgmdDataLockPeriodTreeNode : periodNumberList) {
            row.set(bgmdDataLockPeriodTreeNode.getNumber(), (Object)BgmdDataLockUtils.checkLock(periodInteger, bgmdDataLockPeriodTreeNode.getPeriods()));
        }
    }

    @Override
    public boolean match(ITreeNode treeNode, String text) {
        BgmdEntityTree entityTree = (BgmdEntityTree)treeNode;
        return entityTree.getName().contains(text) || entityTree.getNumber().contains(text);
    }

    @Override
    public List<ITreeNode> findNodeCascadeSuper(Long currNodeId, ITreeNode rootNode) {
        ITreeNode currNode = LazyTreeUtils.getChildNodeByNodeId(currNodeId, rootNode);
        ArrayList<ITreeNode> treeNodes = new ArrayList<ITreeNode>(16);
        for (BgmdEntityTree entityTree = (BgmdEntityTree)currNode; entityTree != null; entityTree = entityTree.getParent()) {
            treeNodes.add(entityTree);
        }
        Collections.reverse(treeNodes);
        return treeNodes;
    }
}

