/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.lazytree.bgmdDatalock;

import java.util.List;
import kd.epm.eb.common.lazytree.ITreeNode;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BgmdEntityTree
implements ITreeNode<BgmdEntityTree> {
    private static final long serialVersionUID = -2192737512515571676L;
    private long id;
    private String name;
    private String number;
    private BgmdEntityTree parent;
    private List<BgmdEntityTree> children;
    private Integer periodInteger;

    public BgmdEntityTree(long id, String name, String number, BgmdEntityTree parent, List<BgmdEntityTree> children, Integer periodInteger) {
        this.id = id;
        this.name = name;
        this.number = number;
        this.parent = parent;
        this.children = children;
        this.periodInteger = periodInteger;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public BgmdEntityTree getParent() {
        return this.parent;
    }

    public void setParent(BgmdEntityTree parent) {
        this.parent = parent;
    }

    @Override
    public List<BgmdEntityTree> getChildren() {
        return this.children;
    }

    public void setChildren(List<BgmdEntityTree> children) {
        this.children = children;
    }

    public Integer getPeriodInteger() {
        return this.periodInteger;
    }

    public void setPeriodInteger(Integer periodInteger) {
        this.periodInteger = periodInteger;
    }

    @Override
    public long getParentId() {
        return this.parent == null ? 0L : this.parent.getId();
    }

    public int getPeriodIntegerCascadeSuper() {
        if (this.getPeriodInteger() != null) {
            return this.getPeriodInteger();
        }
        if (this.getParent() != null) {
            return this.getParent().getPeriodIntegerCascadeSuper();
        }
        return 0;
    }

    public Integer getChildrenPeriodInteger() {
        Integer periodInteger = null;
        if (CollectionUtils.isNotEmpty(this.getChildren())) {
            for (BgmdEntityTree child : this.getChildren()) {
                Integer childPeriodInteger = child.getPeriodIntegerCascadeSuper();
                if (periodInteger == null) {
                    periodInteger = childPeriodInteger;
                    continue;
                }
                periodInteger = periodInteger & childPeriodInteger;
            }
        }
        return periodInteger;
    }

    @Override
    public boolean isLeaf() {
        return this.children == null || this.children.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BgmdEntityTree that = (BgmdEntityTree)o;
        return new EqualsBuilder().append(this.id, that.id).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.id).toHashCode();
    }

    public String toString() {
        return this.name;
    }

    public BgmdEntityTree getNodeByNumber(String number) {
        if (this.number.equals(number)) {
            return this;
        }
        if (this.getChildren() != null) {
            for (BgmdEntityTree child : this.getChildren()) {
                BgmdEntityTree nodeByNumber = child.getNodeByNumber(number);
                if (nodeByNumber == null) continue;
                return nodeByNumber;
            }
        }
        return null;
    }
}

