/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.lazytree.datalock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.common.lazytree.ILazyTreeHandler;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.LazyTreeUtils;
import kd.epm.eb.common.lazytree.datalock.EntityTree;
import kd.epm.eb.common.lazytree.datalock.PeriodEnable;

public class DataLockLazyTreeHandler
implements ILazyTreeHandler {
    @Override
    public String getEntryKey() {
        return "entryentity";
    }

    @Override
    public void doFillEntryRow(DynamicObject row, ITreeNode tree) {
        EntityTree entityTree = (EntityTree)tree;
        row.set("id", (Object)entityTree.getId());
        row.set("name", (Object)entityTree.getName());
        row.set("number", (Object)entityTree.getNumber());
        List<PeriodEnable> periodEnables = entityTree.getPeriodEnablesCascadeSuperAndChildren();
        for (PeriodEnable periodEnable : periodEnables) {
            row.set(periodEnable.getPeriodNumber(), (Object)periodEnable.isEnable());
        }
    }

    @Override
    public boolean match(ITreeNode treeNode, String text) {
        EntityTree entityTree = (EntityTree)treeNode;
        return entityTree.getName().contains(text) || entityTree.getNumber().contains(text);
    }

    @Override
    public List<ITreeNode> findNodeCascadeSuper(Long currNodeId, ITreeNode rootNode) {
        ITreeNode currNode = LazyTreeUtils.getChildNodeByNodeId(currNodeId, rootNode);
        ArrayList<ITreeNode> treeNodes = new ArrayList<ITreeNode>(16);
        for (EntityTree entityTree = (EntityTree)currNode; entityTree != null; entityTree = entityTree.getParent()) {
            treeNodes.add(entityTree);
        }
        Collections.reverse(treeNodes);
        return treeNodes;
    }
}

