/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.lazytree.datalock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.datalock.EntityTree;
import kd.epm.eb.common.lazytree.datalock.PeriodEnable;
import org.apache.commons.collections4.CollectionUtils;

public class DataLockUtils {
    private static final String selectFields = "id,name,number,parent,longnumber,isleaf";
    public static final int PAGE_SIZE = 1000;
    private static final String LOAD_MORE_NUMBER = "...loadMore...";
    private static final Log log = LogFactory.getLog(DataLockUtils.class);

    public static EntityTree buildPageTree(EntityTree parent, long modelId, Map<String, Set<String>> dataLockData, QFilter qFilter, int off, Boolean isSearch) {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        List<Member> members = modelCache.getMembers(null, SysDimensionEnum.Period.getNumber());
        members = members.stream().filter(member -> !member.getNumber().equals(SysDimensionEnum.Period.getNumber())).collect(Collectors.toList());
        if (parent == null) {
            QFilter qFilter1 = new QFilter("level", "=", (Object)1).and("model", "=", (Object)modelId);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)SysDimensionEnum.Entity.getMemberTreemodel(), (String)selectFields, (QFilter[])qFilter1.toArray());
            String rootNumber = dynamicObject.getString("number");
            List<PeriodEnable> beginPeriodEnables = dataLockData.containsKey(rootNumber) ? DataLockUtils.getPeriodEnables(members, dataLockData.get(rootNumber)) : DataLockUtils.getDefaultPeriodEnables(members);
            parent = new EntityTree(dynamicObject.getLong("id"), dynamicObject.getString("name"), rootNumber, null, null, beginPeriodEnables);
        }
        qFilter.and("model", "=", (Object)modelId);
        DataLockUtils.initPageChildren(parent, members, dataLockData, qFilter, off, isSearch);
        return parent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DynamicObjectCollection queryPage(String memberKey, String selectFields, QFilter[] filters, String orderBys, int off, int len) {
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("kd.epm.eb.common.datalock.DataLockUtils", memberKey, selectFields, filters, orderBys, off * 1000, len);){
            DynamicObjectCollection dynamicObjectCollection = orm.toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
    }

    public static List<PeriodEnable> getPeriodEnables(List<Member> members, Set<String> periods) {
        ArrayList<PeriodEnable> periodEnables = new ArrayList<PeriodEnable>(members.size());
        members.forEach(member -> {
            String periodNumber = member.getNumber();
            periodEnables.add(new PeriodEnable(periodNumber.toLowerCase(), periods.contains(periodNumber)));
        });
        return periodEnables;
    }

    private static EntityTree initPageChildren(EntityTree parent, List<Member> members, Map<String, Set<String>> dataLockData, QFilter qFilter, int off, Boolean isSearch) {
        DynamicObjectCollection query = DataLockUtils.queryPage(SysDimensionEnum.Entity.getMemberTreemodel(), selectFields, qFilter.toArray(), "level,dseq", off, 1001);
        if (CollectionUtils.isNotEmpty((Collection)query)) {
            ArrayList<ITreeNode> entityTrees = new ArrayList<ITreeNode>(query.size());
            int i = 0;
            for (DynamicObject dynamicObject : query) {
                if (i == 1000) {
                    EntityTree entityTree = new EntityTree(dynamicObject.getLong("id"), ResManager.loadKDString((String)"...\u52a0\u8f7d\u66f4\u591a...", (String)"RuleControlAllotOrgPlugin_0", (String)"epm-eb-formplugin", (Object[])new Object[0]), LOAD_MORE_NUMBER, parent, null, null);
                    entityTree.setChildren(null);
                    entityTrees.add(entityTree);
                    break;
                }
                String number = dynamicObject.getString("number");
                Boolean isleaf = isSearch != false ? true : dynamicObject.getBoolean("isleaf");
                List<PeriodEnable> periodEnables = dataLockData.containsKey(number) ? DataLockUtils.getPeriodEnables(members, dataLockData.get(number)) : null;
                EntityTree entityTree = new EntityTree(dynamicObject.getLong("id"), dynamicObject.getString("name"), number, parent, null, periodEnables);
                if (!isleaf.booleanValue()) {
                    entityTree.setChildren(new ArrayList<ITreeNode>(16));
                }
                entityTrees.add(entityTree);
                ++i;
            }
            if (parent.getChildren() != null && !parent.getChildren().isEmpty()) {
                parent.getChildren().addAll(entityTrees);
            } else {
                parent.setChildren(entityTrees);
            }
        }
        return parent;
    }

    private static List<ITreeNode> createChildren(EntityTree parent, Member rootMember, List<Member> members, Map<String, Set<String>> dataLockData) {
        List<Member> children = rootMember.getChildren(true);
        if (CollectionUtils.isNotEmpty(children)) {
            ArrayList<ITreeNode> entityTrees = new ArrayList<ITreeNode>(children.size());
            for (Member child : children) {
                List<PeriodEnable> periodEnables = dataLockData.containsKey(child.getNumber()) ? DataLockUtils.getPeriodEnables(members, dataLockData.get(child.getNumber())) : null;
                EntityTree entityTree = new EntityTree(child.getId(), child.getName(), child.getNumber(), parent, null, periodEnables);
                entityTree.setChildren(DataLockUtils.createChildren(entityTree, child, members, dataLockData));
                entityTrees.add(entityTree);
            }
            return entityTrees;
        }
        return null;
    }

    public static List<PeriodEnable> getDefaultPeriodEnables(List<Member> members) {
        ArrayList<PeriodEnable> periodEnables = new ArrayList<PeriodEnable>(members.size());
        members.forEach(member -> periodEnables.add(new PeriodEnable(member.getNumber().toLowerCase(), false)));
        return periodEnables;
    }

    public static List<String> getPeriods(IModelCacheHelper modelCache, boolean isLow) {
        Member rootMember = modelCache.getMember(SysDimensionEnum.Period.getNumber(), null, "Period");
        ArrayList<String> periods = new ArrayList<String>(16);
        DataLockUtils.getPeriods(rootMember, periods, isLow);
        return periods;
    }

    private static void getPeriods(Member rootMember, List<String> periods, boolean isLow) {
        List<Member> children;
        String number = rootMember.getNumber();
        if (!"Period".equals(number)) {
            if (isLow) {
                periods.add(number.toLowerCase());
            } else {
                periods.add(number);
            }
        }
        if (CollectionUtils.isNotEmpty(children = rootMember.getChildrenNotWithCosmic())) {
            for (Member child : children) {
                DataLockUtils.getPeriods(child, periods, isLow);
            }
        }
    }

    public static List<PeriodEnable> getPeriodEnables(DynamicObject currRow, List<String> periods) {
        ArrayList<PeriodEnable> periodEnables = new ArrayList<PeriodEnable>(16);
        for (String period : periods) {
            periodEnables.add(new PeriodEnable(period, currRow.getBoolean(period)));
        }
        return periodEnables;
    }
}

