/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.lazytree.datalock;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.datalock.PeriodEnable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class EntityTree
implements ITreeNode {
    private static final long serialVersionUID = 7492864465757451767L;
    private long id;
    private String name;
    private String number;
    private EntityTree parent;
    private List<ITreeNode> children;
    private List<PeriodEnable> periodEnables;

    public EntityTree(long id, String name, String number, EntityTree parent, List<ITreeNode> children, List<PeriodEnable> periodEnables) {
        this.id = id;
        this.name = name;
        this.number = number;
        this.parent = parent;
        this.children = children;
        this.periodEnables = periodEnables;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public EntityTree getParent() {
        return this.parent;
    }

    public void setParent(EntityTree parent) {
        this.parent = parent;
    }

    public List<ITreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<ITreeNode> children) {
        this.children = children;
    }

    public List<PeriodEnable> getPeriodEnables() {
        return this.periodEnables;
    }

    public void setPeriodEnables(List<PeriodEnable> periodEnables) {
        this.periodEnables = periodEnables;
    }

    @Override
    public long getParentId() {
        return this.parent == null ? 0L : this.parent.getId();
    }

    public List<PeriodEnable> getPeriodEnablesCascadeSuperAndChildren() {
        List<PeriodEnable> startPeriodEnable = this.getPeriodEnablesCascadeSuper();
        List<PeriodEnable> returnPeriodEnable = new ArrayList<PeriodEnable>(startPeriodEnable.size());
        if (this.children != null) {
            for (ITreeNode child : this.children) {
                PeriodEnable childPeriodEnable;
                PeriodEnable rootPeriodEnable;
                int i;
                EntityTree _child = (EntityTree)child;
                List<PeriodEnable> childPeriodEnables = _child.getPeriodEnablesCascadeChildren();
                if (childPeriodEnables == null || childPeriodEnables.isEmpty()) continue;
                if (returnPeriodEnable.isEmpty()) {
                    for (i = 0; i < startPeriodEnable.size(); ++i) {
                        rootPeriodEnable = startPeriodEnable.get(i);
                        childPeriodEnable = childPeriodEnables.get(i);
                        returnPeriodEnable.add(new PeriodEnable(rootPeriodEnable.getPeriodNumber(), rootPeriodEnable.isEnable() && childPeriodEnable.isEnable()));
                    }
                    continue;
                }
                for (i = 0; i < returnPeriodEnable.size(); ++i) {
                    rootPeriodEnable = returnPeriodEnable.get(i);
                    childPeriodEnable = childPeriodEnables.get(i);
                    rootPeriodEnable.setEnable(rootPeriodEnable.isEnable() && childPeriodEnable.isEnable());
                }
            }
        }
        if (returnPeriodEnable.isEmpty()) {
            returnPeriodEnable = startPeriodEnable;
        }
        return returnPeriodEnable;
    }

    public List<PeriodEnable> getPeriodEnablesCascadeChildren() {
        List<PeriodEnable> returnPeriodEnable = new ArrayList<PeriodEnable>(16);
        if (this.children != null) {
            for (ITreeNode child : this.children) {
                PeriodEnable childPeriodEnable;
                PeriodEnable rootPeriodEnable;
                int i;
                EntityTree _child = (EntityTree)child;
                List<PeriodEnable> childPeriodEnables = _child.getPeriodEnablesCascadeChildren();
                if (childPeriodEnables == null || childPeriodEnables.isEmpty()) continue;
                if (this.periodEnables == null) {
                    if (returnPeriodEnable.isEmpty()) {
                        for (i = 0; i < childPeriodEnables.size(); ++i) {
                            PeriodEnable childPeriodEnable2 = childPeriodEnables.get(i);
                            returnPeriodEnable.add(new PeriodEnable(childPeriodEnable2.getPeriodNumber(), childPeriodEnable2.isEnable()));
                        }
                        continue;
                    }
                    for (i = 0; i < returnPeriodEnable.size(); ++i) {
                        rootPeriodEnable = returnPeriodEnable.get(i);
                        childPeriodEnable = childPeriodEnables.get(i);
                        rootPeriodEnable.setEnable(rootPeriodEnable.isEnable() && childPeriodEnable.isEnable());
                    }
                    continue;
                }
                if (returnPeriodEnable.isEmpty()) {
                    for (i = 0; i < childPeriodEnables.size(); ++i) {
                        rootPeriodEnable = this.periodEnables.get(i);
                        childPeriodEnable = childPeriodEnables.get(i);
                        returnPeriodEnable.add(new PeriodEnable(childPeriodEnable.getPeriodNumber(), rootPeriodEnable.isEnable() && childPeriodEnable.isEnable()));
                    }
                    continue;
                }
                for (i = 0; i < returnPeriodEnable.size(); ++i) {
                    rootPeriodEnable = returnPeriodEnable.get(i);
                    childPeriodEnable = childPeriodEnables.get(i);
                    rootPeriodEnable.setEnable(rootPeriodEnable.isEnable() && childPeriodEnable.isEnable());
                }
            }
        }
        if (returnPeriodEnable.isEmpty()) {
            returnPeriodEnable = this.periodEnables;
        }
        return returnPeriodEnable;
    }

    public List<PeriodEnable> getPeriodEnablesCascadeSuper() {
        if (this.periodEnables != null) {
            return this.periodEnables;
        }
        if (this.parent != null) {
            return this.parent.getPeriodEnablesCascadeSuper();
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isLeaf() {
        return this.children == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityTree that = (EntityTree)o;
        return new EqualsBuilder().append(this.id, that.id).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.id).toHashCode();
    }

    public String toString() {
        return this.name;
    }
}

