/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.lazytree.paramterControl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.common.lazytree.ILazyTreeHandler;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.LazyTreeUtils;
import kd.epm.eb.common.tree.model.AuthorOrgTreeNode;

public class ParamterControlLazyTreeHandler
implements ILazyTreeHandler {
    private String billName;
    private Map<String, Boolean> balanceMap = new HashMap<String, Boolean>(16);
    private Map<String, Boolean> checkMemPermissionMap = new HashMap<String, Boolean>(16);
    private Map<String, Boolean> beyondMessageMap = new HashMap<String, Boolean>(16);

    public ParamterControlLazyTreeHandler(String billName) {
        this.billName = billName;
    }

    public ParamterControlLazyTreeHandler setBalanceMap(Map<String, Boolean> balanceMap) {
        this.balanceMap = balanceMap;
        return this;
    }

    public ParamterControlLazyTreeHandler setCheckMemPermissionMap(Map<String, Boolean> checkMemPermissionMap) {
        this.checkMemPermissionMap = checkMemPermissionMap;
        return this;
    }

    public ParamterControlLazyTreeHandler setBeyondMessageMap(Map<String, Boolean> beyondMessageMap) {
        this.beyondMessageMap = beyondMessageMap;
        return this;
    }

    @Override
    public String getEntryKey() {
        return "treeentryentity";
    }

    @Override
    public void doFillEntryRow(DynamicObject row, ITreeNode tree) {
        AuthorOrgTreeNode entityTree = (AuthorOrgTreeNode)tree;
        row.set("id", (Object)entityTree.getId());
        row.set("administrativeorg", (Object)entityTree.getName());
        row.set("isinfluential", (Object)entityTree.getHasRight());
        row.set("billname", (Object)this.billName);
        row.set("orgnumber", (Object)entityTree.getNumber());
        row.set("longnumber", (Object)entityTree.getLongNumber());
        row.set("orgid", (Object)entityTree.getId());
        this.setTreeNodeControlParamValue(row, entityTree, this.balanceMap, "showebbalance");
        this.setTreeNodeControlParamValue(row, entityTree, this.checkMemPermissionMap, "showcheckmempermission");
        this.setTreeNodeControlParamValue(row, entityTree, this.beyondMessageMap, "showbeyondmessage");
        AuthorOrgTreeNode parent = entityTree.getParent();
        if (parent == null) {
            row.set("parent", (Object)-1);
        } else {
            row.set("parent", (Object)parent.getId());
        }
    }

    private void setTreeNodeControlParamValue(DynamicObject row, AuthorOrgTreeNode entityTree, Map<String, Boolean> controlParamMap, String controlParam) {
        if (controlParamMap != null && controlParamMap.containsKey(entityTree.getNumber())) {
            row.set(controlParam, (Object)controlParamMap.get(entityTree.getNumber()));
        } else {
            String longnumber = entityTree.getLongNumber();
            String[] split = longnumber.split("!");
            if (split.length >= 2) {
                for (int k = split.length - 2; k >= 0; --k) {
                    if (controlParamMap != null && controlParamMap.containsKey(split[k])) {
                        row.set(controlParam, (Object)controlParamMap.get(split[k]));
                        break;
                    }
                    row.set(controlParam, (Object)Boolean.FALSE);
                }
            }
        }
    }

    @Override
    public boolean match(ITreeNode treeNode, String text) {
        AuthorOrgTreeNode entityTree = (AuthorOrgTreeNode)treeNode;
        return entityTree.getName().contains(text);
    }

    @Override
    public List<ITreeNode> findNodeCascadeSuper(Long currNodeId, ITreeNode rootNode) {
        ITreeNode currNode = LazyTreeUtils.getChildNodeByNodeId(currNodeId, rootNode);
        ArrayList<ITreeNode> treeNodes = new ArrayList<ITreeNode>(16);
        for (AuthorOrgTreeNode entityTree = (AuthorOrgTreeNode)currNode; entityTree != null; entityTree = entityTree.getParent()) {
            treeNodes.add(entityTree);
        }
        Collections.reverse(treeNodes);
        return treeNodes;
    }
}

