/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.lazytree.versionCopy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.lazytree.ILazyTreeHandler;
import kd.epm.eb.common.lazytree.ITreeNode;
import kd.epm.eb.common.lazytree.LazyTreeUtils;
import kd.epm.eb.common.lazytree.versionCopy.ExecutorSatusEnum;
import kd.epm.eb.common.lazytree.versionCopy.VersionCopyTreeNode;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.versioncopy.VersionCopyConditionDto;
import org.apache.commons.collections4.CollectionUtils;

public class VersionCopyLazyTreeHandler
implements ILazyTreeHandler {
    private IDataModel model;

    @Override
    public String getEntryKey() {
        return "treeentryentity";
    }

    public VersionCopyLazyTreeHandler(IDataModel model) {
        this.model = model;
    }

    @Override
    public void doFillEntryRow(DynamicObject row, ITreeNode tree) {
        VersionCopyTreeNode versionCopyTreeNode = (VersionCopyTreeNode)tree;
        DynamicObject versionCopyScheme = versionCopyTreeNode.getVersionCopyScheme();
        if (versionCopyTreeNode.getParent() != null) {
            DynamicObject record;
            if (versionCopyScheme != null) {
                DynamicObject model = versionCopyScheme.getDynamicObject("model");
                if (model == null) {
                    return;
                }
                IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate(model.getLong("id"));
                row.set("schemenum", (Object)versionCopyScheme.getString("schemenum"));
                row.set("schemename", (Object)versionCopyScheme.getString("schemename"));
                row.set("tarversion", (Object)versionCopyScheme.getDynamicObject("tarversion").getLong("id"));
                List ent_datatype = versionCopyScheme.getDynamicObjectCollection("ent_datatype").stream().map(x -> x.getString("datatype.name")).collect(Collectors.toList());
                row.set("datatype", (Object)String.join((CharSequence)",", ent_datatype));
                List ent_period = versionCopyScheme.getDynamicObjectCollection("ent_period").stream().map(x -> x.getString("period.name")).collect(Collectors.toList());
                row.set("period", (Object)String.join((CharSequence)",", ent_period));
                this.model.setValue("version", (Object)versionCopyScheme.getDynamicObject("srcversion").getLong("id"));
                DynamicObject modelValue = (DynamicObject)this.model.getValue("version");
                row.set("srcversion", (Object)modelValue.getString("name"));
                this.model.setValue("version", (Object)versionCopyScheme.getDynamicObject("tarversion").getLong("id"));
                modelValue = (DynamicObject)this.model.getValue("version");
                row.set("tarversion", (Object)modelValue.getString("name"));
                row.set("executeparam", (Object)this.createExectPparams(versionCopyScheme));
                String dimmemberjson = versionCopyScheme.getString("dimmemberjson");
                if (StringUtils.isNotEmpty(dimmemberjson)) {
                    List versionCopyConditionDtos = SerializationUtils.fromJsonStringToList((String)dimmemberjson, VersionCopyConditionDto.class);
                    if (CollectionUtils.isNotEmpty((Collection)versionCopyConditionDtos)) {
                        ArrayList<String> infoList = new ArrayList<String>(16);
                        List<Long> viewIDs = versionCopyConditionDtos.stream().map(x -> x.getViewId()).collect(Collectors.toList());
                        Map<Long, DynamicObject> viewInfoById = DimensionViewServiceHelper.getInstance().getViewInfoById(viewIDs);
                        for (VersionCopyConditionDto versionCopyConditionDto : versionCopyConditionDtos) {
                            DynamicObject dynamicObject;
                            StringBuilder stringBuilder = new StringBuilder();
                            Dimension dimension = modelCacheHelper.getDimension(versionCopyConditionDto.getDimNumber());
                            stringBuilder.append(dimension.getName());
                            Long viewId = versionCopyConditionDto.getViewId();
                            if (IDUtils.isNotNull(viewId) && (dynamicObject = viewInfoById.get(viewId)) != null) {
                                String name = dynamicObject.getString("name");
                                stringBuilder.append(name);
                            }
                            stringBuilder.append(":");
                            List<MemberCondition> conditions = versionCopyConditionDto.getConditions();
                            if (CollectionUtils.isNotEmpty(conditions)) {
                                ArrayList<String> memberInfo = new ArrayList<String>(16);
                                for (MemberCondition condition : conditions) {
                                    RangeEnum rangeByVal = RangeEnum.getRangeByVal(condition.getRange());
                                    if (rangeByVal != null) {
                                        memberInfo.add(condition.getName() + rangeByVal.getName());
                                        continue;
                                    }
                                    memberInfo.add(condition.getName());
                                }
                                stringBuilder.append(String.join((CharSequence)",", memberInfo));
                                if (SysDimensionEnum.DataType.getNumber().equals(versionCopyConditionDto.getDimNumber())) {
                                    row.set("datatype", (Object)String.join((CharSequence)",", memberInfo));
                                } else if (SysDimensionEnum.BudgetPeriod.getNumber().equals(versionCopyConditionDto.getDimNumber())) {
                                    row.set("period", (Object)String.join((CharSequence)",", memberInfo));
                                }
                            }
                            infoList.add(stringBuilder.toString());
                        }
                        row.set("dimmemberjson", (Object)String.join((CharSequence)";", infoList));
                    }
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    Dimension dataDimension = modelCacheHelper.getDimension(SysDimensionEnum.DataType.getNumber());
                    stringBuilder.append(dataDimension.getName()).append(":");
                    stringBuilder.append(String.join((CharSequence)(RangeEnum.ONLY.getName() + ","), ent_datatype)).append(";");
                    Dimension periodDimension = modelCacheHelper.getDimension(SysDimensionEnum.BudgetPeriod.getNumber());
                    stringBuilder.append(periodDimension.getName()).append(":");
                    stringBuilder.append(String.join((CharSequence)(RangeEnum.ONLY.getName() + ","), ent_period));
                    row.set("dimmemberjson", (Object)stringBuilder.toString());
                }
            }
            if ((record = versionCopyTreeNode.getRecord()) != null) {
                this.model.setValue("executor", (Object)record.getLong("executor"));
                DynamicObject modelValue = (DynamicObject)this.model.getValue("executor");
                row.set("executorname", (Object)modelValue.getString("name"));
                row.set("executetime", (Object)record.getDate("executetime"));
                row.set("status", (Object)ExecutorSatusEnum.getValue(record.getString("status")));
                row.set("newmsg", (Object)record.getString("status"));
            }
        }
        row.set("id", (Object)versionCopyTreeNode.getId());
        row.set("entitynum", (Object)versionCopyTreeNode.getNumber());
        row.set("entityName", (Object)versionCopyTreeNode.getName());
    }

    private String createExectPparams(DynamicObject versionCopyScheme) {
        StringBuilder s = new StringBuilder();
        String version_1 = versionCopyScheme.getDynamicObject("srcversion").getString("name");
        String version_2 = versionCopyScheme.getDynamicObject("tarversion").getString("name");
        List trial_1 = versionCopyScheme.getDynamicObjectCollection("ent_srctrial").stream().map(x -> x.getString("srctrial.name")).collect(Collectors.toList());
        List trial_2 = versionCopyScheme.getDynamicObjectCollection("ent_tartrial").stream().map(x -> x.getString("tartrial.name")).collect(Collectors.toList());
        s.append(ResManager.loadResFormat((String)"\u6e90\u7248\u672c:[%1],\u76ee\u6807\u7248\u672c:[%2],\u6e90\u7ebf\u7d22:[%3],\u76ee\u6807\u7ebf\u7d22:[%4]", (String)"VersionCopyLazyTreeHandler_0", (String)"epm-eb-common", (Object[])new Object[]{version_1, version_2, String.join((CharSequence)",", trial_1), String.join((CharSequence)",", trial_2)}));
        return s.toString();
    }

    @Override
    public boolean match(ITreeNode treeNode, String text) {
        VersionCopyTreeNode versionCopyTreeNode = (VersionCopyTreeNode)treeNode;
        return versionCopyTreeNode.getName().contains(text) || versionCopyTreeNode.getNumber().contains(text);
    }

    @Override
    public List<ITreeNode> findNodeCascadeSuper(Long currNodeId, ITreeNode rootNode) {
        ITreeNode currNode = LazyTreeUtils.getChildNodeByNodeId(currNodeId, rootNode);
        ArrayList<ITreeNode> treeNodes = new ArrayList<ITreeNode>(16);
        for (VersionCopyTreeNode entityTree = (VersionCopyTreeNode)currNode; entityTree != null; entityTree = entityTree.getParent()) {
            treeNodes.add(entityTree);
        }
        Collections.reverse(treeNodes);
        return treeNodes;
    }

    @Override
    public boolean isRootVisable() {
        return true;
    }

    @Override
    public boolean collapseAll() {
        return false;
    }
}

