/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.lazytree.versionCopy;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.lazytree.versionCopy.VersionCopyTreeNode;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ModelServiceHelper;
import org.apache.commons.collections4.CollectionUtils;

public class VersionCopyUtils {
    public static VersionCopyTreeNode buildTree(Member rootMember, Long modelId, long businessModelId, DynamicObject versionCopyScheme, Map<Long, List<DynamicObject>> recordMap) {
        if (IDUtils.isEmptyLong(modelId).booleanValue() || businessModelId == 0L || versionCopyScheme == null || rootMember == null) {
            return null;
        }
        return VersionCopyUtils.createBgmdEntityTree(null, rootMember, versionCopyScheme, recordMap, null);
    }

    private static VersionCopyTreeNode createBgmdEntityTree(VersionCopyTreeNode parent, Member member, DynamicObject versionCopyScheme, Map<Long, List<DynamicObject>> recordMap, DynamicObject record) {
        List<DynamicObject> dynamicObjects;
        if (recordMap != null && (dynamicObjects = recordMap.get(member.getId())) != null) {
            for (DynamicObject object : dynamicObjects) {
                if (object.getLong("ent_entity.entity") != member.getId().longValue() || record != null && record.getDate("executetime").compareTo(object.getDate("executetime")) >= 0) continue;
                record = object;
                break;
            }
        }
        VersionCopyTreeNode rootTree = new VersionCopyTreeNode(member.getId(), member.getName(), member.getNumber(), parent, null, versionCopyScheme, record);
        rootTree.setChildren(VersionCopyUtils.createChildren(rootTree, member, versionCopyScheme, recordMap, record));
        return rootTree;
    }

    private static List<VersionCopyTreeNode> createChildren(VersionCopyTreeNode parent, Member parentMember, DynamicObject versionCopyScheme, Map<Long, List<DynamicObject>> recordMap, DynamicObject record) {
        List<Member> children;
        if (CollectionUtils.isNotEmpty(parentMember.getChildren()) && CollectionUtils.isNotEmpty(children = parentMember.getChildren(true))) {
            ArrayList entityTrees = Lists.newArrayListWithExpectedSize((int)children.size());
            for (Member child : children) {
                if (child.isDisable()) continue;
                entityTrees.add(VersionCopyUtils.createBgmdEntityTree(parent, child, versionCopyScheme, recordMap, record));
            }
            return entityTrees;
        }
        return null;
    }

    public static Member getMemberTree(Member rootMember, Long modelId, Long businessmodel, Long viewId) {
        ArrayList<Member> list = new ArrayList<Member>(16);
        Set<Long> permMembIds = DimMembPermHelper.getPermMembIdsByGroup(SysDimensionEnum.Entity.getNumber(), modelId, businessmodel, viewId, null, DimMembPermType.WRITE);
        VersionCopyUtils.getHasPermMember(rootMember, list, modelId, businessmodel, ModelServiceHelper.isModelManager(modelId), permMembIds);
        if (CollectionUtils.isEmpty(list)) {
            if (ModelServiceHelper.isModelManager(modelId)) {
                return rootMember;
            }
            return null;
        }
        if (list.size() == 1 && ((Member)list.get(0)).equals(rootMember)) {
            return rootMember;
        }
        rootMember.setChildren(null);
        for (Member member1 : list) {
            Member parentMember = VersionCopyUtils.getParentMember(member1, list);
            if (parentMember == null && !rootMember.equals(member1)) {
                if (rootMember.getChildren() == null) {
                    rootMember.setChildren(new ArrayList<Member>(list.size()));
                }
                rootMember.getChildren().add(member1);
                continue;
            }
            if (parentMember == null) continue;
            if (parentMember.getChildren() == null) {
                parentMember.setChildren(new ArrayList<Member>(list.size()));
            }
            parentMember.getChildren().add(member1);
        }
        return rootMember;
    }

    private static Member getParentMember(Member member, List<Member> li) {
        String[] split = member.getLongNumber().split("!");
        String longNumber = member.getLongNumber();
        for (int i = 0; i < split.length; ++i) {
            int i2 = longNumber.lastIndexOf("!");
            if (i2 < 1) {
                return null;
            }
            longNumber = longNumber.substring(0, i2);
            for (Member member1 : li) {
                if (member.getLevel() < member1.getLevel() || !longNumber.equals(member1.getLongNumber())) continue;
                return member1;
            }
        }
        return null;
    }

    private static void getHasPermMember(Member member, List<Member> members, Long modelId, long businessmodel, boolean isManage, Set<Long> permIds) {
        boolean b = false;
        if (isManage) {
            b = true;
        } else if (CollectionUtils.isNotEmpty(permIds)) {
            b = permIds.contains(member.getId());
        }
        if (b) {
            members.add(member);
            if (!CollectionUtils.isEmpty(member.getChildren())) {
                member.getChildren().stream().forEach(x -> VersionCopyUtils.getHasPermMember(x, members, modelId, businessmodel, isManage, permIds));
            }
            member.setChildren(null);
        } else if (!CollectionUtils.isEmpty(member.getChildren())) {
            member.getChildren().stream().forEach(x -> VersionCopyUtils.getHasPermMember(x, members, modelId, businessmodel, isManage, permIds));
        }
    }

    public static Member getRootMember(Long modelId, long businessModelId, Long viewId) {
        Map<String, Long> viewsByBusModel;
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate(modelId);
        if ((viewId == 0L || viewId == null) && (viewsByBusModel = modelCache.getViewsByBusModel(businessModelId)) != null) {
            viewId = viewsByBusModel.getOrDefault(SysDimensionEnum.Entity.getNumber(), 0L);
        }
        Member member = modelCache.getRootMember(SysDimensionEnum.Entity.getNumber(), viewId);
        return member;
    }
}

