/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.log;

import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.utils.StringUtils;

public class Stats {
    private List<Object> list = new ArrayList<Object>();
    private String name;
    private StatItem lastStat;
    private long begin;
    private long end;

    public Stats() {
        this.begin = System.currentTimeMillis();
    }

    public Stats(String name) {
        this.name = name;
        this.begin = System.currentTimeMillis();
    }

    public void close() {
        this.end = System.currentTimeMillis();
    }

    public long cost() {
        if (this.end == 0L) {
            this.close();
        }
        return this.end - this.begin;
    }

    public StatItem createStatItem(String info) {
        StatItem item = new StatItem(info);
        this.list.add(item);
        return item;
    }

    public StatItem createLinearStatItem(String info) {
        StatItem item = new StatItem(info);
        this.list.add(item);
        if (this.lastStat != null) {
            this.lastStat.close();
        }
        this.lastStat = item;
        return item;
    }

    public void appendMessage(String message) {
        this.list.add(message);
    }

    public String toString(String tag) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty(tag)) {
            sb.append(tag).append(".\r\n");
        }
        long cost = this.cost();
        sb.append("Stats[").append(this.name).append("],total cost:").append(cost).append("ms.\r\n");
        for (Object item : this.list) {
            if (item instanceof String) {
                sb.append((String)item).append(".\r\n");
                continue;
            }
            if (!(item instanceof StatItem)) continue;
            ((StatItem)item).toString(sb);
            sb.append(".\r\n");
        }
        return sb.toString();
    }

    public static class StatItem {
        private long begin;
        private long end;
        private String info;

        public StatItem(String info) {
            this.info = info == null ? "" : info;
            this.begin = System.currentTimeMillis();
        }

        public void close() {
            this.end = System.currentTimeMillis();
        }

        public StatItem append(Object message) {
            this.info = this.info + "," + message.toString();
            return this;
        }

        public void appendAndClose(Object message) {
            this.append(message);
            this.close();
        }

        public void toString(StringBuilder sb) {
            if (this.end == 0L) {
                this.close();
            }
            sb.append("cost ").append(this.end - this.begin).append("ms.").append(this.info);
        }
    }
}

