/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.map;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ItemIndexMap<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Map<T, Integer> keyIndexMap;
    private Map<Integer, T> indexKeyMap = new HashMap<Integer, T>(16);

    public Map<T, Integer> getKeyIndexMap() {
        return this.keyIndexMap;
    }

    public void setKeyIndexMap(Map<T, Integer> keyIndexMap) {
        this.keyIndexMap = keyIndexMap;
    }

    public Integer getIndexByKey(T key) {
        this.initKeyIndexMap();
        return this.keyIndexMap.get(key);
    }

    public Integer getOrPutIndexByKey(T key) {
        Integer index = this.getIndexByKey(key);
        if (index == null) {
            index = this.putNewKey(key);
        }
        return index;
    }

    private Integer putNewKey(T key) {
        Integer index = this.keyIndexMap.size() + 1;
        this.keyIndexMap.put(key, index);
        this.indexKeyMap.put(index, key);
        return index;
    }

    public T getKeyByIndex(Integer index) {
        return this.indexKeyMap.get(index);
    }

    public void initKeyIndexMap() {
        if (this.keyIndexMap == null) {
            this.keyIndexMap = new HashMap<T, Integer>(16);
            this.indexKeyMap.forEach((index, key) -> this.keyIndexMap.put((T)key, (Integer)index));
        }
    }

    public void batPutKey(Iterable<T> keys) {
        keys.forEach(this::putNewKey);
    }
}

