/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.internal;

import java.util.regex.Pattern;
import kd.epm.eb.common.markdown.internal.BlockContent;
import kd.epm.eb.common.markdown.node.Block;
import kd.epm.eb.common.markdown.node.HtmlBlock;
import kd.epm.eb.common.markdown.node.Paragraph;
import kd.epm.eb.common.markdown.parser.SourceLine;
import kd.epm.eb.common.markdown.parser.block.AbstractBlockParser;
import kd.epm.eb.common.markdown.parser.block.AbstractBlockParserFactory;
import kd.epm.eb.common.markdown.parser.block.BlockContinue;
import kd.epm.eb.common.markdown.parser.block.BlockStart;
import kd.epm.eb.common.markdown.parser.block.MatchedBlockParser;
import kd.epm.eb.common.markdown.parser.block.ParserState;

public class HtmlBlockParser
extends AbstractBlockParser {
    private static final String TAGNAME = "[A-Za-z][A-Za-z0-9-]*";
    private static final String ATTRIBUTENAME = "[a-zA-Z_:][a-zA-Z0-9:._-]*";
    private static final String UNQUOTEDVALUE = "[^\"'=<>`\\x00-\\x20]+";
    private static final String SINGLEQUOTEDVALUE = "'[^']*'";
    private static final String DOUBLEQUOTEDVALUE = "\"[^\"]*\"";
    private static final String ATTRIBUTEVALUE = "(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\")";
    private static final String ATTRIBUTEVALUESPEC = "(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))";
    private static final String ATTRIBUTE = "(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)";
    private static final String OPENTAG = "<[A-Za-z][A-Za-z0-9-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>";
    private static final String CLOSETAG = "</[A-Za-z][A-Za-z0-9-]*\\s*[>]";
    private static final Pattern[][] BLOCK_PATTERNS = new Pattern[][]{{null, null}, {Pattern.compile("^<(?:script|pre|style|textarea)(?:\\s|>|$)", 2), Pattern.compile("</(?:script|pre|style|textarea)>", 2)}, {Pattern.compile("^<!--"), Pattern.compile("-->")}, {Pattern.compile("^<[?]"), Pattern.compile("\\?>")}, {Pattern.compile("^<![A-Z]"), Pattern.compile(">")}, {Pattern.compile("^<!\\[CDATA\\["), Pattern.compile("\\]\\]>")}, {Pattern.compile("^</?(?:address|article|aside|base|basefont|blockquote|body|caption|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption|figure|footer|form|frame|frameset|h1|h2|h3|h4|h5|h6|head|header|hr|html|iframe|legend|li|link|main|menu|menuitem|nav|noframes|ol|optgroup|option|p|param|search|section|summary|table|tbody|td|tfoot|th|thead|title|tr|track|ul)(?:\\s|[/]?[>]|$)", 2), null}, {Pattern.compile("^(?:<[A-Za-z][A-Za-z0-9-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>|</[A-Za-z][A-Za-z0-9-]*\\s*[>])\\s*$", 2), null}};
    private final HtmlBlock block = new HtmlBlock();
    private final Pattern closingPattern;
    private boolean finished = false;
    private BlockContent content = new BlockContent();

    private HtmlBlockParser(Pattern closingPattern) {
        this.closingPattern = closingPattern;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (this.finished) {
            return BlockContinue.none();
        }
        if (state.isBlank() && this.closingPattern == null) {
            return BlockContinue.none();
        }
        return BlockContinue.atIndex(state.getIndex());
    }

    @Override
    public void addLine(SourceLine line) {
        this.content.add(line.getContent());
        if (this.closingPattern != null && this.closingPattern.matcher(line.getContent()).find()) {
            this.finished = true;
        }
    }

    @Override
    public void closeBlock() {
        this.block.setLiteral(this.content.getString());
        this.content = null;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int nextNonSpace = state.getNextNonSpaceIndex();
            CharSequence line = state.getLine().getContent();
            if (state.getIndent() < 4 && line.charAt(nextNonSpace) == '<') {
                for (int blockType = 1; blockType <= 7; ++blockType) {
                    if (blockType == 7 && (matchedBlockParser.getMatchedBlockParser().getBlock() instanceof Paragraph || state.getActiveBlockParser().canHaveLazyContinuationLines())) continue;
                    Pattern opener = BLOCK_PATTERNS[blockType][0];
                    Pattern closer = BLOCK_PATTERNS[blockType][1];
                    boolean matches = opener.matcher(line.subSequence(nextNonSpace, line.length())).find();
                    if (!matches) continue;
                    return BlockStart.of(new HtmlBlockParser(closer)).atIndex(state.getIndex());
                }
            }
            return BlockStart.none();
        }
    }
}

