/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.internal;

import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.markdown.internal.util.Parsing;
import kd.epm.eb.common.markdown.node.Block;
import kd.epm.eb.common.markdown.node.IndentedCodeBlock;
import kd.epm.eb.common.markdown.node.Paragraph;
import kd.epm.eb.common.markdown.parser.SourceLine;
import kd.epm.eb.common.markdown.parser.block.AbstractBlockParser;
import kd.epm.eb.common.markdown.parser.block.AbstractBlockParserFactory;
import kd.epm.eb.common.markdown.parser.block.BlockContinue;
import kd.epm.eb.common.markdown.parser.block.BlockStart;
import kd.epm.eb.common.markdown.parser.block.MatchedBlockParser;
import kd.epm.eb.common.markdown.parser.block.ParserState;
import kd.epm.eb.common.markdown.text.Characters;

public class IndentedCodeBlockParser
extends AbstractBlockParser {
    private final IndentedCodeBlock block = new IndentedCodeBlock();
    private final List<CharSequence> lines = new ArrayList<CharSequence>();

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (state.getIndent() >= Parsing.CODE_BLOCK_INDENT) {
            return BlockContinue.atColumn(state.getColumn() + Parsing.CODE_BLOCK_INDENT);
        }
        if (state.isBlank()) {
            return BlockContinue.atIndex(state.getNextNonSpaceIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(SourceLine line) {
        this.lines.add(line.getContent());
    }

    @Override
    public void closeBlock() {
        int lastNonBlank;
        for (lastNonBlank = this.lines.size() - 1; lastNonBlank >= 0 && Characters.isBlank(this.lines.get(lastNonBlank)); --lastNonBlank) {
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < lastNonBlank + 1; ++i) {
            sb.append(this.lines.get(i));
            sb.append('\n');
        }
        String literal = sb.toString();
        this.block.setLiteral(literal);
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (state.getIndent() >= Parsing.CODE_BLOCK_INDENT && !state.isBlank() && !(state.getActiveBlockParser().getBlock() instanceof Paragraph)) {
                return BlockStart.of(new IndentedCodeBlockParser()).atColumn(state.getColumn() + Parsing.CODE_BLOCK_INDENT);
            }
            return BlockStart.none();
        }
    }
}

