/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.internal;

import kd.epm.eb.common.markdown.node.Block;
import kd.epm.eb.common.markdown.node.ListBlock;
import kd.epm.eb.common.markdown.node.ListItem;
import kd.epm.eb.common.markdown.node.Paragraph;
import kd.epm.eb.common.markdown.parser.block.AbstractBlockParser;
import kd.epm.eb.common.markdown.parser.block.BlockContinue;
import kd.epm.eb.common.markdown.parser.block.ParserState;

public class ListItemParser
extends AbstractBlockParser {
    private final ListItem block = new ListItem();
    private int contentIndent;
    private boolean hadBlankLine;

    public ListItemParser(int markerIndent, int contentIndent) {
        this.contentIndent = contentIndent;
        this.block.setMarkerIndent(markerIndent);
        this.block.setContentIndent(contentIndent);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block childBlock) {
        Block parent;
        if (this.hadBlankLine && (parent = this.block.getParent()) instanceof ListBlock) {
            ((ListBlock)parent).setTight(false);
        }
        return true;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (state.isBlank()) {
            if (this.block.getFirstChild() == null) {
                return BlockContinue.none();
            }
            Block activeBlock = state.getActiveBlockParser().getBlock();
            this.hadBlankLine = activeBlock instanceof Paragraph || activeBlock instanceof ListItem;
            return BlockContinue.atIndex(state.getNextNonSpaceIndex());
        }
        if (state.getIndent() >= this.contentIndent) {
            return BlockContinue.atColumn(state.getColumn() + this.contentIndent);
        }
        return BlockContinue.none();
    }
}

