/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.internal;

import java.util.List;
import kd.epm.eb.common.markdown.internal.LinkReferenceDefinitionParser;
import kd.epm.eb.common.markdown.node.Block;
import kd.epm.eb.common.markdown.node.LinkReferenceDefinition;
import kd.epm.eb.common.markdown.node.Paragraph;
import kd.epm.eb.common.markdown.node.SourceSpan;
import kd.epm.eb.common.markdown.parser.InlineParser;
import kd.epm.eb.common.markdown.parser.SourceLine;
import kd.epm.eb.common.markdown.parser.SourceLines;
import kd.epm.eb.common.markdown.parser.block.AbstractBlockParser;
import kd.epm.eb.common.markdown.parser.block.BlockContinue;
import kd.epm.eb.common.markdown.parser.block.ParserState;

public class ParagraphParser
extends AbstractBlockParser {
    private final Paragraph block = new Paragraph();
    private final LinkReferenceDefinitionParser linkReferenceDefinitionParser = new LinkReferenceDefinitionParser();

    @Override
    public boolean canHaveLazyContinuationLines() {
        return true;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (!state.isBlank()) {
            return BlockContinue.atIndex(state.getIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(SourceLine line) {
        this.linkReferenceDefinitionParser.parse(line);
    }

    @Override
    public void addSourceSpan(SourceSpan sourceSpan) {
        this.linkReferenceDefinitionParser.addSourceSpan(sourceSpan);
    }

    @Override
    public void closeBlock() {
        if (this.linkReferenceDefinitionParser.getParagraphLines().isEmpty()) {
            this.block.unlink();
        } else {
            this.block.setSourceSpans(this.linkReferenceDefinitionParser.getParagraphSourceSpans());
        }
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        SourceLines lines = this.linkReferenceDefinitionParser.getParagraphLines();
        if (!lines.isEmpty()) {
            inlineParser.parse(lines, this.block);
        }
    }

    public SourceLines getParagraphLines() {
        return this.linkReferenceDefinitionParser.getParagraphLines();
    }

    public List<LinkReferenceDefinition> getDefinitions() {
        return this.linkReferenceDefinitionParser.getDefinitions();
    }
}

