/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.internal.inline;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.regex.Pattern;
import kd.epm.eb.common.markdown.node.Link;
import kd.epm.eb.common.markdown.node.Text;
import kd.epm.eb.common.markdown.parser.SourceLines;
import kd.epm.eb.common.markdown.parser.beta.InlineContentParser;
import kd.epm.eb.common.markdown.parser.beta.InlineContentParserFactory;
import kd.epm.eb.common.markdown.parser.beta.InlineParserState;
import kd.epm.eb.common.markdown.parser.beta.ParsedInline;
import kd.epm.eb.common.markdown.parser.beta.Position;
import kd.epm.eb.common.markdown.parser.beta.Scanner;

public class AutolinkInlineParser
implements InlineContentParser {
    private static final Pattern URI = Pattern.compile("^[a-zA-Z][a-zA-Z0-9.+-]{1,31}:[^<>\u0000- ]*$");

    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        scanner.next();
        Position textStart = scanner.position();
        if (scanner.find('>') > 0) {
            SourceLines textSource = scanner.getSource(textStart, scanner.position());
            String content = textSource.getContent();
            scanner.next();
            String destination = null;
            if (URI.matcher(content).matches()) {
                destination = content;
            }
            if (destination != null) {
                Link link = new Link(destination, null);
                Text text = new Text(content);
                text.setSourceSpans(textSource.getSourceSpans());
                link.appendChild(text);
                return ParsedInline.of(link, scanner.position());
            }
        }
        return ParsedInline.none();
    }

    public static class Factory
    implements InlineContentParserFactory {
        @Override
        public Set<Character> getTriggerCharacters() {
            return Sets.newHashSet((Object[])new Character[]{Character.valueOf('<')});
        }

        @Override
        public InlineContentParser create() {
            return new AutolinkInlineParser();
        }
    }
}

