/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.internal.inline;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.regex.Pattern;
import kd.epm.eb.common.markdown.node.HardLineBreak;
import kd.epm.eb.common.markdown.node.Text;
import kd.epm.eb.common.markdown.parser.beta.InlineContentParser;
import kd.epm.eb.common.markdown.parser.beta.InlineContentParserFactory;
import kd.epm.eb.common.markdown.parser.beta.InlineParserState;
import kd.epm.eb.common.markdown.parser.beta.ParsedInline;
import kd.epm.eb.common.markdown.parser.beta.Scanner;

public class BackslashInlineParser
implements InlineContentParser {
    private static final Pattern ESCAPABLE = Pattern.compile("^[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]");

    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        scanner.next();
        char next = scanner.peek();
        if (next == '\n') {
            scanner.next();
            return ParsedInline.of(new HardLineBreak(), scanner.position());
        }
        if (ESCAPABLE.matcher(String.valueOf(next)).matches()) {
            scanner.next();
            return ParsedInline.of(new Text(String.valueOf(next)), scanner.position());
        }
        return ParsedInline.of(new Text("\\"), scanner.position());
    }

    public static class Factory
    implements InlineContentParserFactory {
        @Override
        public Set<Character> getTriggerCharacters() {
            return Sets.newHashSet((Object[])new Character[]{Character.valueOf('\\')});
        }

        @Override
        public InlineContentParser create() {
            return new BackslashInlineParser();
        }
    }
}

