/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.internal.inline;

import com.google.common.collect.Sets;
import java.util.Set;
import kd.epm.eb.common.markdown.node.Code;
import kd.epm.eb.common.markdown.node.Text;
import kd.epm.eb.common.markdown.parser.SourceLines;
import kd.epm.eb.common.markdown.parser.beta.InlineContentParser;
import kd.epm.eb.common.markdown.parser.beta.InlineContentParserFactory;
import kd.epm.eb.common.markdown.parser.beta.InlineParserState;
import kd.epm.eb.common.markdown.parser.beta.ParsedInline;
import kd.epm.eb.common.markdown.parser.beta.Position;
import kd.epm.eb.common.markdown.parser.beta.Scanner;
import kd.epm.eb.common.markdown.text.Characters;

public class BackticksInlineParser
implements InlineContentParser {
    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        Position start = scanner.position();
        int openingTicks = scanner.matchMultiple('`');
        Position afterOpening = scanner.position();
        while (scanner.find('`') > 0) {
            Position beforeClosing = scanner.position();
            int count = scanner.matchMultiple('`');
            if (count != openingTicks) continue;
            Code node = new Code();
            String content = scanner.getSource(afterOpening, beforeClosing).getContent();
            if ((content = content.replace('\n', ' ')).length() >= 3 && content.charAt(0) == ' ' && content.charAt(content.length() - 1) == ' ' && Characters.hasNonSpace(content)) {
                content = content.substring(1, content.length() - 1);
            }
            node.setLiteral(content);
            return ParsedInline.of(node, scanner.position());
        }
        SourceLines source = scanner.getSource(start, afterOpening);
        Text text = new Text(source.getContent());
        return ParsedInline.of(text, afterOpening);
    }

    public static class Factory
    implements InlineContentParserFactory {
        @Override
        public Set<Character> getTriggerCharacters() {
            return Sets.newHashSet((Object[])new Character[]{Character.valueOf('`')});
        }

        @Override
        public InlineContentParser create() {
            return new BackticksInlineParser();
        }
    }
}

