/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.internal.inline;

import kd.epm.eb.common.markdown.node.Emphasis;
import kd.epm.eb.common.markdown.node.Node;
import kd.epm.eb.common.markdown.node.Nodes;
import kd.epm.eb.common.markdown.node.SourceSpans;
import kd.epm.eb.common.markdown.node.StrongEmphasis;
import kd.epm.eb.common.markdown.node.Text;
import kd.epm.eb.common.markdown.parser.delimiter.DelimiterProcessor;
import kd.epm.eb.common.markdown.parser.delimiter.DelimiterRun;

public abstract class EmphasisDelimiterProcessor
implements DelimiterProcessor {
    private final char delimiterChar;

    protected EmphasisDelimiterProcessor(char delimiterChar) {
        this.delimiterChar = delimiterChar;
    }

    @Override
    public char getOpeningCharacter() {
        return this.delimiterChar;
    }

    @Override
    public char getClosingCharacter() {
        return this.delimiterChar;
    }

    @Override
    public int getMinLength() {
        return 1;
    }

    @Override
    public int process(DelimiterRun openingRun, DelimiterRun closingRun) {
        Node emphasis;
        int usedDelimiters;
        if ((openingRun.canClose() || closingRun.canOpen()) && closingRun.originalLength() % 3 != 0 && (openingRun.originalLength() + closingRun.originalLength()) % 3 == 0) {
            return 0;
        }
        if (openingRun.length() >= 2 && closingRun.length() >= 2) {
            usedDelimiters = 2;
            emphasis = new StrongEmphasis(String.valueOf(this.delimiterChar) + this.delimiterChar);
        } else {
            usedDelimiters = 1;
            emphasis = new Emphasis(String.valueOf(this.delimiterChar));
        }
        SourceSpans sourceSpans = SourceSpans.empty();
        sourceSpans.addAllFrom(openingRun.getOpeners(usedDelimiters));
        Text opener = openingRun.getOpener();
        for (Node node : Nodes.between(opener, closingRun.getCloser())) {
            emphasis.appendChild(node);
            sourceSpans.addAll(node.getSourceSpans());
        }
        sourceSpans.addAllFrom(closingRun.getClosers(usedDelimiters));
        emphasis.setSourceSpans(sourceSpans.getSourceSpans());
        opener.insertAfter(emphasis);
        return usedDelimiters;
    }
}

