/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.node;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.common.markdown.node.Node;
import kd.epm.eb.common.markdown.node.SourceSpan;

public class SourceSpans {
    private List<SourceSpan> sourceSpans;

    public static SourceSpans empty() {
        return new SourceSpans();
    }

    public List<SourceSpan> getSourceSpans() {
        return this.sourceSpans != null ? this.sourceSpans : Lists.newArrayList();
    }

    public void addAllFrom(Iterable<? extends Node> nodes) {
        for (Node node : nodes) {
            this.addAll(node.getSourceSpans());
        }
    }

    public void addAll(List<SourceSpan> other) {
        if (other.isEmpty()) {
            return;
        }
        if (this.sourceSpans == null) {
            this.sourceSpans = new ArrayList<SourceSpan>();
        }
        if (this.sourceSpans.isEmpty()) {
            this.sourceSpans.addAll(other);
        } else {
            int lastIndex = this.sourceSpans.size() - 1;
            SourceSpan a = this.sourceSpans.get(lastIndex);
            SourceSpan b = other.get(0);
            if (a.getLineIndex() == b.getLineIndex() && a.getColumnIndex() + a.getLength() == b.getColumnIndex()) {
                this.sourceSpans.set(lastIndex, SourceSpan.of(a.getLineIndex(), a.getColumnIndex(), a.getLength() + b.getLength()));
                this.sourceSpans.addAll(other.subList(1, other.size()));
            } else {
                this.sourceSpans.addAll(other);
            }
        }
    }
}

