/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.epm.eb.common.markdown.Extension;
import kd.epm.eb.common.markdown.internal.DocumentParser;
import kd.epm.eb.common.markdown.internal.InlineParserContextImpl;
import kd.epm.eb.common.markdown.internal.InlineParserImpl;
import kd.epm.eb.common.markdown.internal.LinkReferenceDefinitions;
import kd.epm.eb.common.markdown.node.Block;
import kd.epm.eb.common.markdown.node.Document;
import kd.epm.eb.common.markdown.node.Node;
import kd.epm.eb.common.markdown.parser.IncludeSourceSpans;
import kd.epm.eb.common.markdown.parser.InlineParserFactory;
import kd.epm.eb.common.markdown.parser.PostProcessor;
import kd.epm.eb.common.markdown.parser.beta.InlineContentParserFactory;
import kd.epm.eb.common.markdown.parser.block.BlockParserFactory;
import kd.epm.eb.common.markdown.parser.delimiter.DelimiterProcessor;

public class Parser {
    private final List<BlockParserFactory> blockParserFactories;
    private final List<InlineContentParserFactory> inlineContentParserFactories;
    private final List<DelimiterProcessor> delimiterProcessors;
    private final InlineParserFactory inlineParserFactory;
    private final List<PostProcessor> postProcessors;
    private final IncludeSourceSpans includeSourceSpans;

    private Parser(Builder builder) {
        this.blockParserFactories = DocumentParser.calculateBlockParserFactories(builder.blockParserFactories, builder.enabledBlockTypes);
        this.inlineParserFactory = builder.getInlineParserFactory();
        this.postProcessors = builder.postProcessors;
        this.inlineContentParserFactories = builder.inlineContentParserFactories;
        this.delimiterProcessors = builder.delimiterProcessors;
        this.includeSourceSpans = builder.includeSourceSpans;
        this.inlineParserFactory.create(new InlineParserContextImpl(this.inlineContentParserFactories, this.delimiterProcessors, new LinkReferenceDefinitions()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Node parse(String input) {
        Objects.requireNonNull(input, "input must not be null");
        DocumentParser documentParser = this.createDocumentParser();
        Document document = documentParser.parse(input);
        return this.postProcess(document);
    }

    public Node parseReader(Reader input) throws IOException {
        Objects.requireNonNull(input, "input must not be null");
        DocumentParser documentParser = this.createDocumentParser();
        Document document = documentParser.parse(input);
        return this.postProcess(document);
    }

    private DocumentParser createDocumentParser() {
        return new DocumentParser(this.blockParserFactories, this.inlineParserFactory, this.inlineContentParserFactories, this.delimiterProcessors, this.includeSourceSpans);
    }

    private Node postProcess(Node document) {
        for (PostProcessor postProcessor : this.postProcessors) {
            document = postProcessor.process(document);
        }
        return document;
    }

    public static interface ParserExtension
    extends Extension {
        public void extend(Builder var1);
    }

    public static class Builder {
        private final List<BlockParserFactory> blockParserFactories = new ArrayList<BlockParserFactory>();
        private final List<InlineContentParserFactory> inlineContentParserFactories = new ArrayList<InlineContentParserFactory>();
        private final List<DelimiterProcessor> delimiterProcessors = new ArrayList<DelimiterProcessor>();
        private final List<PostProcessor> postProcessors = new ArrayList<PostProcessor>();
        private Set<Class<? extends Block>> enabledBlockTypes = DocumentParser.getDefaultBlockParserTypes();
        private InlineParserFactory inlineParserFactory;
        private IncludeSourceSpans includeSourceSpans = IncludeSourceSpans.NONE;

        public Parser build() {
            return new Parser(this);
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            Objects.requireNonNull(extensions, "extensions must not be null");
            for (Extension extension : extensions) {
                if (!(extension instanceof ParserExtension)) continue;
                ParserExtension parserExtension = (ParserExtension)extension;
                parserExtension.extend(this);
            }
            return this;
        }

        public Builder enabledBlockTypes(Set<Class<? extends Block>> enabledBlockTypes) {
            Objects.requireNonNull(enabledBlockTypes, "enabledBlockTypes must not be null");
            DocumentParser.checkEnabledBlockTypes(enabledBlockTypes);
            this.enabledBlockTypes = enabledBlockTypes;
            return this;
        }

        public Builder includeSourceSpans(IncludeSourceSpans includeSourceSpans) {
            this.includeSourceSpans = includeSourceSpans;
            return this;
        }

        public Builder customBlockParserFactory(BlockParserFactory blockParserFactory) {
            Objects.requireNonNull(blockParserFactory, "blockParserFactory must not be null");
            this.blockParserFactories.add(blockParserFactory);
            return this;
        }

        public Builder customInlineContentParserFactory(InlineContentParserFactory inlineContentParserFactory) {
            Objects.requireNonNull(inlineContentParserFactory, "inlineContentParser must not be null");
            this.inlineContentParserFactories.add(inlineContentParserFactory);
            return this;
        }

        public Builder customDelimiterProcessor(DelimiterProcessor delimiterProcessor) {
            Objects.requireNonNull(delimiterProcessor, "delimiterProcessor must not be null");
            this.delimiterProcessors.add(delimiterProcessor);
            return this;
        }

        public Builder postProcessor(PostProcessor postProcessor) {
            Objects.requireNonNull(postProcessor, "postProcessor must not be null");
            this.postProcessors.add(postProcessor);
            return this;
        }

        public Builder inlineParserFactory(InlineParserFactory inlineParserFactory) {
            this.inlineParserFactory = inlineParserFactory;
            return this;
        }

        private InlineParserFactory getInlineParserFactory() {
            if (this.inlineParserFactory == null) {
                this.inlineParserFactory = InlineParserImpl::new;
            }
            return this.inlineParserFactory;
        }
    }
}

