/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.renderer.html;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.markdown.node.AbstractVisitor;
import kd.epm.eb.common.markdown.node.Block;
import kd.epm.eb.common.markdown.node.BlockQuote;
import kd.epm.eb.common.markdown.node.BulletList;
import kd.epm.eb.common.markdown.node.Code;
import kd.epm.eb.common.markdown.node.Document;
import kd.epm.eb.common.markdown.node.Emphasis;
import kd.epm.eb.common.markdown.node.FencedCodeBlock;
import kd.epm.eb.common.markdown.node.HardLineBreak;
import kd.epm.eb.common.markdown.node.Heading;
import kd.epm.eb.common.markdown.node.HtmlBlock;
import kd.epm.eb.common.markdown.node.HtmlInline;
import kd.epm.eb.common.markdown.node.Image;
import kd.epm.eb.common.markdown.node.IndentedCodeBlock;
import kd.epm.eb.common.markdown.node.Link;
import kd.epm.eb.common.markdown.node.ListBlock;
import kd.epm.eb.common.markdown.node.ListItem;
import kd.epm.eb.common.markdown.node.Node;
import kd.epm.eb.common.markdown.node.OrderedList;
import kd.epm.eb.common.markdown.node.Paragraph;
import kd.epm.eb.common.markdown.node.SoftLineBreak;
import kd.epm.eb.common.markdown.node.StrongEmphasis;
import kd.epm.eb.common.markdown.node.Text;
import kd.epm.eb.common.markdown.node.ThematicBreak;
import kd.epm.eb.common.markdown.renderer.NodeRenderer;
import kd.epm.eb.common.markdown.renderer.html.HtmlNodeRendererContext;
import kd.epm.eb.common.markdown.renderer.html.HtmlWriter;

public class CoreHtmlNodeRenderer
extends AbstractVisitor
implements NodeRenderer {
    protected final HtmlNodeRendererContext context;
    private final HtmlWriter html;

    public CoreHtmlNodeRenderer(HtmlNodeRendererContext context) {
        this.context = context;
        this.html = context.getWriter();
    }

    @Override
    public Set<Class<? extends Node>> getNodeTypes() {
        return Sets.newHashSet((Object[])new Class[]{Document.class, Heading.class, Paragraph.class, BlockQuote.class, BulletList.class, FencedCodeBlock.class, HtmlBlock.class, ThematicBreak.class, IndentedCodeBlock.class, Link.class, ListItem.class, OrderedList.class, Image.class, Emphasis.class, StrongEmphasis.class, Text.class, Code.class, HtmlInline.class, SoftLineBreak.class, HardLineBreak.class});
    }

    @Override
    public void render(Node node) {
        node.accept(this);
    }

    @Override
    public void visit(Document document) {
        this.visitChildren(document);
    }

    @Override
    public void visit(Heading heading) {
        String htag = "h" + heading.getLevel();
        this.html.line();
        this.html.tag(htag, this.getAttrs(heading, htag));
        this.visitChildren(heading);
        this.html.tag('/' + htag);
        this.html.line();
    }

    @Override
    public void visit(Paragraph paragraph) {
        boolean inTightList = this.isInTightList(paragraph);
        if (!inTightList) {
            this.html.line();
            this.html.tag("p", this.getAttrs(paragraph, "p"));
        }
        this.visitChildren(paragraph);
        if (!inTightList) {
            this.html.tag("/p");
            this.html.line();
        }
    }

    @Override
    public void visit(BlockQuote blockQuote) {
        this.html.line();
        this.html.tag("blockquote", this.getAttrs(blockQuote, "blockquote"));
        this.html.line();
        this.visitChildren(blockQuote);
        this.html.line();
        this.html.tag("/blockquote");
        this.html.line();
    }

    @Override
    public void visit(BulletList bulletList) {
        this.renderListBlock(bulletList, "ul", this.getAttrs(bulletList, "ul"));
    }

    @Override
    public void visit(FencedCodeBlock fencedCodeBlock) {
        String literal = fencedCodeBlock.getLiteral();
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        String info = fencedCodeBlock.getInfo();
        if (info != null && !info.isEmpty()) {
            int space = info.indexOf(" ");
            String language = space == -1 ? info : info.substring(0, space);
            attributes.put("class", "language-" + language);
        }
        this.renderCodeBlock(literal, fencedCodeBlock, attributes);
    }

    @Override
    public void visit(HtmlBlock htmlBlock) {
        this.html.line();
        if (this.context.shouldEscapeHtml()) {
            this.html.tag("p", this.getAttrs(htmlBlock, "p"));
            this.html.text(htmlBlock.getLiteral());
            this.html.tag("/p");
        } else {
            this.html.raw(htmlBlock.getLiteral());
        }
        this.html.line();
    }

    @Override
    public void visit(ThematicBreak thematicBreak) {
        this.html.line();
        this.html.tag("hr", this.getAttrs(thematicBreak, "hr"), true);
        this.html.line();
    }

    @Override
    public void visit(IndentedCodeBlock indentedCodeBlock) {
        this.renderCodeBlock(indentedCodeBlock.getLiteral(), indentedCodeBlock, Maps.newHashMap());
    }

    @Override
    public void visit(Link link) {
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        String url = link.getDestination();
        if (this.context.shouldSanitizeUrls()) {
            url = this.context.urlSanitizer().sanitizeLinkUrl(url);
            attrs.put("rel", "nofollow");
        }
        url = this.context.encodeUrl(url);
        attrs.put("href", url);
        if (link.getTitle() != null) {
            attrs.put("title", link.getTitle());
        }
        this.html.tag("a", this.getAttrs(link, "a", attrs));
        this.visitChildren(link);
        this.html.tag("/a");
    }

    @Override
    public void visit(ListItem listItem) {
        this.html.tag("li", this.getAttrs(listItem, "li"));
        this.visitChildren(listItem);
        this.html.tag("/li");
        this.html.line();
    }

    @Override
    public void visit(OrderedList orderedList) {
        int start = orderedList.getMarkerStartNumber() != null ? orderedList.getMarkerStartNumber() : 1;
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        if (start != 1) {
            attrs.put("start", String.valueOf(start));
        }
        this.renderListBlock(orderedList, "ol", this.getAttrs(orderedList, "ol", attrs));
    }

    @Override
    public void visit(Image image) {
        String url = image.getDestination();
        AltTextVisitor altTextVisitor = new AltTextVisitor();
        image.accept(altTextVisitor);
        String altText = altTextVisitor.getAltText();
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        if (this.context.shouldSanitizeUrls()) {
            url = this.context.urlSanitizer().sanitizeImageUrl(url);
        }
        attrs.put("src", this.context.encodeUrl(url));
        attrs.put("alt", altText);
        if (image.getTitle() != null) {
            attrs.put("title", image.getTitle());
        }
        this.html.tag("img", this.getAttrs(image, "img", attrs), true);
    }

    @Override
    public void visit(Emphasis emphasis) {
        this.html.tag("em", this.getAttrs(emphasis, "em"));
        this.visitChildren(emphasis);
        this.html.tag("/em");
    }

    @Override
    public void visit(StrongEmphasis strongEmphasis) {
        this.html.tag("strong", this.getAttrs(strongEmphasis, "strong"));
        this.visitChildren(strongEmphasis);
        this.html.tag("/strong");
    }

    @Override
    public void visit(Text text) {
        this.html.text(text.getLiteral());
    }

    @Override
    public void visit(Code code) {
        this.html.tag("code", this.getAttrs(code, "code"));
        this.html.text(code.getLiteral());
        this.html.tag("/code");
    }

    @Override
    public void visit(HtmlInline htmlInline) {
        if (this.context.shouldEscapeHtml()) {
            this.html.text(htmlInline.getLiteral());
        } else {
            this.html.raw(htmlInline.getLiteral());
        }
    }

    @Override
    public void visit(SoftLineBreak softLineBreak) {
        this.html.raw(this.context.getSoftbreak());
    }

    @Override
    public void visit(HardLineBreak hardLineBreak) {
        this.html.tag("br", this.getAttrs(hardLineBreak, "br"), true);
        this.html.line();
    }

    @Override
    protected void visitChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }

    private void renderCodeBlock(String literal, Node node, Map<String, String> attributes) {
        this.html.line();
        this.html.tag("pre", this.getAttrs(node, "pre"));
        this.html.tag("code", this.getAttrs(node, "code", attributes));
        this.html.text(literal);
        this.html.tag("/code");
        this.html.tag("/pre");
        this.html.line();
    }

    private void renderListBlock(ListBlock listBlock, String tagName, Map<String, String> attributes) {
        this.html.line();
        this.html.tag(tagName, attributes);
        this.html.line();
        this.visitChildren(listBlock);
        this.html.line();
        this.html.tag('/' + tagName);
        this.html.line();
    }

    private boolean isInTightList(Paragraph paragraph) {
        Node gramps;
        Block parent = paragraph.getParent();
        if (parent != null && (gramps = ((Node)parent).getParent()) instanceof ListBlock) {
            ListBlock list = (ListBlock)gramps;
            return list.isTight();
        }
        return false;
    }

    private Map<String, String> getAttrs(Node node, String tagName) {
        return this.getAttrs(node, tagName, Maps.newHashMap());
    }

    private Map<String, String> getAttrs(Node node, String tagName, Map<String, String> defaultAttributes) {
        return this.context.extendAttributes(node, tagName, defaultAttributes);
    }

    private static class AltTextVisitor
    extends AbstractVisitor {
        private final StringBuilder sb = new StringBuilder();

        private AltTextVisitor() {
        }

        String getAltText() {
            return this.sb.toString();
        }

        @Override
        public void visit(Text text) {
            this.sb.append(text.getLiteral());
        }

        @Override
        public void visit(SoftLineBreak softLineBreak) {
            this.sb.append('\n');
        }

        @Override
        public void visit(HardLineBreak hardLineBreak) {
            this.sb.append('\n');
        }
    }
}

