/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.renderer.html;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kd.epm.eb.common.markdown.renderer.html.UrlSanitizer;

public class DefaultUrlSanitizer
implements UrlSanitizer {
    private Set<String> protocols;

    public DefaultUrlSanitizer() {
        this(Lists.newArrayList((Object[])new String[]{"http", "https", "mailto"}));
    }

    public DefaultUrlSanitizer(Collection<String> protocols) {
        this.protocols = new HashSet<String>(protocols);
    }

    @Override
    public String sanitizeLinkUrl(String url) {
        url = this.stripHtmlSpaces(url);
        int n = url.length();
        block4: for (int i = 0; i < n; ++i) {
            switch (url.charAt(i)) {
                case '#': 
                case '/': 
                case '?': {
                    break block4;
                }
                case ':': {
                    String protocol = url.substring(0, i).toLowerCase();
                    if (this.protocols.contains(protocol)) break block4;
                    return "";
                }
                default: {
                    continue block4;
                }
            }
        }
        return url;
    }

    @Override
    public String sanitizeImageUrl(String url) {
        return this.sanitizeLinkUrl(url);
    }

    private String stripHtmlSpaces(String s) {
        int n;
        int i = 0;
        for (n = s.length(); n > i && this.isHtmlSpace(s.charAt(n - 1)); --n) {
        }
        while (i < n && this.isHtmlSpace(s.charAt(i))) {
            ++i;
        }
        if (i == 0 && n == s.length()) {
            return s;
        }
        return s.substring(i, n);
    }

    private boolean isHtmlSpace(int ch) {
        switch (ch) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

