/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.renderer.html;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.epm.eb.common.markdown.Extension;
import kd.epm.eb.common.markdown.internal.renderer.NodeRendererMap;
import kd.epm.eb.common.markdown.internal.util.Escaping;
import kd.epm.eb.common.markdown.node.Node;
import kd.epm.eb.common.markdown.renderer.NodeRenderer;
import kd.epm.eb.common.markdown.renderer.Renderer;
import kd.epm.eb.common.markdown.renderer.html.AttributeProvider;
import kd.epm.eb.common.markdown.renderer.html.AttributeProviderContext;
import kd.epm.eb.common.markdown.renderer.html.AttributeProviderFactory;
import kd.epm.eb.common.markdown.renderer.html.CoreHtmlNodeRenderer;
import kd.epm.eb.common.markdown.renderer.html.DefaultUrlSanitizer;
import kd.epm.eb.common.markdown.renderer.html.HtmlNodeRendererContext;
import kd.epm.eb.common.markdown.renderer.html.HtmlNodeRendererFactory;
import kd.epm.eb.common.markdown.renderer.html.HtmlWriter;
import kd.epm.eb.common.markdown.renderer.html.UrlSanitizer;

public class HtmlRenderer
implements Renderer {
    private final String softbreak;
    private final boolean escapeHtml;
    private final boolean sanitizeUrls;
    private final UrlSanitizer urlSanitizer;
    private final boolean percentEncodeUrls;
    private final List<AttributeProviderFactory> attributeProviderFactories;
    private final List<HtmlNodeRendererFactory> nodeRendererFactories;

    private HtmlRenderer(Builder builder) {
        this.softbreak = builder.softbreak;
        this.escapeHtml = builder.escapeHtml;
        this.sanitizeUrls = builder.sanitizeUrls;
        this.percentEncodeUrls = builder.percentEncodeUrls;
        this.urlSanitizer = builder.urlSanitizer;
        this.attributeProviderFactories = new ArrayList<AttributeProviderFactory>(builder.attributeProviderFactories);
        this.nodeRendererFactories = new ArrayList<HtmlNodeRendererFactory>(builder.nodeRendererFactories.size() + 1);
        this.nodeRendererFactories.addAll(builder.nodeRendererFactories);
        this.nodeRendererFactories.add(new HtmlNodeRendererFactory(){

            @Override
            public NodeRenderer create(HtmlNodeRendererContext context) {
                return new CoreHtmlNodeRenderer(context);
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void render(Node node, Appendable output) {
        Objects.requireNonNull(node, "node must not be null");
        RendererContext context = new RendererContext(new HtmlWriter(output));
        context.render(node);
    }

    @Override
    public String render(Node node) {
        Objects.requireNonNull(node, "node must not be null");
        StringBuilder sb = new StringBuilder();
        this.render(node, sb);
        return sb.toString();
    }

    private class RendererContext
    implements HtmlNodeRendererContext,
    AttributeProviderContext {
        private final HtmlWriter htmlWriter;
        private final List<AttributeProvider> attributeProviders;
        private final NodeRendererMap nodeRendererMap = new NodeRendererMap();

        private RendererContext(HtmlWriter htmlWriter) {
            this.htmlWriter = htmlWriter;
            this.attributeProviders = new ArrayList<AttributeProvider>(HtmlRenderer.this.attributeProviderFactories.size());
            for (AttributeProviderFactory attributeProviderFactory : HtmlRenderer.this.attributeProviderFactories) {
                this.attributeProviders.add(attributeProviderFactory.create(this));
            }
            for (int i = HtmlRenderer.this.nodeRendererFactories.size() - 1; i >= 0; --i) {
                HtmlNodeRendererFactory nodeRendererFactory = (HtmlNodeRendererFactory)HtmlRenderer.this.nodeRendererFactories.get(i);
                NodeRenderer nodeRenderer = nodeRendererFactory.create(this);
                this.nodeRendererMap.add(nodeRenderer);
            }
        }

        @Override
        public boolean shouldEscapeHtml() {
            return HtmlRenderer.this.escapeHtml;
        }

        @Override
        public boolean shouldSanitizeUrls() {
            return HtmlRenderer.this.sanitizeUrls;
        }

        @Override
        public UrlSanitizer urlSanitizer() {
            return HtmlRenderer.this.urlSanitizer;
        }

        @Override
        public String encodeUrl(String url) {
            if (HtmlRenderer.this.percentEncodeUrls) {
                return Escaping.percentEncodeUrl(url);
            }
            return url;
        }

        @Override
        public Map<String, String> extendAttributes(Node node, String tagName, Map<String, String> attributes) {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>(attributes);
            this.setCustomAttributes(node, tagName, attrs);
            return attrs;
        }

        @Override
        public HtmlWriter getWriter() {
            return this.htmlWriter;
        }

        @Override
        public String getSoftbreak() {
            return HtmlRenderer.this.softbreak;
        }

        @Override
        public void render(Node node) {
            this.nodeRendererMap.render(node);
        }

        private void setCustomAttributes(Node node, String tagName, Map<String, String> attrs) {
            for (AttributeProvider attributeProvider : this.attributeProviders) {
                attributeProvider.setAttributes(node, tagName, attrs);
            }
        }
    }

    public static interface HtmlRendererExtension
    extends Extension {
        public void extend(Builder var1);
    }

    public static class Builder {
        private String softbreak = "\n";
        private boolean escapeHtml = false;
        private boolean sanitizeUrls = false;
        private UrlSanitizer urlSanitizer = new DefaultUrlSanitizer();
        private boolean percentEncodeUrls = false;
        private List<AttributeProviderFactory> attributeProviderFactories = new ArrayList<AttributeProviderFactory>();
        private List<HtmlNodeRendererFactory> nodeRendererFactories = new ArrayList<HtmlNodeRendererFactory>();

        public HtmlRenderer build() {
            return new HtmlRenderer(this);
        }

        public Builder softbreak(String softbreak) {
            this.softbreak = softbreak;
            return this;
        }

        public Builder escapeHtml(boolean escapeHtml) {
            this.escapeHtml = escapeHtml;
            return this;
        }

        public Builder sanitizeUrls(boolean sanitizeUrls) {
            this.sanitizeUrls = sanitizeUrls;
            return this;
        }

        public Builder urlSanitizer(UrlSanitizer urlSanitizer) {
            this.urlSanitizer = urlSanitizer;
            return this;
        }

        public Builder percentEncodeUrls(boolean percentEncodeUrls) {
            this.percentEncodeUrls = percentEncodeUrls;
            return this;
        }

        public Builder attributeProviderFactory(AttributeProviderFactory attributeProviderFactory) {
            Objects.requireNonNull(attributeProviderFactory, "attributeProviderFactory must not be null");
            this.attributeProviderFactories.add(attributeProviderFactory);
            return this;
        }

        public Builder nodeRendererFactory(HtmlNodeRendererFactory nodeRendererFactory) {
            Objects.requireNonNull(nodeRendererFactory, "nodeRendererFactory must not be null");
            this.nodeRendererFactories.add(nodeRendererFactory);
            return this;
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            Objects.requireNonNull(extensions, "extensions must not be null");
            for (Extension extension : extensions) {
                if (!(extension instanceof HtmlRendererExtension)) continue;
                HtmlRendererExtension htmlRendererExtension = (HtmlRendererExtension)extension;
                htmlRendererExtension.extend(this);
            }
            return this;
        }
    }
}

