/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.renderer.markdown;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.epm.eb.common.markdown.node.AbstractVisitor;
import kd.epm.eb.common.markdown.node.BlockQuote;
import kd.epm.eb.common.markdown.node.BulletList;
import kd.epm.eb.common.markdown.node.Code;
import kd.epm.eb.common.markdown.node.Document;
import kd.epm.eb.common.markdown.node.Emphasis;
import kd.epm.eb.common.markdown.node.FencedCodeBlock;
import kd.epm.eb.common.markdown.node.HardLineBreak;
import kd.epm.eb.common.markdown.node.Heading;
import kd.epm.eb.common.markdown.node.HtmlBlock;
import kd.epm.eb.common.markdown.node.HtmlInline;
import kd.epm.eb.common.markdown.node.Image;
import kd.epm.eb.common.markdown.node.IndentedCodeBlock;
import kd.epm.eb.common.markdown.node.Link;
import kd.epm.eb.common.markdown.node.ListItem;
import kd.epm.eb.common.markdown.node.Node;
import kd.epm.eb.common.markdown.node.OrderedList;
import kd.epm.eb.common.markdown.node.Paragraph;
import kd.epm.eb.common.markdown.node.SoftLineBreak;
import kd.epm.eb.common.markdown.node.StrongEmphasis;
import kd.epm.eb.common.markdown.node.Text;
import kd.epm.eb.common.markdown.node.ThematicBreak;
import kd.epm.eb.common.markdown.renderer.NodeRenderer;
import kd.epm.eb.common.markdown.renderer.markdown.MarkdownNodeRendererContext;
import kd.epm.eb.common.markdown.renderer.markdown.MarkdownWriter;
import kd.epm.eb.common.markdown.text.AsciiMatcher;
import kd.epm.eb.common.markdown.text.CharMatcher;
import kd.epm.eb.common.markdown.text.Characters;

public class CoreMarkdownNodeRenderer
extends AbstractVisitor
implements NodeRenderer {
    private final AsciiMatcher textEscape;
    private final CharMatcher textEscapeInHeading;
    private final CharMatcher linkDestinationNeedsAngleBrackets = AsciiMatcher.builder().c(' ').c('(').c(')').c('<').c('>').c('\n').c('\\').build();
    private final CharMatcher linkDestinationEscapeInAngleBrackets = AsciiMatcher.builder().c('<').c('>').c('\n').c('\\').build();
    private final CharMatcher linkTitleEscapeInQuotes = AsciiMatcher.builder().c('\"').c('\n').c('\\').build();
    private final Pattern orderedListMarkerPattern = Pattern.compile("^([0-9]{1,9})([.)])");
    protected final MarkdownNodeRendererContext context;
    private final MarkdownWriter writer;
    private ListHolder listHolder;

    public CoreMarkdownNodeRenderer(MarkdownNodeRendererContext context) {
        this.context = context;
        this.writer = context.getWriter();
        this.textEscape = AsciiMatcher.builder().anyOf("[]<>`*_&\n\\").anyOf(context.getSpecialCharacters()).build();
        this.textEscapeInHeading = AsciiMatcher.builder(this.textEscape).anyOf("#").build();
    }

    @Override
    public Set<Class<? extends Node>> getNodeTypes() {
        return Sets.newHashSet((Object[])new Class[]{BlockQuote.class, BulletList.class, Code.class, Document.class, Emphasis.class, FencedCodeBlock.class, HardLineBreak.class, Heading.class, HtmlBlock.class, HtmlInline.class, Image.class, IndentedCodeBlock.class, Link.class, ListItem.class, OrderedList.class, Paragraph.class, SoftLineBreak.class, StrongEmphasis.class, Text.class, ThematicBreak.class});
    }

    @Override
    public void render(Node node) {
        node.accept(this);
    }

    @Override
    public void visit(Document document) {
        this.visitChildren(document);
        this.writer.line();
    }

    @Override
    public void visit(ThematicBreak thematicBreak) {
        this.writer.raw("___");
        this.writer.block();
    }

    @Override
    public void visit(Heading heading) {
        if (heading.getLevel() <= 2) {
            LineBreakVisitor lineBreakVisitor = new LineBreakVisitor();
            heading.accept(lineBreakVisitor);
            boolean isMultipleLines = lineBreakVisitor.hasLineBreak();
            if (isMultipleLines) {
                this.visitChildren(heading);
                this.writer.line();
                if (heading.getLevel() == 1) {
                    this.writer.raw("===");
                } else {
                    this.writer.raw("---");
                }
                this.writer.block();
                return;
            }
        }
        for (int i = 0; i < heading.getLevel(); ++i) {
            this.writer.raw('#');
        }
        this.writer.raw(' ');
        this.visitChildren(heading);
        this.writer.block();
    }

    @Override
    public void visit(IndentedCodeBlock indentedCodeBlock) {
        String literal = indentedCodeBlock.getLiteral();
        this.writer.writePrefix("    ");
        this.writer.pushPrefix("    ");
        List<String> lines = CoreMarkdownNodeRenderer.getLines(literal);
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            this.writer.raw(line);
            if (i == lines.size() - 1) continue;
            this.writer.line();
        }
        this.writer.popPrefix();
        this.writer.block();
    }

    @Override
    public void visit(FencedCodeBlock codeBlock) {
        int openingFenceLength;
        String fenceChar;
        String literal = codeBlock.getLiteral();
        String string = fenceChar = codeBlock.getFenceCharacter() != null ? codeBlock.getFenceCharacter() : "`";
        if (codeBlock.getOpeningFenceLength() != null) {
            openingFenceLength = codeBlock.getOpeningFenceLength();
        } else {
            int fenceCharsInLiteral = CoreMarkdownNodeRenderer.findMaxRunLength(fenceChar, literal);
            openingFenceLength = Math.max(fenceCharsInLiteral + 1, 3);
        }
        int closingFenceLength = codeBlock.getClosingFenceLength() != null ? codeBlock.getClosingFenceLength() : openingFenceLength;
        String openingFence = CoreMarkdownNodeRenderer.repeat(fenceChar, openingFenceLength);
        String closingFence = CoreMarkdownNodeRenderer.repeat(fenceChar, closingFenceLength);
        int indent = codeBlock.getFenceIndent();
        if (indent > 0) {
            String indentPrefix = CoreMarkdownNodeRenderer.repeat(" ", indent);
            this.writer.writePrefix(indentPrefix);
            this.writer.pushPrefix(indentPrefix);
        }
        this.writer.raw(openingFence);
        if (codeBlock.getInfo() != null) {
            this.writer.raw(codeBlock.getInfo());
        }
        this.writer.line();
        if (!literal.isEmpty()) {
            List<String> lines = CoreMarkdownNodeRenderer.getLines(literal);
            for (String line : lines) {
                this.writer.raw(line);
                this.writer.line();
            }
        }
        this.writer.raw(closingFence);
        if (indent > 0) {
            this.writer.popPrefix();
        }
        this.writer.block();
    }

    @Override
    public void visit(HtmlBlock htmlBlock) {
        List<String> lines = CoreMarkdownNodeRenderer.getLines(htmlBlock.getLiteral());
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            this.writer.raw(line);
            if (i == lines.size() - 1) continue;
            this.writer.line();
        }
        this.writer.block();
    }

    @Override
    public void visit(Paragraph paragraph) {
        this.visitChildren(paragraph);
        this.writer.block();
    }

    @Override
    public void visit(BlockQuote blockQuote) {
        this.writer.writePrefix("> ");
        this.writer.pushPrefix("> ");
        this.visitChildren(blockQuote);
        this.writer.popPrefix();
        this.writer.block();
    }

    @Override
    public void visit(BulletList bulletList) {
        this.writer.pushTight(bulletList.isTight());
        this.listHolder = new BulletListHolder(this.listHolder, bulletList);
        this.visitChildren(bulletList);
        this.listHolder = this.listHolder.parent;
        this.writer.popTight();
        this.writer.block();
    }

    @Override
    public void visit(OrderedList orderedList) {
        this.writer.pushTight(orderedList.isTight());
        this.listHolder = new OrderedListHolder(this.listHolder, orderedList);
        this.visitChildren(orderedList);
        this.listHolder = this.listHolder.parent;
        this.writer.popTight();
        this.writer.block();
    }

    @Override
    public void visit(ListItem listItem) {
        String marker;
        int markerIndent;
        int n = markerIndent = listItem.getMarkerIndent() != null ? listItem.getMarkerIndent() : 0;
        if (this.listHolder instanceof BulletListHolder) {
            BulletListHolder bulletListHolder = (BulletListHolder)this.listHolder;
            marker = CoreMarkdownNodeRenderer.repeat(" ", markerIndent) + bulletListHolder.marker;
        } else if (this.listHolder instanceof OrderedListHolder) {
            OrderedListHolder orderedListHolder = (OrderedListHolder)this.listHolder;
            marker = CoreMarkdownNodeRenderer.repeat(" ", markerIndent) + orderedListHolder.number + orderedListHolder.delimiter;
            orderedListHolder.number++;
        } else {
            throw new IllegalStateException("Unknown list holder type: " + this.listHolder);
        }
        Integer contentIndent = listItem.getContentIndent();
        String spaces = contentIndent != null ? CoreMarkdownNodeRenderer.repeat(" ", contentIndent - marker.length()) : " ";
        this.writer.writePrefix(marker);
        this.writer.writePrefix(spaces);
        this.writer.pushPrefix(CoreMarkdownNodeRenderer.repeat(" ", marker.length() + spaces.length()));
        if (listItem.getFirstChild() == null) {
            this.writer.block();
        } else {
            this.visitChildren(listItem);
        }
        this.writer.popPrefix();
    }

    @Override
    public void visit(Code code) {
        boolean addSpace;
        String literal = code.getLiteral();
        int backticks = CoreMarkdownNodeRenderer.findMaxRunLength("`", literal);
        for (int i = 0; i < backticks + 1; ++i) {
            this.writer.raw('`');
        }
        boolean bl = addSpace = literal.startsWith("`") || literal.endsWith("`") || literal.startsWith(" ") && literal.endsWith(" ") && Characters.hasNonSpace(literal);
        if (addSpace) {
            this.writer.raw(' ');
        }
        this.writer.raw(literal);
        if (addSpace) {
            this.writer.raw(' ');
        }
        for (int i = 0; i < backticks + 1; ++i) {
            this.writer.raw('`');
        }
    }

    @Override
    public void visit(Emphasis emphasis) {
        String delimiter = emphasis.getOpeningDelimiter();
        if (delimiter == null) {
            delimiter = this.writer.getLastChar() == '*' ? "_" : "*";
        }
        this.writer.raw(delimiter);
        super.visit(emphasis);
        this.writer.raw(delimiter);
    }

    @Override
    public void visit(StrongEmphasis strongEmphasis) {
        this.writer.raw("**");
        super.visit(strongEmphasis);
        this.writer.raw("**");
    }

    @Override
    public void visit(Link link) {
        this.writeLinkLike(link.getTitle(), link.getDestination(), link, "[");
    }

    @Override
    public void visit(Image image) {
        this.writeLinkLike(image.getTitle(), image.getDestination(), image, "![");
    }

    @Override
    public void visit(HtmlInline htmlInline) {
        this.writer.raw(htmlInline.getLiteral());
    }

    @Override
    public void visit(HardLineBreak hardLineBreak) {
        this.writer.raw("  ");
        this.writer.line();
    }

    @Override
    public void visit(SoftLineBreak softLineBreak) {
        this.writer.line();
    }

    @Override
    public void visit(Text text) {
        CharMatcher escape;
        String literal = text.getLiteral();
        if (this.writer.isAtLineStart() && !literal.isEmpty()) {
            char c = literal.charAt(0);
            switch (c) {
                case '-': {
                    this.writer.raw("\\-");
                    literal = literal.substring(1);
                    break;
                }
                case '#': {
                    this.writer.raw("\\#");
                    literal = literal.substring(1);
                    break;
                }
                case '=': {
                    this.writer.raw("\\=");
                    literal = literal.substring(1);
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    Matcher m = this.orderedListMarkerPattern.matcher(literal);
                    if (!m.find()) break;
                    this.writer.raw(m.group(1));
                    this.writer.raw("\\" + m.group(2));
                    literal = literal.substring(m.end());
                    break;
                }
                case '\t': {
                    this.writer.raw("&#9;");
                    literal = literal.substring(1);
                    break;
                }
                case ' ': {
                    this.writer.raw("&#32;");
                    literal = literal.substring(1);
                }
            }
        }
        CharMatcher charMatcher = escape = text.getParent() instanceof Heading ? this.textEscapeInHeading : this.textEscape;
        if (literal.endsWith("!") && text.getNext() instanceof Link) {
            this.writer.text(literal.substring(0, literal.length() - 1), escape);
            this.writer.raw("\\!");
        } else {
            this.writer.text(literal, escape);
        }
    }

    @Override
    protected void visitChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }

    private static int findMaxRunLength(String needle, String s) {
        int maxRunLength = 0;
        int pos = 0;
        while (pos < s.length()) {
            if ((pos = s.indexOf(needle, pos)) == -1) {
                return maxRunLength;
            }
            int runLength = 0;
            do {
                ++runLength;
            } while (s.startsWith(needle, pos += needle.length()));
            maxRunLength = Math.max(runLength, maxRunLength);
        }
        return maxRunLength;
    }

    private static boolean contains(String s, CharMatcher charMatcher) {
        for (int i = 0; i < s.length(); ++i) {
            if (!charMatcher.matches(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static String repeat(String s, int count) {
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    private static List<String> getLines(String literal) {
        Object[] parts = literal.split("\n", -1);
        if (parts[parts.length - 1].isEmpty()) {
            return Lists.newArrayList((Object[])parts).subList(0, parts.length - 1);
        }
        return Lists.newArrayList((Object[])parts);
    }

    private void writeLinkLike(String title, String destination, Node node, String opener) {
        this.writer.raw(opener);
        this.visitChildren(node);
        this.writer.raw(']');
        this.writer.raw('(');
        if (CoreMarkdownNodeRenderer.contains(destination, this.linkDestinationNeedsAngleBrackets)) {
            this.writer.raw('<');
            this.writer.text(destination, this.linkDestinationEscapeInAngleBrackets);
            this.writer.raw('>');
        } else {
            this.writer.raw(destination);
        }
        if (title != null) {
            this.writer.raw(' ');
            this.writer.raw('\"');
            this.writer.text(title, this.linkTitleEscapeInQuotes);
            this.writer.raw('\"');
        }
        this.writer.raw(')');
    }

    private static class LineBreakVisitor
    extends AbstractVisitor {
        private boolean lineBreak = false;

        private LineBreakVisitor() {
        }

        public boolean hasLineBreak() {
            return this.lineBreak;
        }

        @Override
        public void visit(SoftLineBreak softLineBreak) {
            super.visit(softLineBreak);
            this.lineBreak = true;
        }

        @Override
        public void visit(HardLineBreak hardLineBreak) {
            super.visit(hardLineBreak);
            this.lineBreak = true;
        }
    }

    private static class OrderedListHolder
    extends ListHolder {
        final String delimiter;
        private int number;

        protected OrderedListHolder(ListHolder parent, OrderedList orderedList) {
            super(parent);
            this.delimiter = orderedList.getMarkerDelimiter() != null ? orderedList.getMarkerDelimiter() : ".";
            this.number = orderedList.getMarkerStartNumber() != null ? orderedList.getMarkerStartNumber() : 1;
        }
    }

    private static class BulletListHolder
    extends ListHolder {
        final String marker;

        public BulletListHolder(ListHolder parent, BulletList bulletList) {
            super(parent);
            this.marker = bulletList.getMarker() != null ? bulletList.getMarker() : "-";
        }
    }

    private static class ListHolder {
        final ListHolder parent;

        protected ListHolder(ListHolder parent) {
            this.parent = parent;
        }
    }
}

