/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.renderer.markdown;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.epm.eb.common.markdown.Extension;
import kd.epm.eb.common.markdown.internal.renderer.NodeRendererMap;
import kd.epm.eb.common.markdown.node.Node;
import kd.epm.eb.common.markdown.renderer.NodeRenderer;
import kd.epm.eb.common.markdown.renderer.Renderer;
import kd.epm.eb.common.markdown.renderer.markdown.CoreMarkdownNodeRenderer;
import kd.epm.eb.common.markdown.renderer.markdown.MarkdownNodeRendererContext;
import kd.epm.eb.common.markdown.renderer.markdown.MarkdownNodeRendererFactory;
import kd.epm.eb.common.markdown.renderer.markdown.MarkdownWriter;

public class MarkdownRenderer
implements Renderer {
    private final List<MarkdownNodeRendererFactory> nodeRendererFactories;

    private MarkdownRenderer(Builder builder) {
        this.nodeRendererFactories = new ArrayList<MarkdownNodeRendererFactory>(builder.nodeRendererFactories.size() + 1);
        this.nodeRendererFactories.addAll(builder.nodeRendererFactories);
        this.nodeRendererFactories.add(new MarkdownNodeRendererFactory(){

            @Override
            public NodeRenderer create(MarkdownNodeRendererContext context) {
                return new CoreMarkdownNodeRenderer(context);
            }

            @Override
            public Set<Character> getSpecialCharacters() {
                return Sets.newHashSet();
            }
        });
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void render(Node node, Appendable output) {
        RendererContext context = new RendererContext(new MarkdownWriter(output));
        context.render(node);
    }

    @Override
    public String render(Node node) {
        StringBuilder sb = new StringBuilder();
        this.render(node, sb);
        return sb.toString();
    }

    private class RendererContext
    implements MarkdownNodeRendererContext {
        private final MarkdownWriter writer;
        private final NodeRendererMap nodeRendererMap = new NodeRendererMap();
        private final Set<Character> additionalTextEscapes;

        private RendererContext(MarkdownWriter writer) {
            this.writer = writer;
            HashSet<Character> escapes = new HashSet<Character>();
            for (MarkdownNodeRendererFactory factory : MarkdownRenderer.this.nodeRendererFactories) {
                escapes.addAll(factory.getSpecialCharacters());
            }
            this.additionalTextEscapes = Collections.unmodifiableSet(escapes);
            for (int i = MarkdownRenderer.this.nodeRendererFactories.size() - 1; i >= 0; --i) {
                MarkdownNodeRendererFactory nodeRendererFactory = (MarkdownNodeRendererFactory)MarkdownRenderer.this.nodeRendererFactories.get(i);
                NodeRenderer nodeRenderer = nodeRendererFactory.create(this);
                this.nodeRendererMap.add(nodeRenderer);
            }
        }

        @Override
        public MarkdownWriter getWriter() {
            return this.writer;
        }

        @Override
        public void render(Node node) {
            this.nodeRendererMap.render(node);
        }

        @Override
        public Set<Character> getSpecialCharacters() {
            return this.additionalTextEscapes;
        }
    }

    public static interface MarkdownRendererExtension
    extends Extension {
        public void extend(Builder var1);
    }

    public static class Builder {
        private final List<MarkdownNodeRendererFactory> nodeRendererFactories = new ArrayList<MarkdownNodeRendererFactory>();

        public MarkdownRenderer build() {
            return new MarkdownRenderer(this);
        }

        public Builder nodeRendererFactory(MarkdownNodeRendererFactory nodeRendererFactory) {
            this.nodeRendererFactories.add(nodeRendererFactory);
            return this;
        }

        public Builder extensions(Iterable<? extends Extension> extensions) {
            for (Extension extension : extensions) {
                if (!(extension instanceof MarkdownRendererExtension)) continue;
                MarkdownRendererExtension markdownRendererExtension = (MarkdownRendererExtension)extension;
                markdownRendererExtension.extend(this);
            }
            return this;
        }
    }
}

