/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.markdown.renderer.text;

import com.google.common.collect.Sets;
import java.util.Set;
import kd.epm.eb.common.markdown.internal.renderer.text.BulletListHolder;
import kd.epm.eb.common.markdown.internal.renderer.text.ListHolder;
import kd.epm.eb.common.markdown.internal.renderer.text.OrderedListHolder;
import kd.epm.eb.common.markdown.node.AbstractVisitor;
import kd.epm.eb.common.markdown.node.BlockQuote;
import kd.epm.eb.common.markdown.node.BulletList;
import kd.epm.eb.common.markdown.node.Code;
import kd.epm.eb.common.markdown.node.Document;
import kd.epm.eb.common.markdown.node.Emphasis;
import kd.epm.eb.common.markdown.node.FencedCodeBlock;
import kd.epm.eb.common.markdown.node.HardLineBreak;
import kd.epm.eb.common.markdown.node.Heading;
import kd.epm.eb.common.markdown.node.HtmlBlock;
import kd.epm.eb.common.markdown.node.HtmlInline;
import kd.epm.eb.common.markdown.node.Image;
import kd.epm.eb.common.markdown.node.IndentedCodeBlock;
import kd.epm.eb.common.markdown.node.Link;
import kd.epm.eb.common.markdown.node.ListItem;
import kd.epm.eb.common.markdown.node.Node;
import kd.epm.eb.common.markdown.node.OrderedList;
import kd.epm.eb.common.markdown.node.Paragraph;
import kd.epm.eb.common.markdown.node.SoftLineBreak;
import kd.epm.eb.common.markdown.node.StrongEmphasis;
import kd.epm.eb.common.markdown.node.Text;
import kd.epm.eb.common.markdown.node.ThematicBreak;
import kd.epm.eb.common.markdown.renderer.NodeRenderer;
import kd.epm.eb.common.markdown.renderer.text.TextContentNodeRendererContext;
import kd.epm.eb.common.markdown.renderer.text.TextContentWriter;

public class CoreTextContentNodeRenderer
extends AbstractVisitor
implements NodeRenderer {
    protected final TextContentNodeRendererContext context;
    private final TextContentWriter textContent;
    private ListHolder listHolder;

    public CoreTextContentNodeRenderer(TextContentNodeRendererContext context) {
        this.context = context;
        this.textContent = context.getWriter();
    }

    @Override
    public Set<Class<? extends Node>> getNodeTypes() {
        return Sets.newHashSet((Object[])new Class[]{Document.class, Heading.class, Paragraph.class, BlockQuote.class, BulletList.class, FencedCodeBlock.class, HtmlBlock.class, ThematicBreak.class, IndentedCodeBlock.class, Link.class, ListItem.class, OrderedList.class, Image.class, Emphasis.class, StrongEmphasis.class, Text.class, Code.class, HtmlInline.class, SoftLineBreak.class, HardLineBreak.class});
    }

    @Override
    public void render(Node node) {
        node.accept(this);
    }

    @Override
    public void visit(Document document) {
        this.visitChildren(document);
    }

    @Override
    public void visit(BlockQuote blockQuote) {
        this.textContent.write('\u00ab');
        this.visitChildren(blockQuote);
        this.textContent.write('\u00bb');
        this.writeEndOfLineIfNeeded(blockQuote, null);
    }

    @Override
    public void visit(BulletList bulletList) {
        if (this.listHolder != null) {
            this.writeEndOfLine();
        }
        this.listHolder = new BulletListHolder(this.listHolder, bulletList);
        this.visitChildren(bulletList);
        this.writeEndOfLineIfNeeded(bulletList, null);
        this.listHolder = this.listHolder.getParent() != null ? this.listHolder.getParent() : null;
    }

    @Override
    public void visit(Code code) {
        this.textContent.write('\"');
        this.textContent.write(code.getLiteral());
        this.textContent.write('\"');
    }

    @Override
    public void visit(FencedCodeBlock fencedCodeBlock) {
        if (this.context.stripNewlines()) {
            this.textContent.writeStripped(fencedCodeBlock.getLiteral());
            this.writeEndOfLineIfNeeded(fencedCodeBlock, null);
        } else {
            this.textContent.write(fencedCodeBlock.getLiteral());
        }
    }

    @Override
    public void visit(HardLineBreak hardLineBreak) {
        this.writeEndOfLineIfNeeded(hardLineBreak, null);
    }

    @Override
    public void visit(Heading heading) {
        this.visitChildren(heading);
        this.writeEndOfLineIfNeeded(heading, Character.valueOf(':'));
    }

    @Override
    public void visit(ThematicBreak thematicBreak) {
        if (!this.context.stripNewlines()) {
            this.textContent.write("***");
        }
        this.writeEndOfLineIfNeeded(thematicBreak, null);
    }

    @Override
    public void visit(HtmlInline htmlInline) {
        this.writeText(htmlInline.getLiteral());
    }

    @Override
    public void visit(HtmlBlock htmlBlock) {
        this.writeText(htmlBlock.getLiteral());
    }

    @Override
    public void visit(Image image) {
        this.writeLink(image, image.getTitle(), image.getDestination());
    }

    @Override
    public void visit(IndentedCodeBlock indentedCodeBlock) {
        if (this.context.stripNewlines()) {
            this.textContent.writeStripped(indentedCodeBlock.getLiteral());
            this.writeEndOfLineIfNeeded(indentedCodeBlock, null);
        } else {
            this.textContent.write(indentedCodeBlock.getLiteral());
        }
    }

    @Override
    public void visit(Link link) {
        this.writeLink(link, link.getTitle(), link.getDestination());
    }

    @Override
    public void visit(ListItem listItem) {
        if (this.listHolder != null && this.listHolder instanceof OrderedListHolder) {
            OrderedListHolder orderedListHolder = (OrderedListHolder)this.listHolder;
            String indent = this.context.stripNewlines() ? "" : orderedListHolder.getIndent();
            this.textContent.write(indent + orderedListHolder.getCounter() + orderedListHolder.getDelimiter() + " ");
            this.visitChildren(listItem);
            this.writeEndOfLineIfNeeded(listItem, null);
            orderedListHolder.increaseCounter();
        } else if (this.listHolder != null && this.listHolder instanceof BulletListHolder) {
            BulletListHolder bulletListHolder = (BulletListHolder)this.listHolder;
            if (!this.context.stripNewlines()) {
                this.textContent.write(bulletListHolder.getIndent() + bulletListHolder.getMarker() + " ");
            }
            this.visitChildren(listItem);
            this.writeEndOfLineIfNeeded(listItem, null);
        }
    }

    @Override
    public void visit(OrderedList orderedList) {
        if (this.listHolder != null) {
            this.writeEndOfLine();
        }
        this.listHolder = new OrderedListHolder(this.listHolder, orderedList);
        this.visitChildren(orderedList);
        this.writeEndOfLineIfNeeded(orderedList, null);
        this.listHolder = this.listHolder.getParent() != null ? this.listHolder.getParent() : null;
    }

    @Override
    public void visit(Paragraph paragraph) {
        this.visitChildren(paragraph);
        if (paragraph.getParent() == null || paragraph.getParent() instanceof Document) {
            this.writeEndOfLineIfNeeded(paragraph, null);
        }
    }

    @Override
    public void visit(SoftLineBreak softLineBreak) {
        this.writeEndOfLineIfNeeded(softLineBreak, null);
    }

    @Override
    public void visit(Text text) {
        this.writeText(text.getLiteral());
    }

    @Override
    protected void visitChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }

    private void writeText(String text) {
        if (this.context.stripNewlines()) {
            this.textContent.writeStripped(text);
        } else {
            this.textContent.write(text);
        }
    }

    private void writeLink(Node node, String title, String destination) {
        boolean hasDestination;
        boolean hasChild = node.getFirstChild() != null;
        boolean hasTitle = title != null && !title.equals(destination);
        boolean bl = hasDestination = destination != null && !destination.equals("");
        if (hasChild) {
            this.textContent.write('\"');
            this.visitChildren(node);
            this.textContent.write('\"');
            if (hasTitle || hasDestination) {
                this.textContent.whitespace();
                this.textContent.write('(');
            }
        }
        if (hasTitle) {
            this.textContent.write(title);
            if (hasDestination) {
                this.textContent.colon();
                this.textContent.whitespace();
            }
        }
        if (hasDestination) {
            this.textContent.write(destination);
        }
        if (hasChild && (hasTitle || hasDestination)) {
            this.textContent.write(')');
        }
    }

    private void writeEndOfLineIfNeeded(Node node, Character c) {
        if (this.context.stripNewlines()) {
            if (c != null) {
                this.textContent.write(c.charValue());
            }
            if (node.getNext() != null) {
                this.textContent.whitespace();
            }
        } else if (node.getNext() != null) {
            this.textContent.line();
        }
    }

    private void writeEndOfLine() {
        if (this.context.stripNewlines()) {
            this.textContent.whitespace();
        } else {
            this.textContent.line();
        }
    }
}

