/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.member.f7;

import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.enums.ShowTypeEnum;
import kd.epm.eb.common.member.f7.F7Constant;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.compress.NewGzipUtils;
import org.jetbrains.annotations.NotNull;

public class F7TreeUtils {
    private static final Log log = LogFactory.getLog(F7TreeUtils.class);
    public static final TreeCacheV2 TREECACHE = new TreeCacheV2();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheTreeNodeData(@NotNull IPageCache pageCache, @NotNull String cacheKey, TreeNode root) {
        LogStats stats = new LogStats("budget-tree-log : ");
        try {
            F7TreeUtils.cacheTreeNodeData(pageCache, cacheKey, root, stats);
        }
        finally {
            log.info(stats.toString());
        }
    }

    public static void cacheTreeNodeData(@NotNull IPageCache pageCache, @NotNull String cacheKey, TreeNode root, @NotNull LogStats stats) {
        if (root != null) {
            stats.addInfo("begin-cache-node");
            String _cacheTreeNode = SerializationUtils.toJsonString((Object)root);
            stats.addInfo("before-zip-size=" + _cacheTreeNode.length());
            try {
                _cacheTreeNode = SerializationUtils.serializeToBase64((Object)GZIPUtils.compress(_cacheTreeNode));
            }
            catch (Exception ex) {
                log.error("gzip-compress-error:", (Throwable)ex);
            }
            stats.add("end-zip");
            pageCache.put(cacheKey, _cacheTreeNode);
            stats.add("end-cache-node. cacheSize=" + _cacheTreeNode.length());
        } else {
            pageCache.remove(cacheKey);
            stats.add("end-remove-cache-node.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheData(@NotNull IPageCache pageCache, @NotNull String cacheKey, Object object) {
        LogStats stats = new LogStats("budget-tree-log : ");
        try {
            F7TreeUtils.cacheData(pageCache, cacheKey, object, stats);
        }
        finally {
            log.info(stats.toString());
        }
    }

    public static void cacheData(@NotNull IPageCache pageCache, @NotNull String cacheKey, Object object, @NotNull LogStats stats) {
        if (object != null) {
            stats.addInfo("begin-cache-node");
            String _cacheTreeNode = F7TreeUtils.getZipData(object, stats);
            pageCache.put(cacheKey, _cacheTreeNode);
            if (_cacheTreeNode != null) {
                stats.add("end-cache-node. cacheSize=" + _cacheTreeNode.length());
            }
        } else {
            pageCache.remove(cacheKey);
            stats.add("end-remove-cache-node.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheData(@NotNull IPageCache pageCache, @NotNull String cacheKey, String cacheData) {
        LogStats stats = new LogStats("budget-tree-log : ");
        try {
            F7TreeUtils.cacheData(pageCache, cacheKey, cacheData, stats);
        }
        finally {
            log.info(stats.toString());
        }
    }

    public static void cacheData(@NotNull IPageCache pageCache, @NotNull String cacheKey, String cacheData, @NotNull LogStats stats) {
        if (StringUtils.isNotEmpty(cacheData)) {
            stats.addInfo("begin-cache-data");
            stats.addInfo("before-zip-size=" + cacheData.length());
            try {
                cacheData = SerializationUtils.serializeToBase64((Object)GZIPUtils.compress(cacheData));
            }
            catch (Exception ex) {
                log.error("gzip-compress-error:", (Throwable)ex);
            }
            stats.add("end-zip");
            pageCache.put(cacheKey, cacheData);
            stats.add("end-cache-data. cacheSize=" + cacheData.length());
        } else {
            pageCache.remove(cacheKey);
            stats.add("end-remove-cache-data.");
        }
    }

    public static TreeNode getCacheTreeNodeData(@NotNull IPageCache pageCache, @NotNull String cacheKey) {
        LogStats stats = new LogStats("budget-tree-log : ");
        stats.addInfo("begin-parse-node");
        TreeNode node = F7TreeUtils.getCacheTreeNodeData(pageCache.get(cacheKey), stats);
        stats.add("end-parse-node");
        log.info(stats.toString());
        return node;
    }

    public static TreeNode getCacheTreeNodeData(@NotNull IPageCache pageCache, @NotNull String cacheKey, @NotNull LogStats stats) {
        stats.addInfo("begin-parse-node");
        TreeNode node = F7TreeUtils.getCacheTreeNodeData(pageCache.get(cacheKey), stats);
        stats.add("end-parse-node");
        return node;
    }

    public static TreeNode getCacheTreeNodeData(String cacheTreeData) {
        LogStats stats = new LogStats("budget-tree-log : ");
        stats.addInfo("begin-parse-node");
        TreeNode node = F7TreeUtils.getCacheTreeNodeData(cacheTreeData, stats);
        stats.add("end-parse-node");
        log.info(stats.toString());
        return node;
    }

    private static TreeNode getCacheTreeNodeData(String cacheTreeData, @NotNull LogStats stats) {
        if (StringUtils.isEmpty(cacheTreeData)) {
            return null;
        }
        TreeNode node = null;
        String _cacheTreeNode = cacheTreeData;
        try {
            _cacheTreeNode = GZIPUtils.uncompressToString((byte[])SerializationUtils.deSerializeFromBase64((String)_cacheTreeNode));
        }
        catch (Exception ex) {
            log.error("gzip-uncompress-error:", (Throwable)ex);
        }
        stats.add("end-gzip-node");
        try {
            node = (TreeNode)SerializationUtils.fromJsonString((String)_cacheTreeNode, TreeNode.class);
        }
        catch (Exception ex) {
            log.error("json-parse-error:", (Throwable)ex);
        }
        return node;
    }

    public static String getCacheData(IPageCache pageCache, String cacheKey) {
        if (pageCache == null || cacheKey == null) {
            return null;
        }
        LogStats stats = new LogStats("budget-tree-log : ");
        String cacheData = F7TreeUtils.getCacheData(pageCache, cacheKey, stats);
        log.info(stats.toString());
        return cacheData;
    }

    public static String getCacheData(IPageCache pageCache, String cacheKey, LogStats stats) {
        if (pageCache == null || cacheKey == null || stats == null) {
            return null;
        }
        stats.addInfo("begin-get-data");
        String cacheData = F7TreeUtils.getCacheData(pageCache.get(cacheKey), stats);
        stats.add("end-get-data");
        return cacheData;
    }

    public static String getCacheData(String cacheTreeData, @NotNull LogStats stats) {
        if (StringUtils.isEmpty(cacheTreeData)) {
            return null;
        }
        String _cacheTreeNode = cacheTreeData;
        stats.addInfo("before-unzip-size:" + _cacheTreeNode.length());
        try {
            _cacheTreeNode = GZIPUtils.uncompressToString((byte[])SerializationUtils.deSerializeFromBase64((String)_cacheTreeNode));
        }
        catch (Exception ex) {
            log.error("gzip-uncompress-error:", (Throwable)ex);
        }
        stats.addInfo("after-unzip-size:" + _cacheTreeNode.length());
        stats.add("end-gzip-data");
        return _cacheTreeNode;
    }

    public static String getZipData(Object object) {
        LogStats stats = new LogStats("budget-tree-log : ");
        try {
            String string = F7TreeUtils.getZipData(object, stats);
            return string;
        }
        finally {
            log.info(stats.toString());
        }
    }

    public static String getZipData(Object object, @NotNull LogStats stats) {
        String _cacheData;
        if (object == null) {
            return null;
        }
        stats.addInfo("begin-gzip-data");
        try {
            _cacheData = SerializationUtils.serializeToBase64((Object)object);
            stats.addInfo("after-serialize-size:" + _cacheData.length());
            _cacheData = SerializationUtils.serializeToBase64((Object)GZIPUtils.compress(_cacheData));
            stats.addInfo("after-gzip-size:" + _cacheData.length());
        }
        catch (Exception ex) {
            log.error("gzip-uncompress-error:", (Throwable)ex);
            _cacheData = null;
        }
        stats.add("end-gzip-data");
        log.info(stats.toString());
        return _cacheData;
    }

    public static <T> T getUnZipObject(String cacheData) {
        if (StringUtils.isEmpty(cacheData)) {
            return null;
        }
        LogStats stats = new LogStats("budget-tree-log : ");
        stats.addInfo("begin-unzip-object");
        stats.addInfo("before-size:" + cacheData.length());
        Object _object = null;
        try {
            _object = SerializationUtils.deSerializeFromBase64((String)GZIPUtils.uncompressToString((byte[])SerializationUtils.deSerializeFromBase64((String)cacheData)));
        }
        catch (Exception ex) {
            log.error("gzip-uncompress-error:", (Throwable)ex);
        }
        stats.add("end-unzip-object");
        log.info(stats.toString());
        return (T)_object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getCacheObjectData(@NotNull IPageCache pageCache, @NotNull String cacheKey) {
        LogStats stats = new LogStats("budget-tree-log : ");
        try {
            T t = F7TreeUtils.getUnZipObject(pageCache.get(cacheKey));
            return t;
        }
        finally {
            log.info(stats.toString());
        }
    }

    public static String[] getShowType(ShowTypeEnum showType) {
        return F7TreeUtils.getShowType(showType, false);
    }

    public static String[] getShowType(ShowTypeEnum showType, boolean isShowNumber) {
        String[] showTypes;
        String[] stringArray = showTypes = isShowNumber ? F7Constant.SHOW_SHOW_NUMBER_NAME : F7Constant.DEFAULT_SHOW_FIELDS;
        if (ShowTypeEnum.NUMBER == showType) {
            showTypes = isShowNumber ? F7Constant.SHOW_SHOW_NUMBER : F7Constant.SHOW_NUMBER;
        } else if (ShowTypeEnum.NAME == showType) {
            showTypes = F7Constant.SHOW_NAME;
        }
        return showTypes;
    }

    public static String nodeShowType(@NotNull Map<String, Object> nodeData, String[] showType) {
        if (showType == null) {
            return null;
        }
        Object[] shows = new String[showType.length];
        for (int i = 0; i < showType.length; ++i) {
            shows[i] = (String)nodeData.get(showType[i]);
        }
        return StringUtils.join(shows, ' ');
    }

    public static class TreeCacheV2 {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cacheTreeNode(@NotNull IPageCache pageCache, @NotNull String cacheKey, TreeNode root) {
            LogStats stats = new LogStats("budget-tree-log : ");
            try {
                this.cacheTreeNode(pageCache, cacheKey, root, stats);
            }
            finally {
                log.info(stats.toString());
            }
        }

        public void cacheTreeNode(@NotNull IPageCache pageCache, @NotNull String cacheKey, TreeNode root, @NotNull LogStats stats) {
            this.cacheObject(pageCache, cacheKey, root, stats);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cacheObject(@NotNull IPageCache pageCache, @NotNull String cacheKey, Object object) {
            LogStats stats = new LogStats("budget-tree-log : ");
            try {
                this.cacheObject(pageCache, cacheKey, object, stats);
            }
            finally {
                log.info(stats.toString());
            }
        }

        public void cacheObject(@NotNull IPageCache pageCache, @NotNull String cacheKey, Object object, @NotNull LogStats stats) {
            stats.addInfo("begin-cache-object-v2.");
            if (object != null) {
                String _compressData = null;
                try {
                    _compressData = NewGzipUtils.compress(object);
                    stats.add("end-gzip-v2.");
                }
                catch (Exception ex) {
                    log.error("gzip-compress-error-v2:", (Throwable)ex);
                }
                pageCache.putBigObject(cacheKey, _compressData);
                stats.addInfo("end-cache-object-v2. cacheSize=" + (_compressData != null ? Integer.valueOf(_compressData.length()) : "null"));
            } else {
                pageCache.removeBigObject(cacheKey);
                stats.addInfo("end-remove-object-v2.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TreeNode getTreeNode(@NotNull IPageCache pageCache, @NotNull String cacheKey) {
            LogStats stats = new LogStats("budget-tree-log : ");
            try {
                TreeNode treeNode = this.getTreeNode(pageCache, cacheKey, stats);
                return treeNode;
            }
            finally {
                log.info(stats.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TreeNode getTreeNode(@NotNull String compressData) {
            LogStats stats = new LogStats("budget-tree-log : ");
            TreeNode treeNode = null;
            try {
                Object object = this.getObject(compressData, stats);
                if (object instanceof TreeNode) {
                    treeNode = (TreeNode)object;
                } else if (object != null) {
                    stats.addInfo(object.getClass().getName());
                }
            }
            finally {
                log.info(stats.toString());
            }
            return treeNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TreeNode getTreeNode(@NotNull IPageCache pageCache, @NotNull String cacheKey, @NotNull LogStats stats) {
            TreeNode treeNode = null;
            try {
                Object object = this.getObject(pageCache, cacheKey, stats);
                if (object instanceof TreeNode) {
                    treeNode = (TreeNode)object;
                } else if (object != null) {
                    stats.addInfo(object.getClass().getName());
                }
            }
            finally {
                log.info(stats.toString());
            }
            return treeNode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getObject(@NotNull IPageCache pageCache, @NotNull String cacheKey) {
            LogStats stats = new LogStats("budget-tree-log : ");
            try {
                Object object = this.getObject(pageCache, cacheKey, stats);
                return object;
            }
            finally {
                log.info(stats.toString());
            }
        }

        public Object getObject(@NotNull IPageCache pageCache, @NotNull String cacheKey, @NotNull LogStats stats) {
            if (StringUtils.isEmpty(cacheKey)) {
                return null;
            }
            return this.getObject(pageCache.get(cacheKey), stats);
        }

        public Object getObject(@NotNull String compressData, @NotNull LogStats stats) {
            if (StringUtils.isEmpty(compressData)) {
                return null;
            }
            stats.addInfo("begin-getObject");
            Object object = null;
            try {
                object = NewGzipUtils.unCompress(compressData);
            }
            catch (Exception ex) {
                log.error("gzip-uncompress-error:", (Throwable)ex);
                throw new KDBizException(CommonServiceHelper.getStackTraceStr(ex));
            }
            finally {
                stats.add("end-getObject");
                log.info(stats.toString());
            }
            return object;
        }
    }
}

