/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.member.f7;

import com.alibaba.fastjson.annotation.JSONField;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.View;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.entity.memberF7.F7PatternEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.AuditTrailUseEnum;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.ShowTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MemberSourceEnum;
import kd.epm.eb.common.enums.dimensionEnums.ViewMemberSourceEnum;
import kd.epm.eb.common.member.f7.F7Constant;
import kd.epm.eb.common.member.f7.MemberF7Utils;
import kd.epm.eb.common.model.BizModel;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.ModelServiceHelper;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.viewgroup.ViewGroupServiceHelper;
import org.jetbrains.annotations.NotNull;

public class MemberF7Parameter
implements Serializable {
    private static final Log log = LogFactory.getLog(MemberF7Parameter.class);
    private static final long serialVersionUID = 8928116518614915727L;
    public static final int DEFAULT_SHOW = 0;
    public static final int SHOW_RANGE = 1;
    public static final int VIRTUAL_SHOW = 2;
    public String rootText;
    @JSONField(serialize=false, deserialize=false)
    private transient IModelCacheHelper modelCacheHelper = null;
    @JSONField(serialize=false, deserialize=false)
    private transient MemberPropCache propCache = null;
    private int functionType = 0;
    private F7PatternEnum pattern = F7PatternEnum.NORMAL;
    private Long modelId = null;
    private Long ebModelId = null;
    private String modelNumber = null;
    private Long busModelId = null;
    private List<Long> datasetIds = null;
    private Long dimensionId = null;
    private String dimensionNumber = null;
    private String dimensionName = null;
    private Long viewId = null;
    private Long viewGroupId = null;
    private List<Long> viewIds = null;
    private boolean loadDefaultBusModel = true;
    private boolean switchViewBySelMem = true;
    private Long memberId = null;
    private List<String> selectIds = null;
    private List<String> dimNums4PermGroup;
    private Map<Long, Integer> selectRange = null;
    private Map<Long, Integer> rangeLevel = null;
    private Set<Long> selectRangeIds = null;
    private boolean mustSelected = true;
    private boolean showDisableVisible = true;
    private boolean showDisable = false;
    private boolean showNotEnable = false;
    private boolean showChildren = true;
    private boolean includeChildren = true;
    private boolean isShowAnalyseMember = false;
    private boolean enableView = false;
    private boolean multiSelect = true;
    private boolean onlySelLeaf = false;
    private boolean canSelectRoot = true;
    private boolean canSelectBudgetPeriodRoot = true;
    private boolean showLeaf = false;
    private boolean hideDecompose = true;
    private boolean hideBudgetOccupation = false;
    private boolean showVariable = false;
    private boolean showCustomPropertyColumn = true;
    private boolean showCustomProperty = false;
    private boolean showSimpleName = true;
    private boolean showDebitAndCredit = false;
    private boolean stepLoad = true;
    private String returnClassName = null;
    private boolean returnAllData = false;
    private transient DynamicObject model = null;
    @JSONField(serialize=false, deserialize=false)
    private transient Boolean EB = null;
    private transient DynamicObject dimension = null;
    private Long rootMemberId = null;
    private transient DynamicObject busModel = null;
    private transient DynamicObject view = null;
    private String entityNumber = null;
    private boolean verifyPermission = true;
    private boolean verifyManagerPermission = false;
    private Map<String, Set<Long>> combPermMap = null;
    private int variableType = 0;
    private DimMembPermType permType = DimMembPermType.READ;
    private static final Set<String> VIEW_ENTITY_NUMBER = new HashSet<String>();
    private QFBuilder treeBuilder = null;
    private QFBuilder noTreeBuilder = null;
    @JSONField(serialize=false, deserialize=false)
    private boolean checkPermission = false;
    @JSONField(serialize=false, deserialize=false)
    private transient Set<Long> permissionIds = null;
    @JSONField(serialize=false, deserialize=false)
    private boolean checkManagerPermission = false;
    @JSONField(serialize=false, deserialize=false)
    private transient Set<Long> managerPermissionIds = null;
    @JSONField(serialize=false, deserialize=false)
    private transient Set<Long> analyseMemberIds = null;
    private String customCommFilters = null;
    public String customFilters = null;
    private boolean forDisable = false;
    private boolean forEnable = false;
    private String varFilters = null;
    private static final String DEFAULT_FIELDS = "id,name,number,parent.id,isleaf";
    private static final String DEFAULT_VIEW_FIELDS = "id,name,number,parent.id,isleaf,memberid";
    private static final String DEFAULT_ACCOUNT_FIELDS = "id,name,number,parent.id,isleaf,dataset.id";
    private static final String DEFAULT_ACCOUNT_SIMPLENAME = ",simplename";
    private static final String DEFAULT_ACCOUNT_DRCRDIRECT = ",drcrdirect";
    private static final String DEFAULT_METRIC_HASAGG_STORAGE = ",isagg,storagenodetail";
    private static final String DEFAULT_SHOW_NUMBER = ",shownumber";
    public static final String DEFAULT_SOURCE = "membersource";
    private String fields = null;
    private static final String DEFAULT_ORDER = "longnumber";
    private String orderBy = null;
    private Long version = 0L;
    private ShowTypeEnum showType = null;
    private F7RangeTypeEnum rangeType = F7RangeTypeEnum.DEFAULT;
    private List<String> cusRange = null;
    private RangeEnum defRangeValue = null;
    private boolean lockRangeSelect = false;
    private String viewSign = null;
    private boolean isFloat = true;
    private boolean isFloatAddNew = false;
    private Long floatParentId = null;
    private boolean cutTree = true;
    private boolean cutParentNode = false;
    private boolean showLongName = true;
    private boolean showLevel = false;
    private boolean showExclude = false;
    private Set<Long> excludeMemberIds = null;
    private Long userId = null;
    public static final String PERM_READ = "R";
    public static final String PERM_WRITE = "W";
    public static final String PERM_ALL = "A";
    private String permissionType = "R";
    private String schemaNumber = null;
    private String title = null;
    private List<Map<String, Object>> virtualMembers = null;
    private List<String[]> selectedVirtualMember = null;
    private boolean backFillVirtualMember = false;
    private static final Set<String> SHOW_DIM_MODEL;

    @JSONField(serialize=false, deserialize=false)
    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate(this.getModelId());
        }
        return this.modelCacheHelper;
    }

    @JSONField(serialize=false, deserialize=false)
    public void setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
    }

    @JSONField(serialize=false, deserialize=false)
    public MemberPropCache getPropCache() {
        if (this.propCache == null) {
            this.propCache = MemberPropCacheService.getOrCreate(this.getModelId());
        }
        return this.propCache;
    }

    public void setFunctionType(int functionType) {
        this.functionType = functionType;
    }

    public int getFunctionType() {
        return this.functionType;
    }

    public F7PatternEnum getPattern() {
        return this.pattern;
    }

    public void setPattern(F7PatternEnum pattern) {
        this.pattern = pattern;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public Long getEbModelId() {
        return this.ebModelId;
    }

    public void setEbModelId(Long ebModelId) {
        this.ebModelId = ebModelId;
    }

    public void setModelNumber(String modelNumber) {
        this.modelNumber = modelNumber;
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public Long getBusModelId() {
        return this.busModelId;
    }

    public void setBusModelId(Long busModelId) {
        this.busModelId = busModelId;
        this.loadBusModel();
    }

    public List<Long> getDatasetIds() {
        return this.datasetIds;
    }

    public void setDatasetId(@NotNull Long datasetId) {
        if (IDUtils.isNull(datasetId)) {
            return;
        }
        this.datasetIds = new ArrayList<Long>();
        this.datasetIds.add(datasetId);
    }

    public void setDatasetIds(@NotNull List<Long> datasetIds) {
        this.datasetIds = datasetIds;
    }

    public void setDimensionId(Long dimensionId) {
        this.dimensionId = dimensionId;
        this.dimension = null;
        this.entityNumber = null;
        this.dimensionNumber = null;
        this.loadBusModel();
    }

    public Long getDimensionId() {
        return this.dimensionId;
    }

    public void setDimensionNumber(String dimensionNumber) {
        this.dimensionNumber = dimensionNumber;
    }

    public String getDimensionNumber() {
        return this.dimensionNumber;
    }

    public void setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public void setViewId(Long viewId) {
        this.viewId = viewId;
        this.view = null;
    }

    public Long getViewId() {
        return this.viewId;
    }

    public boolean isView() {
        return IDUtils.isNotNull(this.getViewId()) && !this.isEb();
    }

    public void setViewGroupId(Long viewGroupId) {
        this.viewGroupId = viewGroupId;
    }

    public Long getViewGroupId() {
        return this.viewGroupId;
    }

    public List<Long> getViewIds() {
        return this.viewIds;
    }

    public void setViewIds(List<Long> viewIds) {
        this.viewIds = viewIds;
    }

    public boolean isLoadDefaultBusModel() {
        return this.loadDefaultBusModel;
    }

    public void setLoadDefaultBusModel(boolean loadDefaultBusModel) {
        this.loadDefaultBusModel = loadDefaultBusModel;
    }

    public boolean isSwitchViewBySelMem() {
        return this.switchViewBySelMem;
    }

    public void setSwitchViewBySelMem(boolean switchViewBySelMem) {
        this.switchViewBySelMem = switchViewBySelMem;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public Long getMemberId() {
        return this.memberId;
    }

    public void setSelectIds(List<String> selectIds) {
        this.selectIds = selectIds;
    }

    public List<String> getSelectIds() {
        return this.selectIds;
    }

    public List<String> getDimNums4PermGroup() {
        return this.dimNums4PermGroup;
    }

    public void setDimNums4PermGroup(List<String> dimNums4PermGroup) {
        this.dimNums4PermGroup = dimNums4PermGroup;
    }

    @JSONField(serialize=false, deserialize=false)
    public Map<Long, Integer> getSelectedData() {
        return this.toMap(this.getSelectIds());
    }

    @JSONField(serialize=false, deserialize=false)
    public void setSelectIds(Map<Long, Integer> selectIds) {
        Long viewId;
        Map<Long, Integer> _selectIds = this.filterSelectedData(selectIds);
        this.selectIds = this.toArrays(_selectIds);
        if (_selectIds != null && !_selectIds.isEmpty() && IDUtils.isNotNull(viewId = this.queryViewIdByMemberId(_selectIds.keySet()))) {
            this.setViewId(viewId);
        }
    }

    protected Map<Long, Integer> filterSelectedData(Map<Long, Integer> selectIds) {
        if (selectIds == null || selectIds.isEmpty()) {
            return Collections.emptyMap();
        }
        if (!this.isVerifyPermission()) {
            return selectIds;
        }
        Set<Long> _permissionIds = this.loadPermission();
        if (_permissionIds == null) {
            return selectIds;
        }
        IModelCacheHelper modelCache = this.getModelCacheHelper();
        Dimension dimension = modelCache.getDimension(this.getDimensionNumber());
        LinkedHashMap _selectIds = Maps.newLinkedHashMapWithExpectedSize((int)selectIds.size());
        for (Map.Entry<Long, Integer> entry : selectIds.entrySet()) {
            Member member;
            Member member2 = member = dimension != null ? dimension.getMember(this.getViewId(), entry.getKey()) : null;
            if (member != null) {
                if (!_permissionIds.contains(entry.getKey())) continue;
                _selectIds.put(entry.getKey(), entry.getValue());
                continue;
            }
            _selectIds.put(entry.getKey(), entry.getValue());
        }
        return _selectIds;
    }

    @JSONField(serialize=false, deserialize=false)
    public void setSelectIds(Set<Long> selectIds) {
        if (selectIds == null) {
            this.selectIds = null;
        } else {
            LinkedHashMap _selectIds = Maps.newLinkedHashMapWithExpectedSize((int)selectIds.size());
            for (Long selectId : selectIds) {
                _selectIds.put(selectId, RangeEnum.ONLY.getIndex());
            }
            this.setSelectIds(_selectIds);
        }
    }

    @JSONField(serialize=false, deserialize=false)
    public void setSelectId(Long selectId) {
        if (IDUtils.isNull(selectId)) {
            return;
        }
        this.setSelectIds(Collections.singleton(selectId));
    }

    @JSONField(serialize=false, deserialize=false)
    private List<String> toArrays(Map<Long, Integer> selectIds) {
        if (selectIds == null || selectIds.isEmpty()) {
            return null;
        }
        ArrayList _selectIds = Lists.newArrayListWithExpectedSize((int)selectIds.size());
        for (Map.Entry<Long, Integer> entry : selectIds.entrySet()) {
            _selectIds.add(entry.getKey() + "@" + entry.getValue());
        }
        return _selectIds;
    }

    @JSONField(serialize=false, deserialize=false)
    private Map<Long, Integer> toMap(List<String> selectIds) {
        if (selectIds == null || selectIds.isEmpty()) {
            return null;
        }
        LinkedHashMap selectIdMap = Maps.newLinkedHashMapWithExpectedSize((int)selectIds.size());
        for (String entry : selectIds) {
            String[] tmpStr = entry.split("@");
            if (tmpStr.length != 2) continue;
            try {
                Long memberId = Long.valueOf(tmpStr[0]);
                Integer scope = Integer.valueOf(tmpStr[1]);
                selectIdMap.put(memberId, scope);
            }
            catch (Exception ex) {
                log.error("selectedIds-trans-error:", (Object)entry);
            }
        }
        return selectIdMap;
    }

    @JSONField(serialize=false, deserialize=false)
    public ListSelectedRowCollection selectedListRows() {
        ListSelectedRowCollection rows = new ListSelectedRowCollection();
        Map<Long, Integer> _selectIds = this.getSelectedData();
        if (_selectIds != null && !_selectIds.isEmpty()) {
            for (Map.Entry<Long, Integer> entry : _selectIds.entrySet()) {
                ListSelectedRow row = new ListSelectedRow((Object)entry.getKey());
                if (entry.getValue() != null) {
                    HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
                    dataMap.put("scope", entry.getValue());
                    row.setDataMap(dataMap);
                }
                rows.add((Object)row);
            }
        }
        return rows;
    }

    private Long queryViewIdByMemberId(Set<Long> memberIds) {
        if (IDUtils.isNull(this.getBusModelId())) {
            return null;
        }
        if (memberIds == null || memberIds.isEmpty()) {
            return null;
        }
        if (IDUtils.isNull(this.getModelId()) || IDUtils.isNull(this.getDimensionId())) {
            log.warn("modelId or dimensionId is null.");
            return null;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fmemberid, fviewid from t_eb_viewmember where ", new Object[0]);
        sql.append("fmodelid = ?", new Object[]{this.getModelId()});
        sql.append(" and fdimensionid = ?", new Object[]{this.getDimensionId()});
        if (IDUtils.isNotNull(this.getBusModelId()) && IDUtils.isNotNull(this.getViewGroupId())) {
            sql.append(" and ", new Object[0]).appendIn("fviewid", ViewGroupServiceHelper.getInstance().getAllViewByGroupId(Collections.singletonList(this.getViewGroupId())).toArray());
        }
        if (CollectionUtils.isNotEmpty(this.getViewIds())) {
            sql.append(" and ", new Object[0]).appendIn("fviewid", this.getViewIds().toArray());
        }
        sql.append(" and ", new Object[0]).appendIn("fmemberid", memberIds.toArray());
        HashMap viewMemberMap = Maps.newHashMapWithExpectedSize((int)16);
        try (DataSet ds = DB.queryDataSet((String)"queryViewId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    Set _memberIds = viewMemberMap.computeIfAbsent(row.getLong("fviewid"), f -> Sets.newHashSet());
                    _memberIds.add(row.getLong("fmemberid"));
                }
            }
        }
        HashSet viewIds = Sets.newHashSetWithExpectedSize((int)16);
        Long viewId = null;
        for (Map.Entry entry : viewMemberMap.entrySet()) {
            if (!((Set)entry.getValue()).containsAll(memberIds)) continue;
            viewIds.add(entry.getKey());
        }
        if (IDUtils.isNotNull(this.getViewId()) && viewIds.contains(this.getViewId())) {
            return null;
        }
        if (this.isSwitchViewBySelMem() && !viewIds.isEmpty()) {
            viewId = (Long)viewIds.iterator().next();
        }
        return viewId;
    }

    public void setSelectRange(Map<Long, Integer> selectRange) {
        this.selectRange = selectRange;
    }

    public Map<Long, Integer> getSelectRange() {
        return this.selectRange;
    }

    public void addSelectRange(@NotNull Long memberId, int range) {
        if (IDUtils.isNull(memberId)) {
            return;
        }
        if (this.selectRange == null) {
            this.selectRange = Maps.newLinkedHashMap();
        }
        this.selectRange.put(memberId, range);
    }

    public void addSelectRange(@NotNull String memberNumber, int range, @NotNull IModelCacheHelper cacheHelper) {
        this.addSelectRange(memberNumber, range, 0, cacheHelper);
    }

    public void addSelectRange(@NotNull String memberNumber, int range, int rangeLevel, @NotNull IModelCacheHelper cacheHelper) {
        Member member;
        if (this.selectRange == null) {
            this.selectRange = Maps.newLinkedHashMap();
        }
        if ((member = cacheHelper.getMember(this.getDimensionNumber(), this.viewId, memberNumber)) != null) {
            this.selectRange.put(member.getId(), range);
            this.addRangeLevel(member.getId(), rangeLevel);
        }
    }

    public void addSelectRange(Map<Long, Integer> ranges) {
        if (ranges == null || ranges.isEmpty()) {
            return;
        }
        if (this.selectRange == null) {
            this.selectRange = Maps.newLinkedHashMap();
        }
        this.selectRange.putAll(ranges);
    }

    public void setRangeLevel(Map<Long, Integer> rangeLevel) {
        this.rangeLevel = rangeLevel;
    }

    public Map<Long, Integer> getRangeLevel() {
        return this.rangeLevel;
    }

    public void addRangeLevel(Long memberId, int level) {
        if (IDUtils.isNull(memberId) || level <= 0) {
            return;
        }
        if (this.rangeLevel == null) {
            this.rangeLevel = Maps.newLinkedHashMap();
        }
        this.rangeLevel.put(memberId, level);
    }

    public void addRangeLevel(Map<Long, Integer> rangeLevels) {
        if (rangeLevels == null || rangeLevels.isEmpty()) {
            return;
        }
        if (this.rangeLevel == null) {
            this.rangeLevel = Maps.newLinkedHashMap();
        }
        this.rangeLevel.putAll(rangeLevels);
    }

    public void setSelectRangeIds(Set<Long> selectRangeIds) {
        this.selectRangeIds = selectRangeIds;
    }

    public Set<Long> getSelectRangeIds() {
        return this.selectRangeIds;
    }

    public void setMustSelected(boolean mustSelected) {
        this.mustSelected = mustSelected;
    }

    public boolean isMustSelected() {
        return this.mustSelected;
    }

    public void setShowDisableVisible(boolean showDisableVisible) {
        this.showDisableVisible = showDisableVisible;
    }

    public boolean isShowDisableVisible() {
        return this.showDisableVisible;
    }

    public void setShowDisable(boolean showDisable) {
        this.showDisable = showDisable;
    }

    public boolean isShowDisable() {
        return this.showDisable;
    }

    public boolean isShowNotEnable() {
        return this.showNotEnable;
    }

    public void setShowNotEnable(boolean showNotEnable) {
        this.showNotEnable = showNotEnable;
    }

    public void setShowChildren(boolean showChildren) {
        this.showChildren = showChildren;
    }

    public boolean isShowChildren() {
        return this.showChildren;
    }

    public void setIncludeChildren(boolean includeChildren) {
        this.includeChildren = includeChildren;
    }

    public boolean isIncludeChildren() {
        if (!this.isShowChildren()) {
            return false;
        }
        return this.includeChildren;
    }

    public void setShowAnalyseMember(boolean showAnalyseMember) {
        this.isShowAnalyseMember = showAnalyseMember;
    }

    public boolean isShowAnalyseMember() {
        return this.isShowAnalyseMember;
    }

    public void setEnableView(boolean enableView) {
        this.enableView = enableView;
    }

    public boolean isEnableView() {
        return this.enableView;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setOnlySelLeaf(boolean onlySelLeaf) {
        this.onlySelLeaf = onlySelLeaf;
    }

    public boolean isOnlySelLeaf() {
        return this.onlySelLeaf;
    }

    public void setCanSelectRoot(boolean canSelectRoot) {
        this.canSelectRoot = canSelectRoot;
    }

    public boolean isCanSelectRoot() {
        if ("BudgetPeriod".equals(this.getDimensionNumber())) {
            return this.isCanSelectBudgetPeriodRoot();
        }
        return this.canSelectRoot;
    }

    public void canSelectRoot() {
        String entityNumber = this.entityNumber();
        if (!"epm_userdefinedmembertree".equals(entityNumber) && !"epm_bperiodmembertree".equals(entityNumber)) {
            if ("eb_viewmember".equals(entityNumber)) {
                SysDimensionEnum sysDimensionEnum = SysDimensionEnum.getEnumByNumber(this.getDimensionNumber());
                if (sysDimensionEnum != null) {
                    this.setCanSelectRoot(false);
                }
            } else {
                this.setCanSelectRoot(false);
            }
        }
    }

    public void setCanSelectBudgetPeriodRoot(boolean canSelectBudgetPeriodRoot) {
        this.canSelectBudgetPeriodRoot = canSelectBudgetPeriodRoot;
    }

    public boolean isCanSelectBudgetPeriodRoot() {
        return this.canSelectBudgetPeriodRoot;
    }

    public void setShowLeaf(boolean showLeaf) {
        this.showLeaf = showLeaf;
    }

    public boolean isShowLeaf() {
        return this.showLeaf;
    }

    public void setHideDecompose(boolean hideDecompose) {
        this.hideDecompose = hideDecompose;
    }

    public boolean isHideDecompose() {
        return this.hideDecompose;
    }

    public void setHideBudgetOccupation(boolean hideBudgetOccupation) {
        this.hideBudgetOccupation = hideBudgetOccupation;
    }

    public boolean isHideBudgetOccupation() {
        return this.hideBudgetOccupation;
    }

    public void setShowVariable(boolean showVariable) {
        this.showVariable = showVariable;
    }

    public boolean isShowVariable() {
        return this.showVariable;
    }

    public void setShowCustomPropertyColumn(boolean showCustomPropertyColumn) {
        this.showCustomPropertyColumn = showCustomPropertyColumn;
    }

    public boolean isShowCustomPropertyColumn() {
        return this.showCustomPropertyColumn;
    }

    public void setShowCustomProperty(boolean showCustomProperty) {
        this.showCustomProperty = showCustomProperty;
    }

    public boolean isShowCustomProperty() {
        return this.showCustomProperty;
    }

    public boolean canShowCustomProperty() {
        if (this.getPattern() == F7PatternEnum.FLOAT) {
            return true;
        }
        boolean showProperty = false;
        if (StringUtils.equals("Entity", this.getDimensionNumber())) {
            showProperty = true;
        } else if ("epm_userdefinedmembertree".equals(this.entityNumber()) || "eb_viewmember".equals(this.entityNumber())) {
            showProperty = true;
        }
        return showProperty;
    }

    public void setShowSimpleName(boolean showSimpleName) {
        this.showSimpleName = showSimpleName;
    }

    public boolean isShowSimpleName() {
        return this.showSimpleName;
    }

    public boolean showSimpleName() {
        return this.isShowSimpleName() && (F7Constant.SHOW_SIMPLE_NAME_DIMS.contains(this.getDimensionNumber()) || this.hasCustomDim());
    }

    public void setShowDebitAndCredit(boolean showDebitAndCredit) {
        this.showDebitAndCredit = showDebitAndCredit;
    }

    public boolean isShowDebitAndCredit() {
        return this.showDebitAndCredit;
    }

    public boolean showDebitAndCredit() {
        return this.isShowDebitAndCredit() && this.hasAccountDim();
    }

    public void setStepLoad(boolean stepLoad) {
        this.stepLoad = stepLoad;
    }

    protected boolean isStepLoad() {
        return this.stepLoad;
    }

    public boolean stepLoad() {
        return !(!this.isStepLoad() || this.isShowAnalyseMember() || this.getFunctionType() != 1 && this.getFunctionType() != 2 || this.isVerifyPermission() && !ModelServiceHelper.isModelManager(this.getModelId()) || this.getSelectRangeIds() != null || this.getCustomCommFilters() != null);
    }

    public int getDefaultStopLevel() {
        return 2;
    }

    public void setReturnClassName(String returnClassName) {
        this.returnClassName = returnClassName;
    }

    public String getReturnClassName() {
        return this.returnClassName;
    }

    public void setReturnAllData(boolean returnAllData) {
        this.returnAllData = returnAllData;
    }

    public boolean isReturnAllData() {
        return this.returnAllData;
    }

    public void setModel(@NotNull DynamicObject model) {
        this.model = model;
    }

    public DynamicObject getModel() {
        return this.model;
    }

    @JSONField(serialize=false, deserialize=false)
    public boolean isEb() {
        if (this.EB == null) {
            this.EB = this.getModel() != null && ApplicationTypeEnum.isEB(ApplicationTypeEnum.getEnumByIndex(this.getModel().getString("reporttype")));
        }
        return this.EB;
    }

    public DynamicObject getDimension() {
        return this.dimension;
    }

    private void setDimension(@NotNull DynamicObject dimension) {
        this.dimension = dimension;
    }

    public void setRootMemberId(Long rootMemberId) {
        this.rootMemberId = rootMemberId;
    }

    public Long getRootMemberId() {
        return this.rootMemberId;
    }

    public DynamicObject getBusModel() {
        return this.busModel;
    }

    public void setBusModel(DynamicObject busModel) {
        this.busModel = busModel;
    }

    public void setView(DynamicObject view) {
        this.view = view;
    }

    public DynamicObject getView() {
        return this.view;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String entityNumber() {
        if (this.isView()) {
            return "eb_viewmember";
        }
        return this.entityNumber;
    }

    public String baseEntityNumber() {
        return this.entityNumber;
    }

    public void setVerifyPermission(boolean verifyPermission) {
        this.verifyPermission = verifyPermission;
    }

    public boolean isVerifyPermission() {
        return this.verifyPermission;
    }

    public void setVerifyManagerPermission(boolean verifyManagerPermission) {
        this.verifyManagerPermission = verifyManagerPermission;
    }

    public boolean isVerifyManagerPermission() {
        return this.verifyManagerPermission;
    }

    public void setCombPermMap(Map<String, Set<Long>> combPermMap) {
        this.combPermMap = combPermMap;
    }

    public Map<String, Set<Long>> getCombPermMap() {
        return this.combPermMap;
    }

    public void addCombinationPerm(@NotNull String dimensionNumber, @NotNull Set<Long> memberIds) {
        if (this.combPermMap == null) {
            this.combPermMap = new HashMap<String, Set<Long>>();
        }
        Set _memberIds = this.combPermMap.computeIfAbsent(dimensionNumber, f -> Sets.newLinkedHashSet());
        _memberIds.addAll(memberIds);
    }

    public int getVariableType() {
        return this.variableType;
    }

    public void setVariableType(int variableType) {
        this.variableType = variableType;
    }

    public void setPermType(DimMembPermType permType) {
        if (permType == null) {
            permType = DimMembPermType.READ;
        }
        this.permType = permType;
    }

    public DimMembPermType getPermType() {
        return this.permType;
    }

    public void check() {
        if (IDUtils.isNull(this.getModelId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u80fd\u4e3a\u7a7a", (String)"MemberF7Parameter_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        if (IDUtils.isNull(this.getDimensionId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (String)"MemberF7Parameter_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    public void loadData() {
        DynamicObject _view;
        DynamicObject defaultBusModel;
        if (this.getFunctionType() == 2) {
            return;
        }
        if (IDUtils.isNotNull(this.getModelId()) && (this.getModel() == null || !this.getModelId().equals(this.getModel().getLong("id")))) {
            this.setModel(this.queryModel(this.getModelId()));
            if (BizModel.isEBByModel(this.getModel())) {
                this.setShowCustomProperty(false);
                this.setBusModelId(null);
                this.setViewId(null);
            }
        }
        if (IDUtils.isNotNull(this.getDimensionId()) && (this.getDimension() == null || !this.getDimensionId().equals(this.getDimension().getLong("id")))) {
            this.setDimension(BusinessDataServiceHelper.loadSingleFromCache((Object)this.getDimensionId(), (String)"epm_dimension", (String)"id, name, number, shortnumber, membermodel"));
            this.entityNumber = this.getDimension().getString("membermodel");
            this.dimensionNumber = this.getDimension().getString("number");
            this.dimensionName = this.getDimension().getString("name");
        }
        if (this.isLoadDefaultBusModel() && IDUtils.isNull(this.getBusModelId()) && (defaultBusModel = this.queryDefaultBusModel()) != null) {
            this.setBusModelId(defaultBusModel.getLong("id"));
            this.setBusModel(defaultBusModel);
        }
        if (IDUtils.isNotNull(this.getBusModelId()) && (this.getBusModel() == null || !this.getBusModelId().equals(this.getBusModel().getLong("id")))) {
            this.loadBusModel();
        }
        if (IDUtils.isNull(this.getViewId())) {
            this.setDefaultView();
        } else if (IDUtils.isNotNull(this.getViewId()) && (this.getView() == null || !this.getViewId().equals(this.getView().getLong("id"))) && (_view = this.queryView(this.getViewId())) != null) {
            this.setView(_view);
        }
        Member rootMember = this.getModelCacheHelper().getRootMember(this.getDimensionNumber(), this.getViewId());
        if (rootMember != null) {
            this.setRootMemberId(rootMember.getId());
        }
    }

    public DynamicObject queryDefaultBusModel() {
        return BusinessModelServiceHelper.getInstance().getDefaultBusModel(this.getModelId(), null);
    }

    private void setDefaultView() {
        if (View.NoViewDimNums.contains(this.getDimensionNumber())) {
            return;
        }
        DynamicObject _view = this.queryDefaultView();
        if (_view != null) {
            this.setViewId(_view.getLong("id"));
            this.setView(_view);
        }
    }

    public DynamicObject queryDefaultView() {
        if (IDUtils.isNull(this.getBusModelId())) {
            return null;
        }
        Map<String, Long> viewIds = BusinessModelServiceHelper.getViewIds(this.getBusModelId());
        Long _viewId = viewIds != null ? viewIds.get(this.getDimensionNumber()) : null;
        DynamicObject _view = null;
        if (IDUtils.isNotNull(_viewId)) {
            _view = BusinessDataServiceHelper.loadSingleFromCache((Object)_viewId, (String)"eb_dimensionview", (String)"id,number,name,source,usage,version,viewgroup.id");
        }
        return _view;
    }

    public DynamicObject queryView(@NotNull Long viewId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)viewId, (String)"eb_dimensionview", (String)"id,number,name,source,usage,version,viewgroup.id");
    }

    private DynamicObject queryModel(@NotNull Long modelId) {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)modelId, (String)"epm_model", (String)"id, name, number, reporttype");
    }

    private void loadBusModel() {
        if (IDUtils.isNull(this.getBusModelId())) {
            return;
        }
        if (this.getBusModel() == null) {
            this.setBusModel(BusinessDataServiceHelper.loadSingleFromCache((Object)this.getBusModelId(), (String)"eb_businessmodel"));
        }
        if (this.getBusModel() != null && this.hasViewByDim() && StringUtils.isNotEmpty(this.getDimensionNumber())) {
            Map<String, Long> viewGroupIds = BusinessModelServiceHelper.getViewGroupIdsByBusinessModel(this.getBusModel());
            this.setViewGroupId(viewGroupIds.get(this.getDimensionNumber()));
            if (IDUtils.isNull(this.getViewId())) {
                Long _viewId;
                Map<String, Long> viewIds = BusinessModelServiceHelper.getViewIds(this.getBusModelId());
                Long l = _viewId = viewIds != null ? viewIds.get(this.getDimensionNumber()) : null;
                if (IDUtils.isNotNull(_viewId)) {
                    this.setViewId(_viewId);
                    this.canSelectRoot();
                }
            }
        }
    }

    private boolean hasViewByDim() {
        return VIEW_ENTITY_NUMBER.contains(this.baseEntityNumber());
    }

    public QFBuilder filters() {
        return this.filters(false);
    }

    public QFBuilder filters(boolean isBuildTree) {
        if (isBuildTree) {
            if (this.treeBuilder == null) {
                this.treeBuilder = this.$filters(true);
            }
            return this.treeBuilder;
        }
        if (this.noTreeBuilder == null) {
            this.noTreeBuilder = this.$filters(false);
        }
        return this.noTreeBuilder;
    }

    private QFBuilder $filters(boolean isBuildTree) {
        QFilter qFilter;
        LogStats stats = new LogStats("budget-log : ");
        stats.add("begin-filters.");
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", this.getModelId());
        builder.add("dimension", "=", this.getDimensionId());
        if (this.isView()) {
            builder.add("view", "=", this.getViewId());
        }
        if (this.hasAccountDim()) {
            LinkedHashSet<Long> _datasetIds = null;
            if (this.getDatasetIds() == null) {
                if (IDUtils.isNotNull(this.getBusModelId())) {
                    _datasetIds = new LinkedHashSet<Long>(BusinessModelServiceHelper.getInstance().queryDataSetIds(this.getBusModelId()));
                }
            } else {
                _datasetIds = new LinkedHashSet<Long>(this.getDatasetIds());
            }
            if (_datasetIds != null) {
                _datasetIds.add(0L);
                builder.add("dataset", "in", _datasetIds);
            }
        }
        builder.add(DEFAULT_SOURCE, "!=", MemberSourceEnum.COSMIC_INVISIBLE.getIndex());
        if (this.hasEntityDim() && !this.isView()) {
            builder.add(new QFilter("offsetsource", "!=", (Object)"2"));
        }
        if (!this.isShowNotEnable() || SysDimensionEnum.InternalCompany.getNumber().equals(this.getDimensionNumber())) {
            builder.add("enable", "=", "1");
        }
        if (!this.isShowDisable()) {
            builder.add(new QFilter("disable", "=", (Object)"0"));
        }
        String memberSource = MemberSourceEnum.PRESET.getIndex();
        if (this.isView()) {
            memberSource = ViewMemberSourceEnum.PRESET.getIndex();
        }
        if (this.isForDisable()) {
            qFilter = new QFilter("disable", "=", (Object)"0").and(DEFAULT_SOURCE, "!=", (Object)memberSource);
            if (this.isView()) {
                qFilter.and(DEFAULT_SOURCE, "!=", (Object)ViewMemberSourceEnum.INNER_REF.getIndex());
            }
            builder.add(qFilter);
        }
        if (this.isForEnable()) {
            qFilter = new QFilter("disable", "=", (Object)"1").and(DEFAULT_SOURCE, "!=", (Object)memberSource);
            if (this.isView()) {
                qFilter.and(DEFAULT_SOURCE, "!=", (Object)ViewMemberSourceEnum.INNER_REF.getIndex());
            }
            builder.add(qFilter);
        }
        if (this.isView()) {
            builder.add(new QFilter("showself", "=", (Object)"1"));
        }
        if (!this.isCanSelectRoot() && !isBuildTree) {
            builder.add("level", ">", 1);
        }
        if (SysDimensionEnum.AuditTrail.getNumber().equals(this.getDimensionNumber())) {
            if (this.isHideDecompose()) {
                builder.add("use", "!=", AuditTrailUseEnum.DECOMPOSE.getCode());
            }
            if (this.isHideBudgetOccupation()) {
                builder.add("number", "!=", "BudgetOccupation");
            }
        }
        if (!this.isView()) {
            QFilter viewFilter = new QFilter(DEFAULT_SOURCE, "!=", (Object)MemberSourceEnum.ANALYZE_VIEW.getIndex());
            if (this.isShowAnalyseMember()) {
                if (this.analyseMemberIds == null) {
                    this.analyseMemberIds = MemberF7Utils.queryBaseViewMemberId(this.getModelId(), this.getDimensionId());
                }
                if (!this.analyseMemberIds.isEmpty()) {
                    viewFilter.or(new QFilter("id", "in", this.analyseMemberIds));
                }
            }
            builder.add(viewFilter);
        }
        if (this.getCustomCommFilters() != null) {
            builder.add(this.customCommFilter());
        }
        if (this.isVerifyPermission()) {
            Set<Long> _permissionIds = this.$loadPermission(stats);
            if (_permissionIds != null) {
                if (_permissionIds.isEmpty()) {
                    log.info("f7-permission-is-null");
                    builder.add(this.pkField(), "=", 0L);
                } else {
                    builder.add(this.pkField(), "in", _permissionIds);
                }
            } else {
                log.info("f7-is-model-manager");
            }
        } else {
            log.info("f7-not-verifyPermission");
        }
        if (this.isVerifyManagerPermission()) {
            if (!this.checkManagerPermission) {
                this.managerPermissionIds = this.loadManagerPermission(stats);
                this.checkManagerPermission = true;
            }
            if (this.managerPermissionIds != null) {
                if (this.managerPermissionIds.isEmpty()) {
                    log.info("f7-managerPermission-is-null");
                    builder.add(this.pkField(), "=", 0L);
                } else {
                    builder.add(this.pkField(), "in", this.managerPermissionIds);
                }
            } else {
                log.info("f7-is-model-manager");
            }
        } else {
            log.info("f7-not-verifyManagerPermission");
        }
        if (isBuildTree && this.getSelectRangeIds() != null) {
            HashSet<Long> tmpIds = new HashSet<Long>(this.getSelectRangeIds());
            if (tmpIds.isEmpty()) {
                tmpIds.add(0L);
            }
            if (this.isView()) {
                builder.add("memberid", "in", tmpIds);
            } else {
                builder.add("id", "in", tmpIds);
            }
        }
        stats.addInfo(builder.toString());
        stats.addInfo("end-filters.");
        log.info(stats.toString());
        return builder;
    }

    public Set<Long> getPermissionIds() {
        return this.permissionIds;
    }

    @JSONField(serialize=false, deserialize=false)
    public String pkField() {
        return this.isView() ? "memberid" : "id";
    }

    public void setCustomCommFilters(String customCommFilters) {
        this.customCommFilters = customCommFilters;
    }

    public String getCustomCommFilters() {
        return this.customCommFilters;
    }

    public QFilter customCommFilter() {
        if (this.customCommFilters != null) {
            return QFilter.fromSerializedString((String)this.customCommFilters);
        }
        return null;
    }

    public void addCustomCommFilter(List<QFilter> filters) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        QFilter filter = StringUtils.isNotEmpty(this.customCommFilters) ? QFilter.fromSerializedString((String)this.customCommFilters) : filters.get(0);
        int in = filters.size();
        for (int i = 1; i < in; ++i) {
            filter.and(filters.get(i));
        }
        this.customCommFilters = filter.toSerializedString();
    }

    public void addCustomCommFilter(QFilter filter) {
        if (filter == null) {
            return;
        }
        this.addCustomCommFilter(Collections.singletonList(filter));
    }

    public void setCustomFilters(String customFilters) {
        this.customFilters = customFilters;
    }

    public String getCustomFilters() {
        return this.customFilters;
    }

    public QFilter customFilter() {
        if (this.customFilters != null) {
            return QFilter.fromSerializedString((String)this.customFilters);
        }
        return null;
    }

    public void addCustomFilter(List<QFilter> filters) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        QFilter filter = StringUtils.isNotEmpty(this.customFilters) ? QFilter.fromSerializedString((String)this.customFilters) : filters.get(0);
        int in = filters.size();
        for (int i = 1; i < in; ++i) {
            filter.and(filters.get(i));
        }
        this.customFilters = filter.toSerializedString();
    }

    public void addCustomFilter(QFilter filter) {
        if (filter == null) {
            return;
        }
        this.addCustomFilter(Collections.singletonList(filter));
    }

    public void setForDisable(boolean forDisable) {
        this.forDisable = forDisable;
    }

    public boolean isForDisable() {
        return this.forDisable;
    }

    public void setForEnable(boolean forEnable) {
        this.forEnable = forEnable;
    }

    public boolean isForEnable() {
        return this.forEnable;
    }

    public void setVarFilters(String varFilters) {
        this.varFilters = varFilters;
    }

    public String getVarFilters() {
        return this.varFilters;
    }

    public QFilter varFilters() {
        if (this.varFilters != null) {
            return QFilter.fromSerializedString((String)this.varFilters);
        }
        return null;
    }

    public void addVarFilter(List<QFilter> filters) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        QFilter filter = StringUtils.isNotEmpty(this.varFilters) ? QFilter.fromSerializedString((String)this.varFilters) : filters.get(0);
        int in = filters.size();
        for (int i = 1; i < in; ++i) {
            filter.and(filters.get(i));
        }
        this.varFilters = filter.toSerializedString();
    }

    public void addVarFilter(QFilter filter) {
        if (filter == null) {
            return;
        }
        this.addVarFilter(Collections.singletonList(filter));
    }

    public QFBuilder listFilter() {
        QFBuilder builder = this.filters();
        if (this.getSelectRange() != null && !this.getSelectRange().isEmpty()) {
            QFilter filter;
            LogStats stats = new LogStats("member-log:");
            stats.addInfo("begin-deal-member-range.");
            QFBuilder _builder = new QFBuilder();
            _builder.add("model", "=", this.getModelId());
            _builder.add("dimension", "=", this.getDimensionId());
            if (this.isView()) {
                _builder.add("view", "=", this.getViewId());
            }
            Dimension dimension = this.getModelCacheHelper().getDimension(this.getDimensionNumber());
            LinkedHashSet memberIds = Sets.newLinkedHashSet();
            if (this.isView()) {
                for (Map.Entry<Long, Integer> entry : this.getSelectRange().entrySet()) {
                    List<Member> _members = ModelCacheServiceHelper.getMemberById(this.getModelCacheHelper().getModelobj(), dimension, this.getViewId(), entry.getKey(), entry.getValue(), false);
                    if (_members == null || _members.isEmpty()) continue;
                    memberIds.addAll(_members.stream().map(BaseCache::getId).collect(Collectors.toSet()));
                }
                filter = new QFilter("memberid", "in", (Object)memberIds);
            } else {
                for (Map.Entry<Long, Integer> entry : this.getSelectRange().entrySet()) {
                    List<Member> _members = ModelCacheServiceHelper.getMemberById(this.getModelCacheHelper().getModelobj(), dimension, null, entry.getKey(), entry.getValue(), false);
                    if (_members == null || _members.isEmpty()) continue;
                    memberIds.addAll(_members.stream().map(BaseCache::getId).collect(Collectors.toSet()));
                }
                filter = new QFilter("id", "in", (Object)memberIds);
            }
            stats.addInfo("end-deal-member-range.");
            log.info(stats.toString());
            builder.retainOrAdd(filter);
        } else if (this.getSelectRangeIds() != null) {
            HashSet<Long> _selectRangeIds = new HashSet<Long>(this.getSelectRangeIds());
            if (_selectRangeIds.isEmpty()) {
                builder.add(this.pkField(), "=", 0L);
            } else {
                builder.add(this.pkField(), "in", _selectRangeIds);
            }
        }
        if (this.isOnlySelLeaf()) {
            builder.add("isleaf", "=", "1");
        }
        if (this.getCustomFilters() != null) {
            builder.add(this.customFilter());
        }
        return builder;
    }

    protected Map<Object, DynamicObject> transMembers(Map<Object, DynamicObject> members) {
        if (members == null || members.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap _members = Maps.newHashMapWithExpectedSize((int)members.size());
        for (DynamicObject _member : members.values()) {
            _members.put(_member.getLong("memberid"), _member);
        }
        return _members;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public String fields() {
        String _fields = this.fields;
        if (StringUtils.isEmpty(this.fields)) {
            if (this.isView()) {
                _fields = DEFAULT_VIEW_FIELDS;
            } else if (this.hasAccountDim()) {
                _fields = DEFAULT_ACCOUNT_FIELDS;
                if (this.showDebitAndCredit()) {
                    _fields = _fields + DEFAULT_ACCOUNT_DRCRDIRECT;
                }
            } else {
                _fields = this.hasMetric() ? "id,name,number,parent.id,isleaf,isagg,storagenodetail" : DEFAULT_FIELDS;
            }
        }
        if (this.isShowShowNumber(this.baseEntityNumber())) {
            _fields = _fields + DEFAULT_SHOW_NUMBER;
        }
        if (this.showSimpleName()) {
            _fields = _fields + DEFAULT_ACCOUNT_SIMPLENAME;
        }
        if (this.isShowAnalyseMember() && !_fields.contains(DEFAULT_SOURCE)) {
            _fields = _fields + ",membersource";
        }
        return _fields;
    }

    public boolean hasEntityDim() {
        return SysDimensionEnum.Entity.getNumber().equals(this.getDimensionNumber());
    }

    public boolean hasAccountDim() {
        return SysDimensionEnum.Account.getNumber().equals(this.getDimensionNumber());
    }

    public boolean hasMetric() {
        return SysDimensionEnum.Metric.getNumber().equals(this.getDimensionNumber());
    }

    public boolean hasCustomDim() {
        return "epm_userdefinedmembertree".equals(this.baseEntityNumber());
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String orderBy() {
        if (StringUtils.isEmpty(this.orderBy)) {
            this.orderBy = DEFAULT_ORDER;
        }
        return this.orderBy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<Long> $loadPermission(LogStats stats) {
        if (stats != null) {
            stats.addInfo("begin-load-permission.");
        }
        Long _modelId = this.getModelId();
        Long _busModelId = this.getBusModelId();
        if (_busModelId == null) {
            _busModelId = 0L;
        }
        Long _viewId = this.getViewId();
        List<String> _dimNums4PermGroup = this.getDimNums4PermGroup();
        try {
            Set<Long> rst = DimMembPermHelper.getPermMembIdsByGroup(null, this.getDimensionNumber(), CollectionUtils.isEmpty(_dimNums4PermGroup) ? null : _dimNums4PermGroup, _modelId, _busModelId, _viewId, this.getCombPermMap(), this.getPermType());
            if (rst == null && stats != null) {
                stats.addInfo("is-admin.");
            }
            Set<Long> set = rst;
            return set;
        }
        finally {
            if (stats != null) {
                stats.add("end-load-permission.");
            }
        }
    }

    public Set<Long> loadPermission() {
        return this.loadPermission(null);
    }

    public Set<Long> loadPermission(LogStats stats) {
        if (!this.checkPermission) {
            this.permissionIds = this.$loadPermission(stats);
            this.checkPermission = true;
        }
        return this.permissionIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> loadManagerPermission(@NotNull LogStats stats) {
        stats.addInfo("begin-load-managerPermission.");
        Long _modelId = this.getModelId();
        Long _busModelId = this.getBusModelId();
        if (_busModelId == null) {
            _busModelId = 0L;
        }
        try {
            Set<Long> rst = DimMembPermHelper.getPermMembIds(this.getDimensionNumber(), _modelId, _busModelId, this.getViewId(), DimMembPermType.MANAGER, true);
            if (rst == null) {
                stats.addInfo("is-admin.");
            }
            Set<Long> set = rst;
            return set;
        }
        finally {
            stats.add("end-load-managerPermission.");
        }
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getVersion() {
        return this.version;
    }

    public void setShowType(@NotNull ShowTypeEnum showType) {
        this.showType = showType;
    }

    public ShowTypeEnum getShowType() {
        return this.showType;
    }

    public void setRangeType(F7RangeTypeEnum rangeType) {
        this.rangeType = rangeType;
    }

    @JSONField(serialize=false, deserialize=false)
    public void setRangeTypeValue(int rangeType) {
        this.rangeType = F7RangeTypeEnum.indexOf(rangeType);
    }

    public F7RangeTypeEnum getRangeType() {
        return this.rangeType;
    }

    public void setCusRange(List<String> cusRange) {
        this.cusRange = cusRange;
    }

    public List<String> getCusRange() {
        return this.cusRange;
    }

    public void setDefRangeValue(RangeEnum defRangeValue) {
        this.defRangeValue = defRangeValue;
    }

    public RangeEnum getDefRangeValue() {
        return this.defRangeValue;
    }

    @JSONField(serialize=false, deserialize=false)
    public List<ComboItem> getRangeItems() {
        List<Object> items = new ArrayList();
        if (this.rangeType == F7RangeTypeEnum.ALL) {
            items = this.getAllRange();
        } else if (this.rangeType == F7RangeTypeEnum.MINI) {
            items = this.getMiniRange();
        } else if (this.rangeType == F7RangeTypeEnum.CUSTOMIZE) {
            items = this.getCustomRange();
        } else if (this.rangeType == F7RangeTypeEnum.DEFAULT) {
            items = this.getDefault();
        }
        return items;
    }

    @JSONField(serialize=false, deserialize=false)
    private List<ComboItem> getMiniRange() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
        items.add(new ComboItem(new LocaleString(RangeEnum.ONLY.getName()), String.valueOf(RangeEnum.ONLY.getIndex())));
        items.add(new ComboItem(new LocaleString(RangeEnum.ALL_EXCLUDE.getName()), String.valueOf(RangeEnum.ALL_EXCLUDE.getIndex())));
        items.add(new ComboItem(new LocaleString(RangeEnum.ALL.getName()), String.valueOf(RangeEnum.ALL.getIndex())));
        items.add(new ComboItem(new LocaleString(RangeEnum.ALL_DETAIL.getName()), String.valueOf(RangeEnum.ALL_DETAIL.getIndex())));
        items.add(new ComboItem(new LocaleString(RangeEnum.ALL_NOTDETAIL.getName()), String.valueOf(RangeEnum.ALL_NOTDETAIL.getIndex())));
        return items;
    }

    @JSONField(serialize=false, deserialize=false)
    private List<ComboItem> getCustomRange() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(32);
        if (this.getCusRange() != null && !this.getCusRange().isEmpty()) {
            for (String rangeIndex : this.getCusRange()) {
                RangeEnum rangeEnum = RangeEnum.getRangeByVal(rangeIndex);
                if (rangeEnum == null) continue;
                items.add(new ComboItem(new LocaleString(rangeEnum.getName()), rangeIndex));
            }
        }
        return items;
    }

    @JSONField(serialize=false, deserialize=false)
    private List<ComboItem> getAllRange() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(32);
        for (RangeEnum _range : RangeEnum.valuesByNoLevel()) {
            items.add(new ComboItem(new LocaleString(_range.getName()), String.valueOf(_range.getIndex())));
        }
        if (this.isShowLevel()) {
            items.add(new ComboItem(new LocaleString(RangeEnum.LEVEL.getName()), String.valueOf(RangeEnum.LEVEL.getIndex())));
            items.add(new ComboItem(new LocaleString(RangeEnum.LEVEL_EXCLUDE.getName()), String.valueOf(RangeEnum.LEVEL_EXCLUDE.getIndex())));
        }
        return items;
    }

    @JSONField(serialize=false, deserialize=false)
    private List<ComboItem> getDefault() {
        List<ComboItem> items = this.getAllRange();
        items.removeIf(item -> item.getValue().equals(String.valueOf(RangeEnum.ALL_DETAIL_INCLUDE.getIndex())) || item.getValue().equals(String.valueOf(RangeEnum.ANCESTOR.getIndex())) || item.getValue().equals(String.valueOf(RangeEnum.ANCESTOR_EXCLUDE.getIndex())));
        return items;
    }

    public void setLockRangeSelect(boolean lockRangeSelect) {
        this.lockRangeSelect = lockRangeSelect;
    }

    public boolean isLockRangeSelect() {
        return this.lockRangeSelect;
    }

    public void setViewSign(String viewSign) {
        this.viewSign = viewSign;
    }

    public String getViewSign() {
        return this.viewSign;
    }

    public void setFloat(boolean aFloat) {
        this.isFloat = aFloat;
    }

    public boolean isFloat() {
        return this.isFloat;
    }

    public void setFloatAddNew(boolean floatAddNew) {
        this.isFloatAddNew = floatAddNew;
    }

    public boolean isFloatAddNew() {
        return this.isFloatAddNew;
    }

    public void setFloatParentId(Long floatParentId) {
        this.floatParentId = floatParentId;
    }

    public Long getFloatParentId() {
        return this.floatParentId;
    }

    public void setCutTree(boolean cutTree) {
        this.cutTree = cutTree;
    }

    public boolean isCutTree() {
        return this.cutTree;
    }

    public boolean isCutParentNode() {
        return this.cutParentNode;
    }

    public void setCutParentNode(boolean cutParentNode) {
        this.cutParentNode = cutParentNode;
    }

    public void setShowLongName(boolean showLongName) {
        this.showLongName = showLongName;
    }

    public boolean isShowLongName() {
        return this.showLongName;
    }

    public boolean showLongName() {
        return this.isShowLongName() && (F7Constant.SHOW_NAME_DIMS.contains(this.getDimensionNumber()) || this.hasCustomDim());
    }

    public void setShowLevel(boolean showLevel) {
        this.showLevel = showLevel;
    }

    public boolean isShowLevel() {
        return this.showLevel;
    }

    public void setShowExclude(boolean showExclude) {
        this.showExclude = showExclude;
    }

    public boolean isShowExclude() {
        return this.showExclude;
    }

    public void setExcludeMemberIds(Set<Long> excludeMemberIds) {
        this.excludeMemberIds = excludeMemberIds;
    }

    public Set<Long> getExcludeMemberIds() {
        return this.excludeMemberIds;
    }

    public void addExcludeMemberId(Long memberId) {
        if (IDUtils.isNull(memberId)) {
            return;
        }
        if (this.excludeMemberIds == null) {
            this.excludeMemberIds = new HashSet<Long>();
        }
        this.excludeMemberIds.add(memberId);
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setPermissionType(String permissionType) {
        this.permissionType = permissionType;
    }

    public String getPermissionType() {
        return this.permissionType;
    }

    public void setSchemaNumber(String schemaNumber) {
        this.schemaNumber = schemaNumber;
    }

    public String getSchemaNumber() {
        return this.schemaNumber;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setVirtualMembers(List<Map<String, Object>> virtualMembers) {
        this.virtualMembers = virtualMembers;
    }

    public List<Map<String, Object>> getVirtualMembers() {
        return this.virtualMembers;
    }

    public void setSelectedVirtualMember(List<String[]> selectedVirtualMember) {
        this.selectedVirtualMember = selectedVirtualMember;
    }

    public List<String[]> getSelectedVirtualMember() {
        return this.selectedVirtualMember;
    }

    public void setBackFillVirtualMember(boolean backFillVirtualMember) {
        this.backFillVirtualMember = backFillVirtualMember;
    }

    public boolean isBackFillVirtualMember() {
        return this.backFillVirtualMember;
    }

    public String getRootText() {
        return this.rootText;
    }

    public void setRootText(String rootText) {
        this.rootText = rootText;
    }

    @JSONField(serialize=false, deserialize=false)
    public boolean isShowShowNumber(String memberTreeModel) {
        return SHOW_DIM_MODEL.contains(memberTreeModel) && !this.isEb();
    }

    static {
        VIEW_ENTITY_NUMBER.add(SysDimensionEnum.Entity.getMemberTreemodel());
        VIEW_ENTITY_NUMBER.add(SysDimensionEnum.InternalCompany.getMemberTreemodel());
        VIEW_ENTITY_NUMBER.add(SysDimensionEnum.ChangeType.getMemberTreemodel());
        VIEW_ENTITY_NUMBER.add("epm_userdefinedmembertree");
        SHOW_DIM_MODEL = new HashSet<String>();
        SHOW_DIM_MODEL.add(SysDimensionEnum.Entity.getMemberTreemodel());
        SHOW_DIM_MODEL.add(SysDimensionEnum.ChangeType.getMemberTreemodel());
        SHOW_DIM_MODEL.add(SysDimensionEnum.InternalCompany.getMemberTreemodel());
        SHOW_DIM_MODEL.add("epm_userdefinedmembertree");
    }
}

