/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.member.f7;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.constant.BgBaseConstant;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import org.jetbrains.annotations.NotNull;

public class MemberF7Utils {
    public static QFilter getMemberRangeFilter(String entityNumber, Long modelId, Long dimensionId, Long viewId, Map<Long, Set<Integer>> members) {
        String fields;
        if (modelId == null || dimensionId == null || members == null || members.isEmpty()) {
            return null;
        }
        HashSet onlyIds = Sets.newHashSetWithExpectedSize((int)members.size());
        boolean isAllOnly = true;
        for (Map.Entry<Long, Set<Integer>> member : members.entrySet()) {
            Set<Integer> value = member.getValue();
            if (CollectionUtils.isEmpty(value) || value.size() == 1 && value.contains(RangeEnum.ONLY.getIndex())) {
                onlyIds.add(member.getKey());
                continue;
            }
            isAllOnly = false;
        }
        DynamicObject view = null;
        if (IDUtils.isNotEmptyLong(viewId).booleanValue()) {
            view = BusinessDataServiceHelper.loadSingleFromCache((Object)viewId, (String)"eb_dimensionview", (String)"id,number,name,source,usage,version,viewgroup.id");
        }
        String idField = "id";
        String parentIdField = "parent.id";
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", modelId);
        builder.add("dimension", "=", dimensionId);
        if (view != null) {
            entityNumber = "eb_viewmember";
            builder.add("view", "=", viewId);
            builder.add("memberid", "in", members.keySet());
            fields = "memberid as id,parent.memberid as parent.id,longnumber,isleaf";
            idField = "memberid";
            parentIdField = "parent.memberid";
        } else {
            builder.add("id", "in", members.keySet());
            fields = "id,parent.id,longnumber,isleaf";
        }
        if (onlyIds.size() == members.size() && isAllOnly) {
            return new QFilter(idField, "in", (Object)onlyIds);
        }
        QFilter filter = null;
        QFilter _filter = null;
        DynamicObjectCollection memberObjs = QueryServiceHelper.query((String)entityNumber, (String)fields, (QFilter[])builder.toArray());
        if (memberObjs != null) {
            onlyIds.clear();
            for (DynamicObject _member : memberObjs) {
                Set<Integer> scopeSet = members.get(_member.getLong("id"));
                _filter = null;
                for (Integer scope : scopeSet) {
                    int rangeValue = scope;
                    RangeEnum range = RangeEnum.getRangeByVal(rangeValue);
                    Long memberId = _member.getLong("id");
                    if (range == RangeEnum.ONLY) {
                        onlyIds.add(memberId);
                        continue;
                    }
                    if (range == RangeEnum.DIRECTSUB_EXCLUDE || range == RangeEnum.DIRECTSUB) {
                        _filter = new QFilter(parentIdField, "=", (Object)memberId);
                        if (range != RangeEnum.DIRECTSUB) continue;
                        _filter.or(idField, "=", (Object)memberId);
                        continue;
                    }
                    if (range == RangeEnum.ALL_EXCLUDE || range == RangeEnum.ALL) {
                        _filter = new QFilter("longnumber", "like", (Object)(_member.getString("longnumber") + "!%"));
                        if (range != RangeEnum.ALL) continue;
                        _filter.or(idField, "=", (Object)memberId);
                        continue;
                    }
                    if (range == RangeEnum.PEERS_EXCLUDE || range == RangeEnum.PEERS) {
                        _filter = new QFilter("parent", "=", (Object)_member.getLong("parent.id"));
                        if (range != RangeEnum.PEERS_EXCLUDE) continue;
                        _filter.and(idField, "!=", (Object)memberId);
                        continue;
                    }
                    if (range == RangeEnum.ALL_DETAIL || range == RangeEnum.ALL_DETAIL_INCLUDE) {
                        _filter = new QFilter("longnumber", "like", (Object)(_member.getString("longnumber") + "!%"));
                        _filter.and("isleaf", "=", (Object)"1");
                        if (range != RangeEnum.ALL_DETAIL_INCLUDE && (range != RangeEnum.ALL_DETAIL || !_member.getBoolean("isleaf"))) continue;
                        _filter.or(idField, "=", (Object)memberId);
                        continue;
                    }
                    if (range != RangeEnum.ALL_NOTDETAIL) continue;
                    _filter = new QFilter("longnumber", "like", (Object)(_member.getString("longnumber") + "!%"));
                    _filter.and("isleaf", "=", (Object)"0");
                }
                if (_filter == null) continue;
                if (filter == null) {
                    filter = _filter;
                    continue;
                }
                filter.or(_filter);
            }
            if (!onlyIds.isEmpty()) {
                if (filter == null) {
                    filter = new QFilter(idField, "in", (Object)onlyIds);
                } else {
                    filter.or(idField, "in", (Object)onlyIds);
                }
            }
        }
        return filter;
    }

    public static Set<Long> queryViewMemberId(@NotNull Long modelId, Long viewId) {
        if (IDUtils.isNull(viewId)) {
            return null;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_eb_viewmember where fmodelid = ? and fviewid in (select fid from t_eb_dimensionview where fparentid = ? or fid = ?) and fmembersource = '1'", new Object[]{modelId, viewId, viewId});
        LinkedHashSet viewMemberIds = Sets.newLinkedHashSetWithExpectedSize((int)1024);
        try (DataSet ds = DB.queryDataSet((String)"queryViewMemberId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    viewMemberIds.add(row.getLong("fid"));
                }
            }
        }
        return viewMemberIds;
    }

    public static Set<Long> queryBaseViewMemberId(@NotNull Long modelId, @NotNull Long dimensionId) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_eb_dimensionview where fbaseviewid in (select fid from t_eb_dimensionview where fmodelid = ? and fdimensionid = ? and fsource = '1')", new Object[]{modelId, dimensionId});
        LinkedHashSet viewIds = Sets.newLinkedHashSet();
        LinkedHashSet viewMemberIds = Sets.newLinkedHashSetWithExpectedSize((int)128);
        try (DataSet ds = DB.queryDataSet((String)"queryViewMemberId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);){
            if (ds != null) {
                for (Row row : ds) {
                    viewIds.add(row.getLong("fid"));
                }
            }
        }
        if (!viewIds.isEmpty()) {
            sql = new SqlBuilder();
            sql.append("select fid, fmemberid from t_eb_viewmember where fmodelid = ? and ", new Object[]{modelId}).appendIn("fviewid", viewIds.toArray()).append(" and fmembersource = '1'", new Object[0]);
            ds = DB.queryDataSet((String)"queryViewMemberId", (DBRoute)BgBaseConstant.epm, (SqlBuilder)sql);
            var6_6 = null;
            try {
                if (ds != null) {
                    for (Row row : ds) {
                        viewMemberIds.add(row.getLong("fmemberid"));
                    }
                }
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var6_6 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return viewMemberIds;
    }

    public static void openMultiDimMemberF7(List<String> dimNums, Long modelId, Long bizModelId, boolean showVrMember, IFormView formView, Map<String, Object> formParam, CloseCallBack closeCallBack) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("eb_batseldimgroupmemb");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        if (IDUtils.isNotEmptyLong(bizModelId).booleanValue()) {
            formShowParameter.setCustomParam("KEY_BUSMODEL_ID", (Object)bizModelId);
        }
        formShowParameter.setCustomParam("mutildimf7_dimNums", dimNums);
        formShowParameter.setCustomParam("mutildimf7_showVr", (Object)showVrMember);
        if (formParam != null) {
            formShowParameter.getCustomParams().putAll(formParam);
        }
        if (closeCallBack != null) {
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        formView.showForm(formShowParameter);
    }
}

