/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.member.f7;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.params.ParamEnum;
import kd.epm.eb.common.params.ParamQueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.cache.Cache;

public class MemberParamsUtils {
    private static final Log log = LogFactory.getLog(MemberParamsUtils.class);
    public static final String SELECTED_DIMS = "selecteddims";
    public static final String LONG_NAMENUM_DISPLAY = "longnamenumdisplay";
    public static final String USER_DEFINED_DIM = "userdefineddim";
    public static final String PERIOD_USERDEFINE = "perioduserdefine";
    public static final String BUDGET_MEMBER_F7_PARAMS_CACHE = "BUDGET_MEMBER_F7_PARAMS_CACHE";
    public static final String BUDGET_LONG_NAMENUM_DISPLAY_PARAMS_CACHE = "BUDGET_LONG_NAMENUM_DISPLAY_PARAMS_CACHE";
    public static final Long F7PARAMS_BGMD_NODE_ID = 13L;
    public static final Long F7PARAMS_EB_NODE_ID = 15L;

    public static F7Params getF7ParamsByCache(long modelId) {
        F7Params f7Params;
        String paramJson = Cache.get().get(BUDGET_MEMBER_F7_PARAMS_CACHE + modelId);
        if (StringUtils.isEmpty(paramJson)) {
            f7Params = MemberParamsUtils.getF7Params(modelId);
            if (f7Params == null) {
                f7Params = new F7Params(modelId, null);
            }
            Cache.get().set(BUDGET_MEMBER_F7_PARAMS_CACHE + modelId, JSON.toJSONString((Object)f7Params));
        } else {
            f7Params = (F7Params)JSON.parseObject((String)paramJson, F7Params.class);
        }
        return f7Params;
    }

    public static List<String> getLongNameNumDisplayParamsByCache(long modelId) {
        List longNameNumDisplayParams;
        String paramJson = Cache.get().get(BUDGET_LONG_NAMENUM_DISPLAY_PARAMS_CACHE + modelId);
        if (StringUtils.isEmpty(paramJson)) {
            longNameNumDisplayParams = MemberParamsUtils.getLongNameNumDisplayParams(modelId);
            Cache.get().set(BUDGET_LONG_NAMENUM_DISPLAY_PARAMS_CACHE + modelId, SerializationUtils.toJsonString((Object)longNameNumDisplayParams));
        } else {
            longNameNumDisplayParams = (List)SerializationUtils.fromJsonString((String)paramJson, List.class);
        }
        return longNameNumDisplayParams;
    }

    public static void clearF7ParamsByCache(long modelId) {
        Cache.get().remove(BUDGET_MEMBER_F7_PARAMS_CACHE + modelId);
    }

    public static void clearLongNameNumDisplayParamsByCache(long modelId) {
        Cache.get().remove(BUDGET_LONG_NAMENUM_DISPLAY_PARAMS_CACHE + modelId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static F7Params getF7Params(long modelId) {
        if (IDUtils.isNull(modelId)) {
            return null;
        }
        LogStats stats = new LogStats("budget-log : ");
        stats.addInfo("begin-load-f7Params.");
        F7Params f7Params = null;
        try {
            List dimValueIds = (List)ParamQueryServiceHelper.getChildValue(modelId, ParamEnum.BG029, SELECTED_DIMS);
            f7Params = MemberParamsUtils.parseF7Params(modelId, dimValueIds);
        }
        catch (Exception ex) {
            log.error("params-parse-error", (Throwable)ex);
        }
        finally {
            stats.add("end-load-f7Params.");
            log.info(stats.toString());
        }
        return f7Params;
    }

    public static List<String> getLongNameNumDisplayParams(long modelId) {
        ArrayList<String> longNameNumDisplays = new ArrayList<String>(16);
        if (IDUtils.isNull(modelId)) {
            return longNameNumDisplays;
        }
        String paramJson = "";
        try {
            String longNameNumDisplayParam = ParamQueryServiceHelper.getChildString(modelId, ParamEnum.BG030, LONG_NAMENUM_DISPLAY);
            if (longNameNumDisplayParam != null) {
                String[] split;
                for (String param : split = longNameNumDisplayParam.split(",")) {
                    if (!StringUtils.isNotEmpty(param)) continue;
                    longNameNumDisplays.add(param);
                }
            }
        }
        catch (Exception ex) {
            log.error("longnamenumdisplay-params-parse-error", (Throwable)ex);
        }
        return longNameNumDisplays;
    }

    public static boolean isPeriodUserDefine(long modelId) {
        if (IDUtils.isNull(modelId)) {
            return false;
        }
        return ParamQueryServiceHelper.getBoolean(modelId, ParamEnum.BG033);
    }

    public static F7Params parseF7Params(Long modelId, List<Long> dimValueIds) {
        F7Params f7Params = null;
        if (dimValueIds != null) {
            f7Params = new F7Params(modelId, new HashSet<Long>(dimValueIds));
        }
        return f7Params;
    }

    public static F7Params parseF7Params(Map params) {
        if (params == null) {
            return null;
        }
        F7Params f7Params = null;
        Optional modelOpt = Optional.ofNullable(params.get("model"));
        Optional dimOpt = Optional.ofNullable(params.get(SELECTED_DIMS));
        if (modelOpt.isPresent() && dimOpt.isPresent()) {
            Object modelValue = modelOpt.get();
            Object dimValue = dimOpt.get();
            long modelId = 0L;
            try {
                if (modelValue instanceof Map) {
                    modelId = IDUtils.toLong(((Map)modelValue).get("id"));
                }
            }
            catch (Exception ex) {
                log.error("model-parse-error:" + params);
            }
            LinkedHashSet<Long> dimIds = new LinkedHashSet<Long>(32);
            try {
                if (dimValue instanceof List) {
                    List dims = (List)dimValue;
                    for (Object _dimObj : dims) {
                        Object value;
                        if (!(_dimObj instanceof Map) || !((value = ((Map)_dimObj).get("fbasedataid")) instanceof Map)) continue;
                        try {
                            Long dimId = IDUtils.toLong(((Map)value).get("id"));
                            if (!IDUtils.isNotNull(dimId)) continue;
                            dimIds.add(dimId);
                        }
                        catch (Exception ex) {
                            log.error("dimIds-parse-error:" + JSON.toJSONString(_dimObj));
                        }
                    }
                }
            }
            catch (Exception ex) {
                log.error("dimIds-parse-error:" + params);
            }
            f7Params = new F7Params(modelId, dimIds);
        }
        return f7Params;
    }

    public static class F7Params {
        private long modelId;
        private Set<Long> selectedDims;

        public F7Params(long modelId, Set<Long> selectedDims) {
            this.modelId = modelId;
            this.selectedDims = selectedDims;
        }

        public long getModelId() {
            return this.modelId;
        }

        public Set<Long> getSelectedDims() {
            return this.selectedDims;
        }
    }
}

