/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.membpermlog;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.common.constant.BgFormConstant;
import kd.epm.eb.common.membpermlog.MembPermOpType;
import kd.epm.eb.common.membpermlog.MembPermType;
import kd.epm.eb.common.membpermlog.PermOpLogObj;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.UserUtils;

public class EbMembPermLogHelper {
    private static final Log log = LogFactory.getLog(EbMembPermLogHelper.class);
    private static final String insertSql = "insert into t_eb_membpermupdatelog(fid,fuser,fmodel,fdimshortnumstr,fbizctrlrange,ftargetuser,ftargetusergroup,fpermtype,floginfo,fdatetime,foptype) values(?,?,?,?,?,?,?,?,?,?,?)";

    public static void addOpLog(Long modelId, String dimShortNumStr, Long bcrId, Long targetUser, MembPermType permType, String logInfo, MembPermOpType opType) {
        if (logInfo != null && logInfo.length() > 2000) {
            logInfo = logInfo.substring(0, 2000);
        }
        if (dimShortNumStr == null) {
            dimShortNumStr = "";
        }
        Long userId = UserUtils.getUserId();
        Timestamp now = new Timestamp(TimeServiceHelper.now().getTime());
        Object[] values = new Object[]{GlobalIdUtil.genGlobalLongId(), userId, modelId, dimShortNumStr, bcrId, targetUser, targetUser, Character.valueOf(permType.getValue()), logInfo, now, Character.valueOf(opType.getValue())};
        ArrayList<Object[]> valueList = new ArrayList<Object[]>(16);
        valueList.add(values);
        EbMembPermLogHelper.saveLog(valueList);
    }

    private static void saveLog(List<Object[]> values) {
        try {
            DB.executeBatch((DBRoute)BgFormConstant.DBROUTE, (String)insertSql, values);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static void addOpLog(List<PermOpLogObj> opLogObjs) {
        if (opLogObjs == null || opLogObjs.isEmpty()) {
            return;
        }
        ArrayList<Object[]> valueList = new ArrayList<Object[]>(16);
        opLogObjs.forEach(logObj -> valueList.add(logObj.getValues()));
        EbMembPermLogHelper.saveLog(valueList);
    }
}

