/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.message;

import java.util.List;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.epm.eb.common.utils.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MessageUtils {
    public static MessageUtils get() {
        return new MessageUtils();
    }

    public void sendMessage(@NotNull String entityNumber, String title, String context, @NotNull List<Long> receivers, @NotNull MessageType type) {
        this.sendMessageWithSender(entityNumber, title, context, receivers, type, null, null);
    }

    public void sendMessageWithSender(@NotNull String entityNumber, String title, String context, @NotNull List<Long> receivers, @NotNull MessageType type, Long sender, String tag) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTitle(title);
        messageInfo.setContent(context);
        messageInfo.setUserIds(receivers);
        messageInfo.setSenderId(sender);
        messageInfo.setType("message");
        messageInfo.setEntityNumber(entityNumber);
        messageInfo.setNotifyType(type.getNumber());
        messageInfo.setPubaccNumber(PublicType.SYSTEM_PUB_ACC.number);
        if (StringUtils.isNotEmpty(tag)) {
            messageInfo.setTag(tag);
        }
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public void sendMessageWithSender(@NotNull String entityNumber, String title, String context, @NotNull List<Long> receivers, @NotNull MessageType type, Long sender, String tag, String url) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setTitle(title);
        messageInfo.setContent(context);
        messageInfo.setUserIds(receivers);
        messageInfo.setSenderId(sender);
        messageInfo.setType("message");
        messageInfo.setEntityNumber(entityNumber);
        messageInfo.setNotifyType(type.getNumber());
        messageInfo.setPubaccNumber(PublicType.SYSTEM_PUB_ACC.number);
        if (StringUtils.isNotEmpty(tag)) {
            messageInfo.setTag(tag);
        }
        messageInfo.setContentUrl(url);
        MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public static enum PublicType {
        SYSTEM_PUB_ACC("systempubacc");

        private String number;

        private PublicType(String number) {
            this.number = number;
        }

        public String getNumber() {
            return this.number;
        }
    }

    public static enum MessageType {
        SMS("sms"),
        YUNZHIJIA("yunzhijia");

        private String number;

        private MessageType(String number) {
            this.number = number;
        }

        public String getNumber() {
            return this.number;
        }
    }
}

