/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.utils.BgDataUtils;
import kd.epm.eb.common.utils.StringUtils;

public class BgData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2614305094576458132L;
    private Long modelId = null;
    private Long datasetId = null;
    private Map<String, String> memberMap = new Hashtable<String, String>();
    private BigDecimal value = null;
    private String dataKeyOfPCV = null;
    private String dataKey = null;
    private Long dimKey = null;
    private boolean ignore = false;

    public BgData() {
    }

    public BgData(Long modelId) {
        this.modelId = modelId;
    }

    public BgData(Long modelId, Map<String, String> memberMap) {
        this.modelId = modelId;
        if (memberMap != null) {
            this.memberMap.putAll(memberMap);
        }
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public Long getModelId() {
        return this.modelId;
    }

    public void setDatasetId(Long datasetId) {
        this.datasetId = datasetId;
    }

    public Long getDatasetId() {
        return this.datasetId;
    }

    public Map<String, String> getMemberMap() {
        return this.memberMap;
    }

    public void setMemberMap(Map<String, String> memberMap) {
        this.memberMap = memberMap;
    }

    public void setMember(String dimNumber, String memberNumber) {
        if (StringUtils.isEmpty(dimNumber) || StringUtils.isEmpty(memberNumber)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\uff1a[%1] \u6216\u7ef4\u5ea6\u6210\u5458\uff1a[%2] \u4e3a\u7a7a\u3002", (String)"BgData_0", (String)"epm-eb-common", (Object[])new Object[]{dimNumber, memberNumber}));
        }
        this.dataKeyOfPCV = null;
        this.dataKey = null;
        this.memberMap.put(dimNumber, memberNumber);
    }

    public String getMemberNumber(String dimNumber) {
        return this.memberMap.get(dimNumber);
    }

    public String[] getMembers(String[] dimension) {
        if (dimension == null || dimension.length == 0) {
            return null;
        }
        String[] members = new String[dimension.length];
        int in = dimension.length;
        for (int i = 0; i < in; ++i) {
            members[i] = this.getMemberNumber(dimension[i]);
        }
        return members;
    }

    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public String getDataKey(Collection<Dimension> dimensions, boolean isIgnorePCV) {
        if (isIgnorePCV) {
            if (this.dataKeyOfPCV == null) {
                this.dataKeyOfPCV = BgDataUtils.getMemberKey(this, dimensions, BgDataUtils.getIgnDimNumbers());
            }
            return this.dataKeyOfPCV;
        }
        return this.getDataKey(dimensions);
    }

    public String getDataKey(Collection<Dimension> dimensions) {
        if (this.dataKey == null) {
            this.dataKey = BgDataUtils.getMemberKey(this, dimensions);
        }
        return this.dataKey;
    }

    public String getDataKey(String[] dimensions) {
        if (this.dataKey == null) {
            this.dataKey = BgDataUtils.getMemberKey(this, dimensions);
        }
        return this.dataKey;
    }

    public void setDimKey(Long dimKey) {
        this.dimKey = dimKey;
    }

    public Long getDimKey() {
        return this.dimKey;
    }

    public String getPeriodKey(boolean isEb) {
        return BgDataUtils.getPeriodKey(isEb, this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            return this.equalsData((BgData)obj);
        }
        return false;
    }

    public int hashCode() {
        if (this.dataKey != null) {
            return this.dataKey.hashCode();
        }
        return super.hashCode();
    }

    public boolean equalsData(BgData bgData) {
        if (bgData == null) {
            return false;
        }
        if (this == bgData) {
            return true;
        }
        return this.equalsData(bgData.getMemberMap());
    }

    public boolean equalsData(Map<String, String> members) {
        if (members == null || this.memberMap.size() != members.size()) {
            return false;
        }
        return this.memberMap.equals(members);
    }

    public BgData clone() {
        BgData clone = null;
        try {
            clone = (BgData)super.clone();
            clone.memberMap = new HashMap<String, String>();
            clone.memberMap.putAll(this.getMemberMap());
        }
        catch (CloneNotSupportedException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7b97\u6570\u636e\u514b\u9686\u5931\u8d25\u3002", (String)"BgData_1", (String)"epm-eb-common", (Object[])new Object[0]));
        }
        return clone;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean isIgnore() {
        return this.ignore;
    }
}

