/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.enums.BgControlPeriodTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberParamsUtils;
import kd.epm.eb.common.resource.ControlException;
import kd.epm.eb.common.utils.CalendarHelper;
import kd.epm.eb.common.utils.period.BgPeriodHelper;
import kd.epm.eb.common.utils.period.BgPeriodUtils;
import org.jetbrains.annotations.NotNull;

public class BgPeriodUserDefinedUtils {
    private Long modelId = null;
    private boolean isPeriodUserDefine = false;
    private Map<String, Map<String, List<DynamicObject>>> periodTimeMap = new HashMap<String, Map<String, List<DynamicObject>>>(10);
    private Map<String, DynamicObject> periodMap = new HashMap<String, DynamicObject>(16);

    public BgPeriodUserDefinedUtils(@NotNull Long modelId) {
        this.modelId = modelId;
        this.isPeriodUserDefine = MemberParamsUtils.isPeriodUserDefine(modelId);
        if (this.isPeriodUserDefine) {
            this.loadPeriods();
        }
    }

    public boolean isPeriodUserDefine() {
        return this.isPeriodUserDefine;
    }

    public Date parseBizTime(String periodNum) {
        return this.periodMap.get(periodNum).getDate("startdate");
    }

    public Date parseEndBizTime(String periodNum) {
        return this.periodMap.get(periodNum).getDate("enddate");
    }

    public String getPeriodNumber(int periodType, Date bizTime) {
        CalendarHelper calendar;
        String pnumber;
        List<DynamicObject> subList;
        if (bizTime == null) {
            return null;
        }
        Map<String, List<DynamicObject>> subMap = this.periodTimeMap.get(String.valueOf(periodType));
        if (subMap != null && (subList = subMap.get(pnumber = BgPeriodUtils.getBgPeriodMonth((calendar = new CalendarHelper(bizTime)).getCurrentlyYear(), calendar.getCurrentlyMonth()))) != null) {
            for (DynamicObject period : subList) {
                if (period.getDate("startdate").after(bizTime) || period.getDate("enddate").before(bizTime)) continue;
                return period.getString("number");
            }
        }
        String msg = ResManager.loadResFormat((String)"\u6ca1\u6709\u627e\u5230\u65e5\u671f\u4e3a%1\u7684\u9884\u7b97\u671f\u95f4\u3002", (String)"BgPeriodUserDefinedUtils_0", (String)"epm-eb-common", (Object[])new Object[]{new SimpleDateFormat("yyyy-MM-dd").format(bizTime)});
        ControlException.erorrOther(msg);
        return null;
    }

    private void loadPeriods() {
        QFilter qf = new QFilter("model", "=", (Object)this.modelId);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"epm_bperiodmembertree", (String)"id,number,startdate,enddate", (QFilter[])qf.toArray());
        CalendarHelper calendar = new CalendarHelper();
        int startYear = 0;
        int endYear = 0;
        int startMonth = 0;
        int endMonth = 0;
        int year = 0;
        int month = 0;
        int type = 0;
        String periodNumber = null;
        String periodType = null;
        if (periods != null) {
            for (DynamicObject period : periods) {
                BgPeriodHelper.PeriodType parse;
                periodNumber = period.getString("number");
                this.periodMap.put(periodNumber, period);
                if (SysDimensionEnum.BudgetPeriod.getNumber().equals(periodNumber) || (parse = BgPeriodHelper.parse(periodNumber)) == null) continue;
                type = parse.getType();
                if (1 == type) {
                    periodType = String.valueOf(BgControlPeriodTypeEnum.YEAR.getIndex());
                } else if (4 == type) {
                    periodType = String.valueOf(BgControlPeriodTypeEnum.MONTH.getIndex());
                } else if (2 == type) {
                    periodType = String.valueOf(BgControlPeriodTypeEnum.HALFYEAR.getIndex());
                } else {
                    if (3 != type) continue;
                    periodType = String.valueOf(BgControlPeriodTypeEnum.QUARTER.getIndex());
                }
                calendar.setTime(period.getDate("startdate"));
                startYear = calendar.getCurrentlyYear();
                startMonth = calendar.getCurrentlyMonth();
                calendar.setTime(period.getDate("enddate"));
                endYear = calendar.getCurrentlyYear();
                endMonth = calendar.getCurrentlyMonth() + (endYear - startYear) * 12;
                for (int m = startMonth; m <= endMonth; ++m) {
                    year = startYear + (m - 1) / 12;
                    month = m % 12;
                    if (month == 0) {
                        month = 12;
                    }
                    this.periodTimeMap.computeIfAbsent(periodType, f -> new HashMap(12)).computeIfAbsent(BgPeriodUtils.getBgPeriodMonth(year, month), f -> new ArrayList(10)).add(period);
                }
            }
        }
    }
}

