/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.model;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.model.BgDynamicObject;
import kd.epm.eb.common.model.BgPeriodUserDefinedUtils;
import kd.epm.eb.common.model.Dimension;

public class BizModel
extends BgDynamicObject {
    private static final long serialVersionUID = -2706829615722843962L;
    private static final String DIMENSION_NUM_MAP = "dimensionMap";
    private static final String DIMENSION_ID_MAP = "dimensionIdMap";
    private DynamicObject startVersion = null;
    private Long controlManagerId = 0L;
    private Long busModelId = null;
    private Set<Long> controlDims = null;
    private Map<String, Long> view = null;
    private transient IModelCacheHelper modelCacheHelper = null;
    private transient BgPeriodUserDefinedUtils periodUtils = null;

    public BizModel(DynamicObject model) {
        super(model);
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f53\u7cfb\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4f53\u7cfb\u7f16\u7801\u3002", (String)"BizModel_0", (String)"epm-eb-common", (Object[])new Object[0]));
        }
    }

    @Override
    public Long getId() {
        return this.getObject().getLong("id");
    }

    public Long getKey() {
        return BizModel.getKey(this.getId(), this.getControlBusModelId());
    }

    public static Long getKey(Long modelId, Long bussModelId) {
        if (bussModelId != null && bussModelId != 0L) {
            return bussModelId;
        }
        return modelId;
    }

    public String getNumber() {
        return this.getObject().getString("shownumber");
    }

    public String getName() {
        return this.getObject().getString("name");
    }

    public String getCubeNumber() {
        return this.getObject().getString("number");
    }

    public String getCreator() {
        return this.getObject().getString("creator.name");
    }

    public Long getDataSourceId() {
        return this.getObject().getLong("datasource.id");
    }

    public void setDimension(List<Dimension> dimensions) {
        this.set("dimensions", dimensions);
        this.addDimensions(dimensions);
    }

    public List<Dimension> getDimensions() {
        return (List)this.get("dimensions");
    }

    public String[] getDimensionArrays() {
        List<Dimension> dimensions = this.getDimensions();
        String[] dims = new String[dimensions.size()];
        int in = dimensions.size();
        for (int i = 0; i < in; ++i) {
            dims[i] = dimensions.get(i).getNumber();
        }
        return dims;
    }

    public Collection<Dimension> getUserDefinedDimensions() {
        ArrayList<Dimension> userDefine = new ArrayList<Dimension>();
        List all = (List)this.get("dimensions");
        if (all != null) {
            for (Dimension dim : all) {
                if (!dim.getMemberModel().equalsIgnoreCase("epm_userdefinedmembertree") && !dim.getMemberModel().equalsIgnoreCase("bcm_userdefinedmembertree")) continue;
                userDefine.add(dim);
            }
        }
        return userDefine;
    }

    protected void addDimensions(Collection<Dimension> dimensions) {
        if (dimensions != null && !dimensions.isEmpty()) {
            HashMap dimensionMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
            HashMap dimensionIdMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
            for (Dimension dimension : dimensions) {
                dimensionMap.put(dimension.getNumber(), dimension);
                dimensionIdMap.put(dimension.getId(), dimension);
            }
            this.set(DIMENSION_NUM_MAP, dimensionMap);
            this.set(DIMENSION_ID_MAP, dimensionIdMap);
        }
    }

    public Map<String, Dimension> getDimensionMap() {
        return Collections.unmodifiableMap((Map)this.get(DIMENSION_NUM_MAP));
    }

    public Map<String, kd.epm.eb.common.cache.impl.Dimension> getDimensionMap(IModelCacheHelper modelCacheHelper) {
        if (modelCacheHelper == null) {
            return null;
        }
        List<Dimension> dimensions = this.getDimensions();
        HashMap dimensionMap = Maps.newHashMapWithExpectedSize((int)dimensions.size());
        for (Dimension dimension : dimensions) {
            kd.epm.eb.common.cache.impl.Dimension _dimension = modelCacheHelper.getDimension(dimension.getNumber());
            if (_dimension == null) continue;
            dimensionMap.put(_dimension.getNumber(), _dimension);
        }
        return dimensionMap;
    }

    public Dimension getDimension(String dimensionNumber) {
        if (dimensionNumber == null) {
            return null;
        }
        Object dimensions = this.get(DIMENSION_NUM_MAP);
        if (dimensions instanceof Map) {
            return (Dimension)((Map)dimensions).get(dimensionNumber);
        }
        return null;
    }

    public Dimension getDimension(Long dimensionId) {
        if (dimensionId == null || dimensionId == 0L) {
            return null;
        }
        Object dimensions = this.get(DIMENSION_ID_MAP);
        if (dimensions instanceof Map) {
            return (Dimension)((Map)dimensions).get(dimensionId);
        }
        return null;
    }

    public void setStartVersion(DynamicObject startVersion) {
        this.startVersion = startVersion;
    }

    public DynamicObject getStartVersion() {
        return this.startVersion;
    }

    public void setControlManagerId(Long controlManagerId) {
        this.controlManagerId = controlManagerId;
    }

    public Long getControlManagerId() {
        return this.controlManagerId;
    }

    public void setControlBusModelId(Long busModelId) {
        this.busModelId = busModelId;
    }

    public Long getControlBusModelId() {
        if (this.busModelId == null) {
            return 0L;
        }
        return this.busModelId;
    }

    public void setControlDims(Set<Long> controlDims) {
        this.controlDims = controlDims;
    }

    public Set<Long> getControlDims() {
        return this.controlDims;
    }

    public void setView(Map<String, Long> view) {
        this.view = view;
    }

    public Map<String, Long> getView() {
        return this.view;
    }

    public List<Dimension> filterControlDims(List<Dimension> dimensions) {
        if (this.getControlBusModelId() == null || this.getControlBusModelId() == 0L || this.getControlDims() == null || dimensions == null) {
            return dimensions;
        }
        ArrayList<Dimension> filterDims = new ArrayList<Dimension>(dimensions.size());
        for (Dimension dimension : dimensions) {
            if (!this.getControlDims().contains(dimension.getId())) continue;
            filterDims.add(dimension);
        }
        return filterDims;
    }

    public boolean isEBByModel() {
        String reportType = (String)this.get("reporttype");
        if (reportType == null) {
            reportType = ApplicationTypeEnum.EB.getIndex();
        }
        return ApplicationTypeEnum.isEB(ApplicationTypeEnum.getEnumByIndex(reportType));
    }

    public boolean isNewEBByModel() {
        String reportType = (String)this.get("reporttype");
        if (reportType == null) {
            reportType = ApplicationTypeEnum.EB.getIndex();
        }
        return ApplicationTypeEnum.isNewBG(ApplicationTypeEnum.getEnumByIndex(reportType));
    }

    public static boolean isEBByModel(DynamicObject model) {
        if (model == null || model.getString("reporttype") == null) {
            throw new KDBizException("model or reportType is null.");
        }
        return ApplicationTypeEnum.EB.getIndex().equals(model.getString("reporttype"));
    }

    public static boolean isNewEBByModel(DynamicObject model) {
        if (model == null || model.getString("reporttype") == null) {
            throw new KDBizException("model or reportType is null.");
        }
        return ApplicationTypeEnum.BG.getIndex().equals(model.getString("reporttype"));
    }

    public static boolean isBgmdModel(DynamicObject model) {
        if (model == null || model.getString("reporttype") == null) {
            throw new KDBizException("model or reportType is null.");
        }
        return ApplicationTypeEnum.BGMD.getIndex().equals(model.getString("reporttype"));
    }

    public String getReportType() {
        return this.getString("reporttype");
    }

    public String getBgControlRecordTable() {
        if (this.isEBByModel()) {
            return "t_eb_bgcontrolrecord";
        }
        return BizModel.getBgControlRecordTable(this.getControlBusModelId());
    }

    public static String getBgControlRecordTable(Long controlBusModelId) {
        return "t_eb_cr" + controlBusModelId;
    }

    public IModelCacheHelper getModelCache() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate(this.getId());
        }
        return this.modelCacheHelper;
    }

    public BgPeriodUserDefinedUtils getPeriodUtils() {
        if (this.periodUtils == null) {
            this.periodUtils = new BgPeriodUserDefinedUtils(this.getId());
        }
        return this.periodUtils;
    }
}

