/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.model.Dimension;

public class Member
implements Serializable {
    private static final long serialVersionUID = -539993600615079023L;
    private Long id = null;
    private String name = null;
    private String simpleName = null;
    private String type = null;
    private boolean exclude = false;
    private String number = null;
    private String showNumber = null;
    private String longNumber = null;
    private int level = 0;
    private boolean isLeaf = false;
    private int range = RangeEnum.ONLY.getIndex();
    private Dimension dimension = null;
    private transient boolean ignore = false;
    private boolean isMapping = false;
    private Long viewId = null;
    private Boolean isProperty = false;

    public Member() {
    }

    public final void setId(Long id) {
        this.id = id;
    }

    public final Long getId() {
        return this.id;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final String getSimpleName() {
        return this.simpleName;
    }

    public final void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public final void setType(String type) {
        this.type = type;
    }

    public final String getType() {
        return this.type;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public static Member loadFromDynamicObject(DynamicObject object) {
        DynamicObject _dimension;
        if (object == null) {
            return null;
        }
        HashMap<String, IDataEntityProperty> propMap = new HashMap<String, IDataEntityProperty>();
        if (object.getDataEntityType() != null) {
            DataEntityPropertyCollection props = object.getDataEntityType().getProperties();
            for (IDataEntityProperty prop : props) {
                propMap.put(prop.getName(), prop);
            }
        }
        Member member = new Member(object.getLong("id"));
        if (propMap.containsKey("name")) {
            member.name = object.getString("name");
        }
        if (propMap.containsKey("number")) {
            member.number = object.getString("number");
        }
        if (propMap.containsKey("simpleName")) {
            member.simpleName = object.getString("simpleName");
        }
        if (propMap.containsKey("longnumber")) {
            member.longNumber = object.getString("longnumber");
        }
        if (propMap.containsKey("isleaf")) {
            member.isLeaf = object.getBoolean("isleaf");
        }
        if (propMap.containsKey("shownumber")) {
            member.showNumber = object.getString("shownumber");
        }
        if (propMap.containsKey("dimension") && (_dimension = object.getDynamicObject("dimension")) != null) {
            member.dimension = Dimension.loadFromDynamicobject(_dimension);
        }
        return member;
    }

    public static Member loadFormCache(kd.epm.eb.common.cache.impl.Member object) {
        if (object == null) {
            return null;
        }
        Member member = new Member(object.getId());
        member.name = object.getName();
        member.simpleName = object.getSimpleName();
        member.number = object.getNumber();
        member.longNumber = object.getLongNumber();
        member.isLeaf = object.isLeaf();
        member.level = object.getLevel();
        member.showNumber = object.getShowNumber();
        if (object.getDimension() != null) {
            member.setDimension(Dimension.loadFormCache(object.getDimension()));
        }
        return member;
    }

    public final void setNumber(String number) {
        this.number = number;
    }

    public final String getNumber() {
        return this.number;
    }

    public void setShowNumber(String showNumber) {
        this.showNumber = showNumber;
    }

    public String getShowNumber() {
        return this.showNumber;
    }

    public final void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public final String getLongNumber() {
        return this.longNumber;
    }

    public final int getLevel() {
        return this.level;
    }

    public final void setLevel(int level) {
        this.level = level;
    }

    public final void setLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public final boolean isLeaf() {
        return this.isLeaf;
    }

    public final void setRange(int range) {
        this.range = range;
    }

    public final int getRange() {
        return this.range;
    }

    public final void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public final Dimension getDimension() {
        return this.dimension;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setMapping(boolean isMapping) {
        this.isMapping = isMapping;
    }

    public boolean isMapping() {
        return this.isMapping;
    }

    public void setViewId(Long viewId) {
        this.viewId = viewId;
    }

    public Long getViewId() {
        return this.viewId;
    }

    public void setIsProperty(Boolean isProperty) {
        this.isProperty = isProperty;
    }

    public Boolean isProperty() {
        return this.isProperty;
    }

    public Member(Long id, String name, String number) {
        this.id = id;
        this.name = name;
        this.number = number;
    }

    public Member(Long id, String name, String number, int range) {
        this.id = id;
        this.name = name;
        this.number = number;
        this.range = range;
    }

    public Member(Long id, String name, String number, Boolean isProperty) {
        this.id = id;
        this.name = name;
        this.number = number;
        this.isProperty = isProperty;
    }

    public Member(Long id) {
        this.id = id;
    }

    public Member(Dimension dimension) {
        this.dimension = dimension;
    }

    public static Member loadFromCacheMember(kd.epm.eb.common.cache.impl.Member object) {
        if (object == null) {
            return null;
        }
        Member member = new Member(object.getId());
        member.name = object.getName();
        member.number = object.getNumber();
        member.longNumber = object.getLongNumber();
        member.isLeaf = object.isLeaf();
        return member;
    }

    public static Member loadFromDynamicObject(Map<String, Object> object) {
        if (object == null || object.isEmpty()) {
            return null;
        }
        Member member = new Member((Long)object.get("id"));
        member.name = (String)object.get("name");
        member.number = (String)object.get("number");
        member.longNumber = (String)object.get("longnumber");
        member.isLeaf = (Boolean)object.get("isleaf");
        return member;
    }

    public Member copy() {
        Member clone = new Member(this.getId(), this.getName(), this.getNumber());
        clone.setSimpleName(this.getSimpleName());
        clone.setLongNumber(this.getLongNumber());
        clone.setLevel(this.getLevel());
        clone.setLeaf(this.isLeaf());
        clone.setRange(this.getRange());
        clone.setIgnore(this.isIgnore());
        clone.setShowNumber(this.getShowNumber());
        return clone;
    }

    public static Member of(kd.epm.eb.common.cache.impl.Member member) {
        Member _clone = null;
        if (member != null) {
            _clone = new Member();
            _clone.setNumber(member.getNumber());
            _clone.setName(member.getName());
        }
        return _clone;
    }

    public String toString() {
        return this.getNumber();
    }
}

