/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.common.model;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;

public class MemberEntity
implements Serializable {
    private Long id = 0L;
    private String number;
    private String name;
    private int storagetype = 1;
    private Long parentId = 0L;
    private boolean enable = true;
    private int dseq;
    private Map<String, Object> otherData;
    private Set<MemberEntity> childs;

    public MemberEntity(long id, long parentId, String name, String number, int storagetype, int dseq) {
        this.id = id;
        this.name = name;
        this.parentId = parentId;
        this.number = number;
        this.storagetype = storagetype;
        this.dseq = dseq;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getOtherData() {
        if (this.otherData == null) {
            this.otherData = new HashMap<String, Object>();
        }
        return this.otherData;
    }

    public void setOtherData(Map<String, Object> otherData) {
        this.otherData = otherData;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public Set<MemberEntity> getChilds() {
        if (this.childs == null) {
            this.childs = new TreeSet<MemberEntity>(new MembComparator());
        }
        return this.childs;
    }

    public void setChilds(Set<MemberEntity> childs) {
        this.childs = childs;
    }

    public void addChild(MemberEntity child) {
        if (this.childs == null) {
            this.childs = new TreeSet<MemberEntity>(new MembComparator());
        }
        this.childs.add(child);
    }

    public void iterate(int maxLevel, Consumer<MemberEntity> callback) {
        callback.accept(this);
        if (maxLevel > 0 && !this.getChilds().isEmpty()) {
            for (MemberEntity child : this.getChilds()) {
                child.iterate(maxLevel - 1, callback);
            }
        }
    }

    public int getStoragetype() {
        return this.storagetype;
    }

    public void setStoragetype(int storagetype) {
        this.storagetype = storagetype;
    }

    public int getDseq() {
        return this.dseq;
    }

    public void setDseq(int dseq) {
        this.dseq = dseq;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    static class MembComparator
    implements Comparator<MemberEntity>,
    Serializable {
        MembComparator() {
        }

        @Override
        public int compare(MemberEntity o1, MemberEntity o2) {
            int sub = o1.dseq - o2.dseq;
            return sub == 0 ? 2 : sub;
        }
    }
}

